/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocAgreementItemOrderPurchaseAbilityService;
import com.tydic.uoc.common.ability.bo.UocAgreementItemOrderPurchasRspBO;
import com.tydic.uoc.common.ability.bo.UocAgreementItemOrderPurchaseAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocAgreementItemOrderPurchaseAbilityRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.po.OrdItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocAgreementItemOrderPurchaseAbilityService"})
public class UocAgreementItemOrderPurchaseAbilityServiceImpl
implements UocAgreementItemOrderPurchaseAbilityService {
    @Autowired
    private OrdItemMapper ordItemMapper;

    @PostMapping(value={"searchPurchaseCount"})
    public UocAgreementItemOrderPurchaseAbilityRspBO searchPurchaseCount(@RequestBody UocAgreementItemOrderPurchaseAbilityReqBO reqBO) {
        this.validate(reqBO);
        UocAgreementItemOrderPurchaseAbilityRspBO rspBO = new UocAgreementItemOrderPurchaseAbilityRspBO();
        try {
            List items;
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setAgreementSkuItems(reqBO.getAgreementSkuItems());
            List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
            ArrayList<UocAgreementItemOrderPurchasRspBO> resultItems = new ArrayList<UocAgreementItemOrderPurchasRspBO>();
            HashSet<Long> agreementItems = new HashSet<Long>();
            if (CollectionUtils.isEmpty((Collection)ordItemPOS)) {
                for (Long agreementSkuItem : reqBO.getAgreementSkuItems()) {
                    resultItems.add(new UocAgreementItemOrderPurchasRspBO(agreementSkuItem + "", BigDecimal.ZERO));
                }
            } else {
                Map<String, OrdItemPO> OrdItemPOMap = ordItemPOS.stream().collect(Collectors.toMap(e -> e.getExtField1(), e -> e, (k, v) -> k));
                for (Long agreementSkuItem : reqBO.getAgreementSkuItems()) {
                    if (OrdItemPOMap.get(agreementSkuItem + "") == null) {
                        resultItems.add(new UocAgreementItemOrderPurchasRspBO(agreementSkuItem + "", BigDecimal.ZERO));
                        continue;
                    }
                    agreementItems.add(agreementSkuItem);
                }
            }
            if (!CollectionUtils.isEmpty(agreementItems) && !CollectionUtils.isEmpty((Collection)(items = this.ordItemMapper.getPurchaseCountByAgreementItemIds(new ArrayList(agreementItems))))) {
                resultItems.addAll(items);
            }
            rspBO.setRespCode("0000");
            rspBO.setItems(resultItems);
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e2) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e2.getMessage());
        }
        return rspBO;
    }

    private void validate(UocAgreementItemOrderPurchaseAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgreementSkuItems())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010agreementSkuItems\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

