/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.api.UocChooseAuditAbilityService;
import com.tydic.uoc.common.ability.bo.UocChooseAuditAbilityBO;
import com.tydic.uoc.common.ability.bo.UocChooseAuditAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocChooseAuditBusiBO;
import com.tydic.uoc.common.ability.bo.UocChooseAuditBusinessListReqBO;
import com.tydic.uoc.common.ability.bo.UocChooseAuditUserAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocChooseAuditUserAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocQryLastPidBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.busi.api.UocChooseAuditBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrderTaskInstMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrderTaskInstPo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocChooseAuditAbilityService"})
public class UocChooseAuditAbilityServiceImpl
implements UocChooseAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocChooseAuditAbilityServiceImpl.class);
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocChooseAuditBusiService uocChooseAuditBusiService;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @PostMapping(value={"qryList"})
    public UocChooseAuditAbilityRspBO qryList(@RequestBody UocChooseAuditBusinessListReqBO reqBO) {
        UocChooseAuditAbilityRspBO rspBO = new UocChooseAuditAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UocChooseAuditBusiBO selectParam = new UocChooseAuditBusiBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectParam);
        DycUmcQueryOrgPermissionReqBo dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
        dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
        DycUmcQueryOrgPermissionRspBo dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission(dycUmcQueryMaterialPermissionReqBo);
        if (!"0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u5355\u4f4d\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
        }
        List orgPermissions = dycUmcQueryMaterialPermissionRspBo.getRows();
        List orgIds = orgPermissions.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryOrgPermissionBo::getOrgId).map(String::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgIds)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7528\u6237\u7684\u5355\u4f4d\u6743\u9650\u4e3a\u7a7a");
            rspBO.setRows(null);
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        selectParam.setOrgCodes(orgIds);
        selectParam.setSaleStatus(UocConstant.SALE_ORDER_STATUS.WAIT_CHOOSE_USER);
        List ordSalePOS = this.ordSaleMapper.qryChooseAuditList(selectParam, page);
        if (CollectionUtils.isEmpty((Collection)ordSalePOS) || 0 == ordSalePOS.size()) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        List<UocChooseAuditAbilityBO> uocChooseAuditAbilityBOS = this.convertOrdToObj(ordSalePOS);
        rspBO.setRows(uocChooseAuditAbilityBOS);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private List<UocChooseAuditAbilityBO> convertOrdToObj(List<OrdSalePO> ordSalePOS) {
        Map<String, String> saleOrderStatus = this.selectDicValByPcodeAndCode.getValueByPCode("SALE_ORDER_STATUS");
        return ordSalePOS.stream().map(item -> {
            UocChooseAuditAbilityBO model = new UocChooseAuditAbilityBO();
            model.setAuditStatus(item.getSaleState());
            model.setAuditStatusStr((String)saleOrderStatus.get(item.getSaleState().toString()));
            model.setObjCode(item.getSaleVoucherNo());
            model.setObjName(item.getOrderName());
            model.setCreateUserCode(item.getCreateUserCode());
            model.setCreateUserName(item.getCreateUserName());
            model.setObjId(item.getOrderId());
            return model;
        }).collect(Collectors.toList());
    }

    @PostMapping(value={"getProcInstId"})
    public UocQryLastPidBO getProcInstId(@RequestBody UocQryLastPidBO reqBO) {
        UocQryLastPidBO resBO = new UocQryLastPidBO();
        UocOrderTaskInstPo instPO = new UocOrderTaskInstPo();
        instPO.setObjId(reqBO.getObjId());
        UocOrderTaskInstPo last = this.uocOrderTaskInstMapper.getLastPid(instPO);
        if (Objects.nonNull(last)) {
            resBO.setProcInstId(last.getProcInstId());
            resBO.setObjId(last.getObjId());
        }
        resBO.setRespCode("0000");
        resBO.setRespDesc("\u6210\u529f");
        return resBO;
    }

    @PostMapping(value={"chooseAuditUser"})
    public UocChooseAuditUserAbilityRspBO chooseAuditUser(@RequestBody UocChooseAuditUserAbilityReqBO reqBO) {
        UocChooseAuditUserAbilityRspBO rspBO = this.uocChooseAuditBusiService.chooseAuditUser(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setObjId(rspBO.getSaleVoucherId());
            syncReqBO.setOrderId(reqBO.getObjId());
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
        }
        return rspBO;
    }
}

