/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractDownloadSignDocumentAbilityService;
import com.tydic.contract.ability.ContractQrySignInitiatorInfoAbilityService;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.UocDealSignatureInitSyncAbilityService;
import com.tydic.uoc.common.ability.bo.UocDealSignatureInitSyncReqBo;
import com.tydic.uoc.common.ability.bo.UocDealSignatureInitSyncRspBo;
import com.tydic.uoc.common.atom.api.UocSignAccessTokenCreateAtomService;
import com.tydic.uoc.common.atom.api.UocSignGetEnvelopesDetailAtomService;
import com.tydic.uoc.common.atom.bo.UocEnvelopeParticipantAtomBo;
import com.tydic.uoc.common.atom.bo.UocSignAccessTokenCreateAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSignAccessTokenCreateAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSignGetEnvelopesDetailAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSignGetEnvelopesDetailAtomRspBo;
import com.tydic.uoc.common.busi.api.UocDealSignatureInitSyncBusiService;
import com.tydic.uoc.common.busi.bo.UocDealSignatureInitSyncBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocDealSignatureInitSyncBusiRspBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocSignInitItemMapper;
import com.tydic.uoc.dao.UocSignatureInitMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocSignInitItemPO;
import com.tydic.uoc.po.UocSignatureInitPo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocDealSignatureInitSyncAbilityService"})
public class UocDealSignatureInitSyncAbilityServiceImpl
implements UocDealSignatureInitSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocDealSignatureInitSyncAbilityServiceImpl.class);
    @Autowired
    private UocSignatureInitMapper uocSignatureInitMapper;
    @Autowired
    private ContractQrySignInitiatorInfoAbilityService contractQrySignInitiatorInfoAbilityService;
    @Autowired
    private UocDealSignatureInitSyncBusiService uocDealSignatureInitSyncBusiService;
    @Autowired
    private UocSignAccessTokenCreateAtomService uocSignAccessTokenCreateAtomService;
    @Autowired
    private UocSignGetEnvelopesDetailAtomService uocSignGetEnvelopesDetailAtomService;
    @Autowired
    private ContractDownloadSignDocumentAbilityService contractDownloadSignDocumentAbilityService;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UocSignInitItemMapper uocSignInitItemMapper;

    @PostMapping(value={"dealSignatureInitSync"})
    public UocDealSignatureInitSyncRspBo dealSignatureInitSync(@RequestBody UocDealSignatureInitSyncReqBo reqBo) {
        UocSignatureInitPo uocSignatureInitPo = new UocSignatureInitPo();
        uocSignatureInitPo.setSignatureApprovalStatus(UocConstant.SignatureApprovalStatus.APPROVED);
        uocSignatureInitPo.setPushState(UocConstant.PushState.PUSH_SUCCESS);
        ArrayList<Integer> signatureStatusList = new ArrayList<Integer>();
        signatureStatusList.add(UocConstant.SignatureStatus.WAIT_SIGN);
        signatureStatusList.add(UocConstant.SignatureStatus.WAIT_FIRST_PARTY_SIGN);
        signatureStatusList.add(UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN);
        signatureStatusList.add(UocConstant.SignatureStatus.WAIT_THIRD_PARTY_SIGN);
        uocSignatureInitPo.setSignatureStatusList(signatureStatusList);
        uocSignatureInitPo.setExt1(String.valueOf(UocConstant.VALID_FLAG.NO));
        List uocSignatureInitPos = this.uocSignatureInitMapper.getList(uocSignatureInitPo);
        HashMap<Long, List<UocSignInitItemPO>> signatureInitIdItemMap = new HashMap();
        HashMap<Long, String> signatureInitIdCodeMap = new HashMap<Long, String>();
        HashMap<Long, Integer> updateStatusMap = new HashMap<Long, Integer>();
        if (!CollectionUtils.isEmpty((Collection)uocSignatureInitPos)) {
            Set collect = uocSignatureInitPos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getFirstPartyCreditCode())).map(UocSignatureInitPo::getFirstPartyCreditCode).collect(Collectors.toSet());
            for (UocSignatureInitPo signatureInitPo : uocSignatureInitPos) {
                signatureInitIdCodeMap.put(signatureInitPo.getSignatureInitId(), signatureInitPo.getFirstPartyCreditCode());
            }
            List signatureInitIds = uocSignatureInitPos.stream().map(UocSignatureInitPo::getSignatureInitId).collect(Collectors.toList());
            List initItemPOS = this.uocSignInitItemMapper.selectBySignatureInitIds(signatureInitIds);
            if (!CollectionUtils.isEmpty((Collection)initItemPOS)) {
                signatureInitIdItemMap = initItemPOS.stream().collect(Collectors.groupingBy(UocSignInitItemPO::getSignatureInitId));
                for (UocSignInitItemPO initItemPO : initItemPOS) {
                    if (!UocConstant.SignPartyType.FIRST_PARTY.equals(initItemPO.getSignPartyType())) continue;
                    collect.add(initItemPO.getPartyCreditCode());
                    signatureInitIdCodeMap.put(initItemPO.getSignatureInitId(), initItemPO.getPartyCreditCode());
                }
            }
            ContractQrySignInitiatorInfoAbilityReqBO abilityReqBO = new ContractQrySignInitiatorInfoAbilityReqBO();
            abilityReqBO.setCreditCodes(new ArrayList(collect));
            ContractQrySignInitiatorInfoAbilityRspBO abilityRspBO = this.contractQrySignInitiatorInfoAbilityService.qrySignInitiatorInfo(abilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u53d1\u8d77\u4eba\u914d\u7f6e\u5931\u8d25");
            }
            Map<String, List<ContractQrySignInitiatorInfoAbilityBO>> socCreCodeMap = abilityRspBO.getBos().stream().collect(Collectors.groupingBy(ContractQrySignInitiatorInfoAbilityBO::getSocCreCode));
            UocDealSignatureInitSyncBusiReqBo uocDealSignatureInitSyncBusiReqBo = new UocDealSignatureInitSyncBusiReqBo();
            uocDealSignatureInitSyncBusiReqBo.setSignatureInitIds(uocSignatureInitPos.stream().map(UocSignatureInitPo::getSignatureInitId).collect(Collectors.toList()));
            uocDealSignatureInitSyncBusiReqBo.setExt1(String.valueOf(UocConstant.VALID_FLAG.YES));
            UocDealSignatureInitSyncBusiRspBo uocDealSignatureInitSyncBusiRspBo = this.uocDealSignatureInitSyncBusiService.dealSignatureInitSync(uocDealSignatureInitSyncBusiReqBo);
            if (!"0000".equals(uocDealSignatureInitSyncBusiRspBo.getRespCode())) {
                throw new UocProBusinessException("8888", "\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001\u5931\u8d25" + uocDealSignatureInitSyncBusiRspBo.getRespDesc());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (UocSignatureInitPo signatureInitPo : uocSignatureInitPos) {
                UocDealSignatureInitSyncBusiRspBo dealSignatureInitSyncBusiRspBo;
                UocDealSignatureInitSyncBusiReqBo dealSignatureInitSyncBusiReqBo;
                String firstPartyCreditCode = (String)signatureInitIdCodeMap.get(signatureInitPo.getSignatureInitId());
                if (StringUtils.isEmpty((Object)firstPartyCreditCode)) {
                    log.error("\u5f53\u524d\u5355\u636e\u6ca1\u6709\u53d1\u8d77\u65b9\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u5355\u636eid\uff1a" + signatureInitPo.getSignatureInitId());
                    continue;
                }
                if (!socCreCodeMap.containsKey(firstPartyCreditCode)) {
                    log.error("\u5f53\u524d\u5355\u636e\u6839\u636e\u53d1\u8d77\u65b9\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u8d77\u65b9\u914d\u7f6e\uff0c\u5355\u636eid\uff1a" + signatureInitPo.getSignatureInitId());
                    continue;
                }
                ContractQrySignInitiatorInfoAbilityBO signInitiatorInfoAbilityBO = socCreCodeMap.get(firstPartyCreditCode).get(0);
                String accessToken = this.getAccessToken(signInitiatorInfoAbilityBO.getClientId(), signInitiatorInfoAbilityBO.getSecret());
                UocSignGetEnvelopesDetailAtomReqBo atomReqBO = new UocSignGetEnvelopesDetailAtomReqBo();
                atomReqBO.setEnvelopeId(signatureInitPo.getEnvelopeId());
                atomReqBO.setAccessToken(accessToken);
                UocSignGetEnvelopesDetailAtomRspBo atomRspBO = this.uocSignGetEnvelopesDetailAtomService.getEnvelopesDetail(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    log.error("\u67e5\u8be2\u4fe1\u5c01\u8be6\u60c5\u62a5\u9519{}\uff0c{}", (Object)atomRspBO.getRespDesc(), (Object)signatureInitPo.getSignatureInitId());
                    continue;
                }
                if (atomRspBO.getEnvelopeBasicInfo() == null) {
                    log.error("\u4fe1\u5c01\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a{}", (Object)signatureInitPo.getSignatureInitId());
                    continue;
                }
                if (UocConstant.ContractSignatureEnvelopeStatus.SIGNED_SUCCESS.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    UocDealSignatureInitSyncBusiRspBo dealSignatureInitSyncBusiRspBo2;
                    List<UocEnvelopeParticipantAtomBo> envelopeParticipants = atomRspBO.getEnvelopeParticipants();
                    if (CollectionUtils.isEmpty(envelopeParticipants)) {
                        log.error("\u53c2\u4e0e\u8005\u4fe1\u606f\u4e3a\u7a7a{}", (Object)signatureInitPo.getSignatureInitId());
                        continue;
                    }
                    ContractDownloadSignDocumentAbilityReqBO signDocumentAbilityReqBO = new ContractDownloadSignDocumentAbilityReqBO();
                    signDocumentAbilityReqBO.setEnvelopeId(signatureInitPo.getEnvelopeId());
                    signDocumentAbilityReqBO.setAccessToken(accessToken);
                    ContractDownloadSignDocumentAbilityRspBO contractDownloadSignDocumentAbilityRspBO = this.contractDownloadSignDocumentAbilityService.downloadSignDocument(signDocumentAbilityReqBO);
                    if (!"0000".equals(contractDownloadSignDocumentAbilityRspBO.getRespCode())) {
                        log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25{}", (Object)signatureInitPo.getSignatureInitId());
                        continue;
                    }
                    String fileUrl = contractDownloadSignDocumentAbilityRspBO.getFileUrl();
                    OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
                    accessoryPO.setObjectId(signatureInitPo.getSignatureInitId());
                    accessoryPO.setOrderId(signatureInitPo.getOrderId());
                    accessoryPO.setObjectType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_ORIGINAL);
                    accessoryPO = this.ordAccessoryMapper.getModelBy(accessoryPO);
                    OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
                    ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                    ordAccessoryPO.setObjectId(signatureInitPo.getSignatureInitId());
                    ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_COMPLETE);
                    ordAccessoryPO.setOrderId(signatureInitPo.getOrderId());
                    ordAccessoryPO.setAttachmentType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_COMPLETE);
                    ordAccessoryPO.setAccessoryId(ordAccessoryPO.getId());
                    ordAccessoryPO.setAccessoryName(accessoryPO.getAccessoryName());
                    ordAccessoryPO.setAccessoryUrl(fileUrl);
                    ordAccessoryPO.setCreateOperId(String.valueOf(UocConstant.VALID_FLAG.NO));
                    ordAccessoryPO.setCreateTime(new Date());
                    this.ordAccessoryMapper.insert(ordAccessoryPO);
                    UocDealSignatureInitSyncBusiReqBo dealSignatureInitSyncBusiReqBo2 = new UocDealSignatureInitSyncBusiReqBo();
                    dealSignatureInitSyncBusiReqBo2.setSignatureInitIds(Collections.singletonList(signatureInitPo.getSignatureInitId()));
                    dealSignatureInitSyncBusiReqBo2.setExt1(String.valueOf(UocConstant.VALID_FLAG.NO));
                    dealSignatureInitSyncBusiReqBo2.setSignatureStatus(UocConstant.SignatureStatus.SIGNED);
                    if (StringUtils.hasText((String)atomRspBO.getEnvelopeBasicInfo().getModifiedDateTime())) {
                        try {
                            dealSignatureInitSyncBusiReqBo2.setSignatureTime(sdf.parse(atomRspBO.getEnvelopeBasicInfo().getModifiedDateTime()));
                        }
                        catch (ParseException e2) {
                            log.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25", (Throwable)e2);
                        }
                    }
                    if (null == dealSignatureInitSyncBusiReqBo2.getSignatureTime()) {
                        dealSignatureInitSyncBusiReqBo2.setSignatureTime(new Date());
                    }
                    if ("0000".equals((dealSignatureInitSyncBusiRspBo2 = this.uocDealSignatureInitSyncBusiService.dealSignatureInitSync(dealSignatureInitSyncBusiReqBo2)).getRespCode())) continue;
                    log.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5931\u8d25{}", (Object)signatureInitPo.getSignatureInitId());
                    continue;
                }
                if (UocConstant.ContractSignatureEnvelopeStatus.WAITING_TO_SIGN.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    this.dealStatus(signatureInitPo, atomRspBO, signatureInitIdItemMap, updateStatusMap);
                    dealSignatureInitSyncBusiReqBo = new UocDealSignatureInitSyncBusiReqBo();
                    dealSignatureInitSyncBusiReqBo.setSignatureInitIds(Collections.singletonList(signatureInitPo.getSignatureInitId()));
                    dealSignatureInitSyncBusiReqBo.setExt1(String.valueOf(UocConstant.VALID_FLAG.NO));
                    dealSignatureInitSyncBusiRspBo = this.uocDealSignatureInitSyncBusiService.dealSignatureInitSync(dealSignatureInitSyncBusiReqBo);
                    if ("0000".equals(dealSignatureInitSyncBusiRspBo.getRespCode())) continue;
                    log.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5931\u8d25{}", (Object)signatureInitPo.getSignatureInitId());
                    continue;
                }
                if (UocConstant.ContractSignatureEnvelopeStatus.REJECT.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) || UocConstant.ContractSignatureEnvelopeStatus.REVOKE.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) || UocConstant.ContractSignatureEnvelopeStatus.INVALID.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) || UocConstant.ContractSignatureEnvelopeStatus.EXPIRED.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    dealSignatureInitSyncBusiReqBo = new UocDealSignatureInitSyncBusiReqBo();
                    dealSignatureInitSyncBusiReqBo.setSignatureInitIds(Collections.singletonList(signatureInitPo.getSignatureInitId()));
                    dealSignatureInitSyncBusiReqBo.setExt1(String.valueOf(UocConstant.VALID_FLAG.NO));
                    dealSignatureInitSyncBusiReqBo.setExt2(atomRspBO.getEnvelopeBasicInfo().getStatusReason());
                    dealSignatureInitSyncBusiReqBo.setSignatureStatus(UocConstant.SignatureStatus.REFUSAL);
                    dealSignatureInitSyncBusiRspBo = this.uocDealSignatureInitSyncBusiService.dealSignatureInitSync(dealSignatureInitSyncBusiReqBo);
                    if ("0000".equals(dealSignatureInitSyncBusiRspBo.getRespCode())) continue;
                    log.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5931\u8d25{}", (Object)signatureInitPo.getSignatureInitId());
                    continue;
                }
                dealSignatureInitSyncBusiReqBo = new UocDealSignatureInitSyncBusiReqBo();
                dealSignatureInitSyncBusiReqBo.setSignatureInitIds(Collections.singletonList(signatureInitPo.getSignatureInitId()));
                dealSignatureInitSyncBusiReqBo.setExt1(String.valueOf(UocConstant.VALID_FLAG.NO));
                dealSignatureInitSyncBusiRspBo = this.uocDealSignatureInitSyncBusiService.dealSignatureInitSync(dealSignatureInitSyncBusiReqBo);
                if (!"0000".equals(dealSignatureInitSyncBusiRspBo.getRespCode())) {
                    log.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5931\u8d25{}", (Object)signatureInitPo.getSignatureInitId());
                }
                log.error("\u6b64\u5408\u540c\u7535\u5b50\u7b7e\u7ae0\u4fe1\u5c01\u72b6\u6001\u6ca1\u6709\u5904\u7406\u6d41\u7a0b{}", (Object)signatureInitPo.getSignatureInitId());
            }
            if (!CollectionUtils.isEmpty(updateStatusMap)) {
                UocDealSignatureInitSyncBusiReqBo busiReqBo = new UocDealSignatureInitSyncBusiReqBo();
                busiReqBo.setUpdateStatusMap(updateStatusMap);
                this.uocDealSignatureInitSyncBusiService.dealSignatureStatusSync(busiReqBo);
            }
        }
        UocDealSignatureInitSyncRspBo rspBo = new UocDealSignatureInitSyncRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getAccessToken(String clientId, String secret) {
        String accessToken = null;
        UocSignAccessTokenCreateAtomReqBo signAccessTokenCreateAtomReqBO = new UocSignAccessTokenCreateAtomReqBo();
        signAccessTokenCreateAtomReqBO.setClientId(clientId);
        signAccessTokenCreateAtomReqBO.setSecret(secret);
        UocSignAccessTokenCreateAtomRspBo signAccessTokenCreateAtomRspBO = this.uocSignAccessTokenCreateAtomService.signAccessTokenCreate(signAccessTokenCreateAtomReqBO);
        if (!"0000".equals(signAccessTokenCreateAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(signAccessTokenCreateAtomRspBO.getRespDesc());
        }
        accessToken = signAccessTokenCreateAtomRspBO.getAccessToken();
        return accessToken;
    }

    private void dealStatus(UocSignatureInitPo signatureInitPo, UocSignGetEnvelopesDetailAtomRspBo atomRspBO, Map<Long, List<UocSignInitItemPO>> signatureInitIdItemMap, Map<Long, Integer> updateStatusMap) {
        if (signatureInitIdItemMap.containsKey(signatureInitPo.getSignatureInitId())) {
            Integer bothPartiesSign = signatureInitPo.getBothPartiesSign();
            if (UocConstant.BOTH_PARTIES_SIGN_TYPE.ONLY.equals(bothPartiesSign)) {
                // empty if block
            }
            if (UocConstant.BOTH_PARTIES_SIGN_TYPE.TWO.equals(bothPartiesSign) || UocConstant.BOTH_PARTIES_SIGN_TYPE.THREE.equals(bothPartiesSign)) {
                List<UocEnvelopeParticipantAtomBo> envelopeParticipants = atomRspBO.getEnvelopeParticipants();
                if (CollectionUtils.isEmpty(envelopeParticipants)) {
                    log.error("\u53c2\u4e0e\u8005\u4fe1\u606f\u4e3a\u7a7a{}", (Object)signatureInitPo.getSignatureInitId());
                    return;
                }
                List partSignInfoS = envelopeParticipants.stream().filter(e -> e.getRoleType() != null && e.getRoleType().equals(1)).collect(Collectors.toList());
                Integer maxSignAssignedSeq = null;
                for (Object signInfo : partSignInfoS) {
                    if (!((UocEnvelopeParticipantAtomBo)signInfo).getStatus().equals(UocConstant.ContractSignerStatus.SIGNED_SUCCESS)) continue;
                    if (maxSignAssignedSeq == null) {
                        maxSignAssignedSeq = ((UocEnvelopeParticipantAtomBo)signInfo).getAssignedSeq();
                        continue;
                    }
                    if (maxSignAssignedSeq >= ((UocEnvelopeParticipantAtomBo)signInfo).getAssignedSeq()) continue;
                    maxSignAssignedSeq = ((UocEnvelopeParticipantAtomBo)signInfo).getAssignedSeq();
                }
                if (maxSignAssignedSeq != null) {
                    UocSignInitItemPO maxSignPO = null;
                    for (UocSignInitItemPO po : signatureInitIdItemMap.get(signatureInitPo.getSignatureInitId())) {
                        if (!maxSignAssignedSeq.equals(po.getSignSort())) continue;
                        maxSignPO = po;
                    }
                    if (maxSignPO != null) {
                        Integer signOrder = signatureInitPo.getSignOrder();
                        Integer signPartyType = maxSignPO.getSignPartyType();
                        Integer signType = maxSignPO.getSignType();
                        if (UocConstant.SIGN_TYPE.SEAL.equals(signType)) {
                            if (signOrder == 0 && UocConstant.SignPartyType.FIRST_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_FIRST_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN);
                            }
                            if (signOrder == 1 && UocConstant.SignPartyType.SECOND_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_FIRST_PARTY_SIGN);
                            }
                            if (signOrder == 2) {
                                if (UocConstant.SignPartyType.THIRD_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_THIRD_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                    updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN);
                                }
                                if (UocConstant.SignPartyType.SECOND_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                    updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_FIRST_PARTY_SIGN);
                                }
                            }
                            if (signOrder == 3) {
                                if (UocConstant.SignPartyType.SECOND_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_SECOND_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                    updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_THIRD_PARTY_SIGN);
                                }
                                if (UocConstant.SignPartyType.THIRD_PARTY.equals(signPartyType) && UocConstant.SignatureStatus.WAIT_THIRD_PARTY_SIGN.equals(signatureInitPo.getSignatureStatus())) {
                                    updateStatusMap.put(signatureInitPo.getSignatureInitId(), UocConstant.SignatureStatus.WAIT_FIRST_PARTY_SIGN);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

