/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.api.UocGetErpOrderAbilityService;
import com.tydic.uoc.common.ability.bo.ErpOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocGetErpOrderReqBo;
import com.tydic.uoc.common.ability.bo.UocGetErpOrderRspBo;
import com.tydic.uoc.common.busi.api.UocGetErpOrderBusiService;
import com.tydic.uoc.common.utils.AuthUtil;
import com.tydic.uoc.common.utils.HttpUtil;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocGetErpOrderAbilityService"})
public class UocGetErpOrderAbilityServiceImpl
implements UocGetErpOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocGetErpOrderAbilityServiceImpl.class);
    @Autowired
    private UocGetErpOrderBusiService uocGetErpOrderBusiService;
    @Value(value="${uoc.erp.order.url:http://172.16.8.92:8001/OSN/api/qryErpOrder/v1}")
    private String erpOrderUrl;
    @Value(value="${uoc.erp.token.url:http://172.16.91.185:12346/interface/wms/getErpInterfaceToken}")
    private String erpTokenUrl;
    @Value(value="${uoc.erp.order.time:20}")
    private Integer time;
    @Value(value="${ccit.erp.service.self.secret:30dd08f8-e9c4-933d-2067-8c31144efdcd}")
    private String secret;
    @Value(value="${ccit.erp.service.name:ZMYG}")
    private String name;
    @Value(value="${ccit.erp.time.xy:120}")
    private Integer xyTime;

    @PostMapping(value={"getErpOrder"})
    public UocGetErpOrderRspBo getErpOrder(@RequestBody UocGetErpOrderReqBo reqBo) {
        JSONObject req = new JSONObject();
        req.put("clientName", (Object)this.name);
        Date date = new Date(System.currentTimeMillis() - (long)(this.xyTime * 1000));
        String erpTime = DateUtil.dateToStrLongNew((Date)date);
        req.put("time", (Object)erpTime);
        req.put("verifyCode", (Object)AuthUtil.genVerifyCode(this.name, this.secret, erpTime));
        log.error("\u8c03\u7528erp\u83b7\u53d6token\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)req));
        String tokenResult = HttpUtil.post(this.erpTokenUrl, JSON.toJSONString((Object)req), null);
        if (StringUtils.isEmpty((Object)tokenResult)) {
            throw new UocProBusinessException("8888", "\u8c03\u7528erp\u83b7\u53d6token\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        log.error("\u8c03\u7528erp\u83b7\u53d6token\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)tokenResult);
        JSONObject jsonObject = JSONObject.parseObject((String)tokenResult);
        if (StringUtils.isEmpty((Object)reqBo.getLastUpdateTimeStart())) {
            reqBo.setLastUpdateTimeStart(DateUtils.dateToStrLong((Date)new Date(System.currentTimeMillis() - (long)(this.time * 60 * 1000))));
        }
        if (StringUtils.isEmpty((Object)reqBo.getLastUpdateTimeEnd())) {
            reqBo.setLastUpdateTimeEnd(DateUtils.dateToStrLong((Date)new Date()));
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        JSONObject data = jsonObject.getJSONObject("data");
        if (data == null || StringUtils.isEmpty((Object)data.getString("token"))) {
            throw new UocProBusinessException("8888", "\u8c03\u7528erp\u83b7\u53d6token\u63a5\u53e3\u5931\u8d25\uff1a" + tokenResult);
        }
        headerMap.put("ESB-clientToken", data.getString("token"));
        headerMap.put("clientToken", data.getString("token"));
        log.info("\u67e5\u8be2erp\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        String result = HttpUtil.post(this.erpOrderUrl, JSON.toJSONString((Object)reqBo), headerMap);
        log.info("\u67e5\u8be2erp\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new UocProBusinessException("8888", "\u8c03\u7528erp\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        ErpOrderRspBO erpOrderRspBO = (ErpOrderRspBO)JSONObject.parseObject((String)result, ErpOrderRspBO.class);
        reqBo.setErpOrderRspBO(erpOrderRspBO);
        return this.uocGetErpOrderBusiService.dealGetErpOrder(reqBo);
    }

    @PostMapping(value={"getErpOrderBatch"})
    public UocGetErpOrderRspBo getErpOrderBatch(@RequestBody UocGetErpOrderReqBo reqBo) {
        for (String order : reqBo.getOrderNos()) {
            UocGetErpOrderReqBo bo = new UocGetErpOrderReqBo();
            bo.setLastUpdateTimeStart(reqBo.getLastUpdateTimeStart());
            bo.setLastUpdateTimeEnd(reqBo.getLastUpdateTimeEnd());
            bo.setOrderNo(order);
            try {
                this.getErpOrder(reqBo);
            }
            catch (Exception exception) {}
        }
        UocGetErpOrderRspBo rspBo = new UocGetErpOrderRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

