/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocInvoiceNoticeAbilityService;
import com.tydic.uoc.common.ability.bo.UocInvoiceNoticeReqBO;
import com.tydic.uoc.common.ability.bo.UocInvoiceNoticeRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocInvoiceNoticeBusiService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocInvoiceNoticeAbilityService"})
public class UocInvoiceNoticeAbilityServiceImpl
implements UocInvoiceNoticeAbilityService {
    @Autowired
    private UocInvoiceNoticeBusiService uocInvoiceNoticeBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @PostMapping(value={"dealInvoiceNotice"})
    public UocInvoiceNoticeRspBO dealInvoiceNotice(@RequestBody UocInvoiceNoticeReqBO reqBO) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (UocOrderBO uocOrderBO : reqBO.getOrderInfo()) {
            UocInvoiceNoticeReqBO noticeReqBO = new UocInvoiceNoticeReqBO();
            BeanUtils.copyProperties((Object)uocOrderBO, (Object)noticeReqBO);
            UocInvoiceNoticeRspBO rspBO = this.uocInvoiceNoticeBusiService.dealInvoiceNotice(noticeReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                syncReqBO.setOrderId(uocOrderBO.getOrderId());
                syncReqBO.setObjId(uocOrderBO.getSaleVoucherId());
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
                continue;
            }
            list.add(uocOrderBO.getOrderId());
        }
        UocInvoiceNoticeRspBO rspBO = new UocInvoiceNoticeRspBO();
        if (CollectionUtils.isNotEmpty(list)) {
            rspBO.setFailedOrder(list);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

