/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.PushContractTzConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.api.UocDycPebOrderRegistAbilityService;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipRspBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderRegistAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderRegistAbilityRspBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderRegistRspBO;
import com.tydic.uoc.common.comb.api.UocPebOrderRegistCombService;
import com.tydic.uoc.common.comb.bo.UocPebOrderRegistReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWmsLogMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWmsLogPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocDycPebOrderRegistAbilityService"})
public class UocPebOrderRegistAbilityServiceImpl
implements UocDycPebOrderRegistAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderRegistAbilityServiceImpl.class);
    @Autowired
    private UocPebOrderRegistCombService uocPebOrderRegistCombService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdWmsLogMapper uocOrdWmsLogMapper;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;

    @PostMapping(value={"dealPebOrderRegist"})
    public UocPebOrderRegistAbilityRspBO dealPebOrderRegist(@RequestBody UocPebOrderRegistAbilityReqBO reqBO) {
        Long logId = null;
        if (!ObjectUtil.isEmpty((Object)reqBO.getWmsTag())) {
            logId = this.saveLog(JSON.toJSONString((Object)reqBO), null, reqBO);
        }
        this.validateParam(reqBO);
        if (!StringUtils.isEmpty((Object)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        UocPebOrderRegistAbilityRspBO rspBO = new UocPebOrderRegistAbilityRspBO();
        UocPebOrderRegistReqBO uocPebOrderRegistReqBO = new UocPebOrderRegistReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)uocPebOrderRegistReqBO));
        UocPebOrderRegistRspBO uocPebOrderRegistRspBO = this.uocPebOrderRegistCombService.dealPebOrderRegist(uocPebOrderRegistReqBO);
        BeanUtils.copyProperties((Object)((Object)uocPebOrderRegistRspBO), (Object)rspBO);
        if (!ObjectUtil.isEmpty((Object)reqBO.getWmsTag())) {
            rspBO.setOrderId(reqBO.getOrderId());
            if (!ObjectUtil.isEmpty((Object)logId)) {
                this.updateLog(rspBO, logId);
            }
        }
        if ("0000".equals(rspBO.getRespCode())) {
            try {
                this.businessBacklog(reqBO);
            }
            catch (Exception e) {
                log.error("\u5f85\u53d1\u8d27\u5230\u8d27\u767b\u8bb0\u5f85\u529e\u53d6\u6d88", (Throwable)e);
            }
        }
        return rspBO;
    }

    private void businessBacklog(UocPebOrderRegistAbilityReqBO reqBo) {
        UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
        dealReqBo.setDealUserNo(reqBo.getUsername());
        dealReqBo.setDealUserName(reqBo.getName());
        dealReqBo.setHandleUserNo(reqBo.getOccupation());
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBo.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (Objects.nonNull(salePO)) {
            if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_A_SINGLE_PURCHASE.toString().equals(salePO.getOrderSource())) {
                dealReqBo.setBusiCode("3075");
            } else if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_FRAMEWORK_AGREEMENT.toString().equals(salePO.getOrderSource())) {
                dealReqBo.setBusiCode("3076");
            } else {
                return;
            }
        }
        this.delWait(reqBo, uocBusinessPendingTodoAbilityAtomReqBO, dealReqBo);
    }

    private void delWait(UocPebOrderRegistAbilityReqBO reqBo, UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO, TodoBusinessWaitDoneDealReqBo dealReqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getArrRegisterItemList())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBo.getOrderId());
            List list = this.ordShipMapper.getList(ordShipPO);
            for (OrdShipPO item : list) {
                dealReqBo.setObjId(String.valueOf(item.getShipVoucherId()));
                log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u63a8\u9001\u5b8c\u6574\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dealReqBo));
                uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
                this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
            }
        } else {
            for (UocPebArrRegisterShipIReqBO item : reqBo.getArrRegisterItemList()) {
                dealReqBo.setObjId(String.valueOf(item.getShipVoucherId()));
                log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u63a8\u9001\u5b8c\u6574\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dealReqBo));
                uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
                this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
            }
        }
    }

    private void validateParam(UocPebOrderRegistAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (PecConstant.AuthCtrl.SELF.equals(reqBO.getAuthCtrl()) && reqBO.getMemId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u64cd\u4f5c\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (PecConstant.AuthCtrl.STATION.equals(reqBO.getAuthCtrl()) && StringUtils.isEmpty((Object)reqBO.getStationId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u5c97\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getArrRegisterItemList())) {
            throw new UocProBusinessException("100001", "\u975e\u5168\u90e8\u5230\u8d27\u5165\u53c2\u3010\u5230\u8d27\u767b\u8bb0\u660e\u7ec6\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UocPebArrRegisterShipIReqBO shipIReqBO : reqBO.getArrRegisterItemList()) {
            if (shipIReqBO.getShipVoucherId() == null) {
                throw new UocProBusinessException("100001", "\u975e\u5168\u90e8\u5230\u8d27\u5165\u53c2\u3010\u5230\u8d27\u767b\u8bb0\u660e\u7ec6\u4e2d\u7684\u53d1\u8d27\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getWmsTag()) || !ObjectUtil.isEmpty((Object)reqBO.getSaleVourcherId())) continue;
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setShipVoucherId(shipIReqBO.getShipVoucherId());
            OrdShipPO ordShipPO = this.ordShipMapper.getModelBy(shipPO);
            if (ordShipPO == null) {
                throw new UocProBusinessException("102033", "\u53d1\u8d27\u5355\u6821\u9a8c\u5931\u8d25 \u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a" + shipIReqBO.getShipVoucherId());
            }
            reqBO.setSaleVourcherId(ordShipPO.getSaleVoucherId());
            reqBO.setOrderId(ordShipPO.getOrderId());
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSaleVourcherId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u9500\u552e\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getAccessoryList()) {
                if (StringUtils.isEmpty((Object)accessoryBO.getAccessoryName())) {
                    throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)accessoryBO.getAccessoryUrl())) continue;
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u9644\u4ef6URL\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private Long saveLog(String reqData, PebPushWmsShipRspBO rspBO, UocPebOrderRegistAbilityReqBO reqBO) {
        try {
            UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
            wmsLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            wmsLogPO.setOrderId(reqBO.getOrderId());
            wmsLogPO.setObjId(((UocPebArrRegisterShipIReqBO)reqBO.getArrRegisterItemList().get(0)).getShipVoucherId());
            wmsLogPO.setCreateTime(new Date());
            wmsLogPO.setObjType(UocConstant.WmsPushType.ARRIVE_CONSIGN);
            wmsLogPO.setReqData(reqData);
            this.uocOrdWmsLogMapper.insert(wmsLogPO);
            return wmsLogPO.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private void updateLog(UocPebOrderRegistAbilityRspBO rspBO, Long logId) {
        try {
            UocOrdWmsLogPO wmsLogPO = this.uocOrdWmsLogMapper.queryById(logId);
            wmsLogPO.setId(logId);
            if ("0000".equals(rspBO.getRespCode())) {
                wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.SUCCESS);
            } else {
                wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.FAILE);
                wmsLogPO.setCount(Integer.valueOf(wmsLogPO.getCount() + 1));
            }
            wmsLogPO.setRspData(rspBO.getRespDesc());
            this.uocOrdWmsLogMapper.update(wmsLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }
}

