/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocSyncHtQryDetailAbilityService;
import com.tydic.uoc.common.ability.bo.UocSyncHtQryDetailAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocSyncHtQryDetailAbilityRspBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdConfirmMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdConfirmPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocSyncHtQryDetailAbilityService"})
public class UocSyncHtQryDetailAbilityServiceImpl
implements UocSyncHtQryDetailAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdConfirmMapper uocOrdConfirmMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @PostMapping(value={"qrySyncHtDetail"})
    public UocSyncHtQryDetailAbilityRspBO qrySyncHtDetail(@RequestBody UocSyncHtQryDetailAbilityReqBO reqBO) {
        OrdSalePO salePO;
        OrdShipPO shipPO;
        UocSyncHtQryDetailAbilityRspBO rspBO = new UocSyncHtQryDetailAbilityRspBO();
        if (reqBO.getPushType() == null || reqBO.getObjId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[pushType]\u548c[objId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = null;
        if (UocConstant.ContractPushType.PURCHASE.equals(reqBO.getPushType())) {
            orderId = reqBO.getObjId();
        } else if (UocConstant.ContractPushType.CONFIRM.equals(reqBO.getPushType())) {
            UocOrdConfirmPO searchPO = new UocOrdConfirmPO();
            searchPO.setId(reqBO.getObjId());
            UocOrdConfirmPO confirmPO = this.uocOrdConfirmMapper.getModel(searchPO);
            if (confirmPO != null) {
                orderId = confirmPO.getOrderId();
            }
        } else if (UocConstant.ContractPushType.INSP.equals(reqBO.getPushType())) {
            OrdInspectionPO inspectionPO = this.ordInspectionMapper.getModelById(reqBO.getObjId().longValue());
            if (inspectionPO != null) {
                orderId = inspectionPO.getOrderId();
            }
        } else if (UocConstant.ContractPushType.SHIP.equals(reqBO.getPushType()) && (shipPO = this.ordShipMapper.getModelById(reqBO.getObjId().longValue())) != null) {
            orderId = shipPO.getOrderId();
        }
        if (orderId != null && (salePO = this.ordSaleMapper.getSaleVoucherNoByOrderId(orderId)) != null) {
            rspBO.setOrderId(orderId);
            rspBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            rspBO.setSaleVoucherId(salePO.getSaleVoucherId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

