/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PushContractTzConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipItemBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipReqBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipRspBO;
import com.tydic.uoc.common.atom.api.PebPushWmsShipAtomService;
import com.tydic.uoc.common.atom.bo.PebUocWmsStateQryRspBO;
import com.tydic.uoc.common.atom.bo.PedUocWmsStateqryReqBO;
import com.tydic.uoc.common.utils.DycAuthUtil;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdWmsLogMapper;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdWmsLogPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PebPushWmsShipAtomServiceImpl
implements PebPushWmsShipAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebPushWmsShipAtomServiceImpl.class);
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private UocOrdWmsLogMapper uocOrdWmsLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${wms.app.key:YGDEC96EAF4001CAEB9E3E1F54E2E436}")
    private String appKey;
    @Value(value="${wms.ship.key:YG_DELIVERY_ORDER}")
    private String shipKey;
    @Value(value="${wms.ship.url:http://172.16.91.185:8068/interface/delivery/push}")
    private String shipUrl;
    @Value(value="${wms.ship.auth.path:/interface/wms/push/delivery}")
    private String authPath;
    @Value(value="${wms.ship.state.url:http://172.20.175.50:8071/interface/wms/appointment/queryByDeliveryCode}")
    private String shipStateUrl;
    @Value(value="${wms.ship.state.key:YG_STOCK_QUERY}")
    private String shipStateKey;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @Override
    public PebPushWmsShipRspBO pushWmsShip(PebPushWmsShipReqBO reqBO) {
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setShipVoucherId(reqBO.getShipVoucherId());
        shipPO = this.ordShipMapper.getModelBy(shipPO);
        if (shipPO == null) {
            throw new UocProBusinessException("8888", reqBO.getShipVoucherId() + "\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff01");
        }
        PebPushWmsShipBO wmsShipBO = this.buildShipInfo(shipPO);
        if (!ObjectUtils.isEmpty((Object)reqBO.getUpdate())) {
            wmsShipBO.setIsTerminate(Boolean.valueOf(true));
        } else {
            wmsShipBO.setIsTerminate(Boolean.valueOf(false));
        }
        List<PebPushWmsShipItemBO> shipItemList = this.buildShipItemInfo(shipPO);
        wmsShipBO.setDetails(shipItemList);
        HashMap<String, String> reqData = new HashMap<String, String>(4);
        reqData.put("key", this.shipKey);
        reqData.put("data_md5", MD5Util.MD5Encode((String)JSONObject.toJSONString((Object)wmsShipBO), (String)""));
        reqData.put("data", (String)wmsShipBO);
        PebPushWmsShipRspBO rspBO = this.dealPushWms(JSONObject.toJSONString(reqData));
        if (reqBO.getId() == null) {
            this.saveLog(JSONObject.toJSONString(reqData), rspBO, shipPO, reqBO);
        } else {
            this.updateLog(rspBO, reqBO, JSONObject.toJSONString(reqData));
        }
        OrdShipPO updatePo = new OrdShipPO();
        updatePo.setShipVoucherId(shipPO.getShipVoucherId());
        updatePo.setPushWmsStatus("0000".equals(rspBO.getRespCode()) ? PushContractTzConstant.pushStatus.SUCCESS : PushContractTzConstant.pushStatus.FAILE);
        updatePo.setPushWmsRemark(rspBO.getRespDesc());
        updatePo.setOrderId(shipPO.getOrderId());
        this.ordShipMapper.updateById(updatePo);
        return rspBO;
    }

    @Override
    public PebUocWmsStateQryRspBO wmsStateQry(PedUocWmsStateqryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceOrderCode", (Object)reqBO.getShipVoucherCode());
        jsonObject.put("requestId", (Object)this.getRequiredId());
        HashMap<String, String> reqData = new HashMap<String, String>(4);
        reqData.put("key", this.shipStateKey);
        reqData.put("data_md5", MD5Util.MD5Encode((String)JSONObject.toJSONString((Object)jsonObject), (String)""));
        reqData.put("data", (String)jsonObject);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appKey", this.appKey);
        headerMap.put("requestTime", DateUtils.dateToStrLong((Date)new Date()));
        String sign = DycAuthUtil.sign(this.appKey, this.authPath, headerMap);
        headerMap.put("authSignature", sign);
        try {
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.shipStateUrl);
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(reqData));
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u5934\uff1a{}", (Object)JSON.toJSONString(headerMap));
            String respStr = HttpUtil.doPost(this.shipStateUrl, JSON.toJSONString(reqData), headerMap);
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)respStr);
            if (StringUtils.isEmpty((CharSequence)respStr)) {
                throw new UocProBusinessException("8888", "\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveStateRsp(respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            PebUocWmsStateQryRspBO rspBO = new PebUocWmsStateQryRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private PebUocWmsStateQryRspBO resolveStateRsp(String respStr) {
        PebUocWmsStateQryRspBO rspBO;
        try {
            rspBO = (PebUocWmsStateQryRspBO)((Object)JSONObject.parseObject((String)respStr, PebUocWmsStateQryRspBO.class));
            if ("200".equals(rspBO.getCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
            }
        }
        catch (Exception e) {
            rspBO = new PebUocWmsStateQryRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u89e3\u6790\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        return rspBO;
    }

    private List<PebPushWmsShipItemBO> buildShipItemInfo(OrdShipPO shipPO) {
        OrdShipItemPO shipItemPO = new OrdShipItemPO();
        shipItemPO.setShipVoucherId(shipPO.getShipVoucherId());
        List shipItemPOList = this.ordShipItemMapper.getItemList(shipItemPO);
        ArrayList<PebPushWmsShipItemBO> shipItemBOList = new ArrayList<PebPushWmsShipItemBO>();
        Integer rowNo = 1;
        for (OrdShipItemPO ordShipItemPO : shipItemPOList) {
            PebPushWmsShipItemBO shipItemBO = new PebPushWmsShipItemBO();
            shipItemBO.setRowId(ordShipItemPO.getShipItemId() + "");
            shipItemBO.setRowNo(rowNo);
            shipItemBO.setStatus("Y");
            shipItemBO.setOrderRowStatus("Y");
            shipItemBO.setCanInboundStatus("Y");
            shipItemBO.setCanReturnStatus("Y");
            shipItemBO.setCanReceiveStatus("Y");
            shipItemBO.setErpCanInboundQty(ordShipItemPO.getSendCount().subtract(ordShipItemPO.getRefuseCount()));
            shipItemBO.setErpCanReturnQty(ordShipItemPO.getSendCount().subtract(ordShipItemPO.getRefuseCount()));
            shipItemBO.setErpCanReceiveQty(ordShipItemPO.getSendCount());
            shipItemBO.setQty(ordShipItemPO.getSendCount());
            shipItemBO.setPurchaseOrderRowId(ordShipItemPO.getOrdItemId() + "");
            shipItemBO.setPurchaseOrderRowQty(ordShipItemPO.getPurchaseCount());
            shipItemBOList.add(shipItemBO);
            Integer n = rowNo;
            Integer n2 = rowNo = Integer.valueOf(rowNo + 1);
        }
        return shipItemBOList;
    }

    private PebPushWmsShipBO buildShipInfo(OrdShipPO shipPO) {
        PebPushWmsShipBO wmsShipBO = new PebPushWmsShipBO();
        wmsShipBO.setOrderId(shipPO.getShipVoucherId() + "");
        wmsShipBO.setOrderCode(shipPO.getShipVoucherCode());
        wmsShipBO.setCarNumber(shipPO.getShipId());
        if (StringUtils.isNotEmpty((CharSequence)shipPO.getShipCompanyId()) && "1".equals(shipPO.getShipCompanyId())) {
            wmsShipBO.setCarNumber(shipPO.getPackageId());
            wmsShipBO.setDriverName(shipPO.getDriverName());
            wmsShipBO.setDriverPhone(shipPO.getDriverPhone());
        }
        String shippingAddressName = "";
        if (shipPO.getProvinceName() != null) {
            shippingAddressName = shippingAddressName + shipPO.getProvinceName();
        }
        if (shipPO.getCityName() != null) {
            shippingAddressName = shippingAddressName + shipPO.getCityName();
        }
        if (shipPO.getCountyName() != null) {
            shippingAddressName = shippingAddressName + shipPO.getCountyName();
        }
        if (shipPO.getTownName() != null) {
            shippingAddressName = shippingAddressName + shipPO.getTownName();
        }
        if (shipPO.getDetailAddress() != null) {
            shippingAddressName = shippingAddressName + shipPO.getDetailAddress();
        }
        wmsShipBO.setShippingAddressName(shippingAddressName);
        wmsShipBO.setReceiverAddressId(shipPO.getReceiverAddressId());
        wmsShipBO.setEstimateArrivalDate(DateUtil.dateToStr((Date)shipPO.getEstimateArrivalTime()));
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(shipPO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
        relaPO.setOrderId(shipPO.getOrderId());
        relaPO.setContactId(salePO.getContactId());
        relaPO = this.ordLogisticsRelaMapper.getModelBy(relaPO);
        if (relaPO == null) {
            throw new UocProBusinessException("8888", shipPO.getShipVoucherId() + "\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4e3a\u7a7a\uff01");
        }
        wmsShipBO.setReceiver(relaPO.getContactCompany());
        wmsShipBO.setReceiverName(relaPO.getContactName());
        wmsShipBO.setReceiverContact(relaPO.getContactMobile());
        StringBuilder sb = new StringBuilder();
        sb.append(relaPO.getContactProvinceName());
        sb.append(relaPO.getContactCityName());
        sb.append(relaPO.getContactCountyName());
        if (!StringUtils.isEmpty((CharSequence)relaPO.getContactTown())) {
            sb.append(relaPO.getContactTown());
        }
        sb.append(relaPO.getContactAddress());
        wmsShipBO.setAddressName(sb.toString());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(shipPO.getOrderId().longValue());
        wmsShipBO.setPurchaseUserPhone(stakeholderPO.getPurRelaMobile());
        return wmsShipBO;
    }

    private PebPushWmsShipRspBO dealPushWms(String reqData) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appKey", this.appKey);
        headerMap.put("requestTime", DateUtils.dateToStrLong((Date)new Date()));
        String sign = DycAuthUtil.sign(this.appKey, this.authPath, headerMap);
        headerMap.put("authSignature", sign);
        try {
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.shipUrl);
            String respStr = HttpUtil.doPost(this.shipUrl, reqData, headerMap);
            if (StringUtils.isEmpty((CharSequence)respStr)) {
                throw new UocProBusinessException("8888", "\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)respStr);
            return this.resolveRsp(respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            PebPushWmsShipRspBO rspBO = new PebPushWmsShipRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private PebPushWmsShipRspBO resolveRsp(String respStr) {
        PebPushWmsShipRspBO rspBO;
        try {
            rspBO = (PebPushWmsShipRspBO)JSONObject.parseObject((String)respStr, PebPushWmsShipRspBO.class);
            if ("200".equals(rspBO.getCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
            }
        }
        catch (Exception e) {
            rspBO = new PebPushWmsShipRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u89e3\u6790\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespData(respStr);
        return rspBO;
    }

    private void saveLog(String reqData, PebPushWmsShipRspBO rspBO, OrdShipPO shipPO, PebPushWmsShipReqBO reqBO) {
        UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
        wmsLogPO.setId(Long.valueOf(this.sequence.nextId()));
        wmsLogPO.setOrderId(shipPO.getOrderId());
        wmsLogPO.setObjId(shipPO.getShipVoucherId());
        wmsLogPO.setObjNo(shipPO.getShipVoucherCode());
        wmsLogPO.setCreateTime(new Date());
        wmsLogPO.setObjType(UocConstant.WmsPushType.SHIP);
        if (!ObjectUtils.isEmpty((Object)reqBO.getUpdate())) {
            wmsLogPO.setObjType(UocConstant.WmsPushType.SHIP_RE);
        }
        wmsLogPO.setReqData(reqData);
        wmsLogPO.setRspData(rspBO.getRespData());
        wmsLogPO.setDealStatus("0000".equals(rspBO.getRespCode()) ? PushContractTzConstant.pushStatus.SUCCESS : PushContractTzConstant.pushStatus.FAILE);
        int count = this.uocOrdWmsLogMapper.insert(wmsLogPO);
        if (count != 1) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u63a8\u9001WMS\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void updateLog(PebPushWmsShipRspBO rspBO, PebPushWmsShipReqBO reqBO, String reqData) {
        UocOrdWmsLogPO wmsLogPO = this.uocOrdWmsLogMapper.queryById(reqBO.getId());
        wmsLogPO.setId(reqBO.getId());
        if ("0000".equals(rspBO.getRespCode())) {
            wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.SUCCESS);
        } else {
            wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.FAILE);
            wmsLogPO.setCount(Integer.valueOf(wmsLogPO.getCount() + 1));
        }
        wmsLogPO.setReqData(reqData);
        wmsLogPO.setRspData(rspBO.getRespData());
        this.uocOrdWmsLogMapper.update(wmsLogPO);
    }

    private String getRequiredId() {
        long timestamp = System.currentTimeMillis();
        String timestampStr = Long.toString(timestamp);
        String randomPart = this.generateRandomNumbers(36 - timestampStr.length());
        return timestampStr + randomPart;
    }

    private String generateRandomNumbers(int length) {
        StringBuilder sb = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int digit = random.nextInt(10);
            sb.append(digit);
        }
        return sb.toString();
    }
}

