/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractHtGetTokenAbilityService;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.api.PebQryOrderIsPushHtAbilityService;
import com.tydic.uoc.common.ability.api.UocSyncAllLogAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocSyncAllLogAbilityReqBO;
import com.tydic.uoc.common.atom.api.PebSyncHtArriveAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomMainBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomRspBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveDetailAtomBO;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.UocContractSyncFailLogMapper;
import com.tydic.uoc.dao.UocContractSyncLogMapper;
import com.tydic.uoc.dao.UocOrdConfirmMapper;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPushPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdShipPushPO;
import com.tydic.uoc.po.UocContractSyncFailLogPO;
import com.tydic.uoc.po.UocContractSyncLogPO;
import com.tydic.uoc.po.UocOrdConfirmPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PebSyncHtArriveAtomServiceImpl
implements PebSyncHtArriveAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebSyncHtArriveAtomServiceImpl.class);
    @Autowired
    private ContractHtGetTokenAbilityService contractHtGetTokenAbilityService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdConfirmMapper uocOrdConfirmMapper;
    @Autowired
    private UocContractSyncLogMapper uocContractSyncLogMapper;
    @Autowired
    private UocContractSyncFailLogMapper uocContractSyncFailLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Value(value="${ESB_ARRIVEE_SHIP_PUSH_URL:ESP_ARRIVE_SHIP_PUSH_URL}")
    private String ESP_ARRIVE_SHIP_PUSH_URL;
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Autowired
    private PebQryOrderIsPushHtAbilityService pebQryOrderIsPushHtAbilityService;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private UocSyncAllLogAbilityService uocSyncAllLogAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Override
    public PebSyncHtArriveAtomRspBO syncHtArrive(PebSyncHtArriveAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getConfirmId()) && ObjectUtils.isEmpty((Object)reqBO.getOrderId()) && CollectionUtil.isEmpty(reqBO.getConfirmIdList()) && reqBO.getShipVoucherId() == null) {
            throw new BusinessException("8888", "\u5165\u53c2 \u4e3a\u7a7a ");
        }
        PebSyncHtArriveAtomRspBO rspBO = new PebSyncHtArriveAtomRspBO();
        rspBO.setRespCode("0000");
        if (!CollectionUtils.isEmpty(reqBO.getConfirmIdList())) {
            this.threadPush(reqBO);
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getConfirmId()) || reqBO.getShipVoucherId() != null && reqBO.getIsFailPushFlag() != null && reqBO.getIsFailPushFlag() == 1) {
            this.pushSingle(reqBO);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            List pushConfirmList = this.ordShipMapper.getPushShipInfoList(ordShipPO);
            if (!CollectionUtil.isEmpty((Collection)pushConfirmList)) {
                for (OrdShipPushPO pushPO : pushConfirmList) {
                    this.pushSingleExt(reqBO, pushPO);
                }
            }
        }
        return rspBO;
    }

    private void threadPush(PebSyncHtArriveAtomReqBO reqBO) {
        log.info("---------------------\u7ebf\u7a0b\u5904\u7406\u5f00\u59cb--------------");
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        for (Long confirmId : reqBO.getConfirmIdList()) {
            fixedThreadPool.submit(() -> {
                try {
                    PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
                    atomReqBO.setConfirmId(confirmId);
                    this.pushSingle(atomReqBO);
                }
                catch (Exception e) {
                    log.error("\u63a8\u9001\u5230\u8d27\u5355\u5f02\u5e38\u4fe1\u606f {}", (Object)e.getMessage());
                }
            });
        }
        fixedThreadPool.shutdown();
    }

    private void pushSingle(PebSyncHtArriveAtomReqBO reqBO) {
        if (reqBO.getShipVoucherId() != null && reqBO.getIsFailPushFlag() != null && reqBO.getIsFailPushFlag() == 1) {
            OrdSalePO salePO;
            OrdShipPO shipPO = this.ordShipMapper.getModelById(reqBO.getShipVoucherId().longValue());
            if (shipPO == null || shipPO.getOrderId() == null) {
                return;
            }
            ContractHtQryListAbilityBO contract = this.checkPush(shipPO.getOrderId());
            if (contract == null || StringUtils.isEmpty((Object)contract.getOutContractUuId())) {
                return;
            }
            ArrayList<PebSyncHtArriveAtomBO> pushList = new ArrayList<PebSyncHtArriveAtomBO>();
            PebSyncHtArriveAtomMainBO pushArriveOrderAllDTO = new PebSyncHtArriveAtomMainBO();
            pushArriveOrderAllDTO.setContractNum(contract.getContractCode());
            if (shipPO.getOrderId() != null && (salePO = this.ordSaleMapper.getSaleVoucherNoByOrderId(shipPO.getOrderId())) != null) {
                pushArriveOrderAllDTO.setPoNum(salePO.getSaleVoucherNo());
            }
            pushArriveOrderAllDTO.setContractUuid(contract.getOutContractUuId());
            pushArriveOrderAllDTO.setShipVoucherId(reqBO.getShipVoucherId());
            PebSyncHtArriveAtomBO atomBO = new PebSyncHtArriveAtomBO();
            atomBO.setPushArriveOrderAllDTO(pushArriveOrderAllDTO);
            pushList.add(atomBO);
            this.addShipInfo(pushList);
            if (!CollectionUtil.isEmpty(pushList)) {
                ArrayList<PebSyncHtArriveAtomBO> newPushList = new ArrayList<PebSyncHtArriveAtomBO>();
                for (PebSyncHtArriveAtomBO bo : pushList) {
                    if (CollectionUtils.isEmpty(bo.getPushArriveOrderLinesDTOS())) continue;
                    newPushList.add(bo);
                }
                pushList = newPushList;
            }
            this.pushData(pushList, shipPO.getOrderId());
            return;
        }
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setConfirmId(reqBO.getConfirmId());
        OrdShipPushPO pUshShipInfo = this.ordShipMapper.getPushShipInfo(ordShipPO);
        UocOrdConfirmPO confirmPO = new UocOrdConfirmPO();
        confirmPO.setId(reqBO.getConfirmId());
        UocOrdConfirmPO ordConfirmPO = this.uocOrdConfirmMapper.getModel(confirmPO);
        if (!ObjectUtil.isEmpty((Object)pUshShipInfo)) {
            ContractHtQryListAbilityBO contract = this.checkPush(pUshShipInfo.getOrderId());
            if (contract == null || StringUtils.isEmpty((Object)contract.getOutContractUuId())) {
                return;
            }
            ArrayList<PebSyncHtArriveAtomBO> pushList = new ArrayList<PebSyncHtArriveAtomBO>();
            this.getPushArriveInfo(pUshShipInfo, reqBO, pushList, ordConfirmPO, contract);
            if (!CollectionUtils.isEmpty(pushList)) {
                if (reqBO.getIsFailPushFlag() == null || reqBO.getIsFailPushFlag() != 0) {
                    this.addShipInfo(pushList);
                }
                this.pushData(pushList, pUshShipInfo.getOrderId());
            }
        } else {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
    }

    private ContractHtQryListAbilityBO checkPush(Long orderId) {
        PebQryOrderIsPushHtAbilityReqBO htAbilityReqBO = new PebQryOrderIsPushHtAbilityReqBO();
        htAbilityReqBO.setOrderIds(Collections.singletonList(orderId));
        log.info("\u8ba2\u5355\u6821\u9a8c\u5408\u540c\u662f\u5426\u63a8\u9001\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)htAbilityReqBO));
        PebQryOrderIsPushHtAbilityRspBO orderIsPushHtAbilityRspBO = this.pebQryOrderIsPushHtAbilityService.qryOrderIsPushHt(htAbilityReqBO);
        log.info("\u8ba2\u5355\u6821\u9a8c\u5408\u540c\u662f\u5426\u63a8\u9001\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)orderIsPushHtAbilityRspBO));
        if ("0000".equals(orderIsPushHtAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)orderIsPushHtAbilityRspBO.getOrderInFoList())) {
            PebQryOrderIsPushHtAbilityBO htAbilityBO = (PebQryOrderIsPushHtAbilityBO)orderIsPushHtAbilityRspBO.getOrderInFoList().get(0);
            if (1 == htAbilityBO.getIsPushOutHt()) {
                ContractHtQryListAbilityReqBO htQryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
                htQryListAbilityReqBO.setContractIds(Collections.singletonList(htAbilityBO.getContractId()));
                log.info("\u5408\u540c\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)htQryListAbilityReqBO));
                ContractHtQryListAbilityRspBO htQryListAbilityRspBO = this.contractHtQryListAbilityService.qryHTList(htQryListAbilityReqBO);
                log.info("\u5408\u540c\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)htQryListAbilityRspBO));
                if ("0000".equals(htQryListAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)htQryListAbilityRspBO.getInfoList())) {
                    ContractHtQryListAbilityBO contractHtQryListAbilityBO = (ContractHtQryListAbilityBO)htQryListAbilityRspBO.getInfoList().get(0);
                    if (!StringUtils.isEmpty((Object)htAbilityBO.getContractUuid())) {
                        contractHtQryListAbilityBO.setOutContractUuId(htAbilityBO.getContractUuid());
                        contractHtQryListAbilityBO.setContractCode(htAbilityBO.getContractCode());
                    }
                    return contractHtQryListAbilityBO;
                }
                throw new BusinessException("8888", "contractHtQryListAbilityService \u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f");
            }
            log.error("\u8ba2\u5355\u6821\u9a8c\u5931\u8d25 \u4e0d\u63a8\u9001 {}", (Object)JSON.toJSONString((Object)orderIsPushHtAbilityRspBO));
        } else {
            log.info("\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u5f02\u5e38 {}", (Object)JSON.toJSONString((Object)orderIsPushHtAbilityRspBO));
        }
        return null;
    }

    private void pushSingleExt(PebSyncHtArriveAtomReqBO reqBO, OrdShipPushPO pUshShipInfo) {
        UocOrdConfirmPO ordConfirmPO = new UocOrdConfirmPO();
        ordConfirmPO.setConfirmCode(pUshShipInfo.getConfirmCode());
        ordConfirmPO.setCreateTime(pUshShipInfo.getConfirmTime());
        ContractHtQryListAbilityBO contract = this.checkPush(pUshShipInfo.getOrderId());
        if (contract == null || StringUtils.isEmpty((Object)contract.getOutContractUuId())) {
            return;
        }
        ArrayList<PebSyncHtArriveAtomBO> pushList = new ArrayList<PebSyncHtArriveAtomBO>();
        reqBO.setConfirmId(pUshShipInfo.getConfirmId());
        this.getPushArriveInfo(pUshShipInfo, reqBO, pushList, ordConfirmPO, contract);
        if (!CollectionUtils.isEmpty(pushList)) {
            this.addShipInfo(pushList);
            this.pushData(pushList, pUshShipInfo.getOrderId());
        }
    }

    private void pushData(List<PebSyncHtArriveAtomBO> pushList, Long orderId) {
        Date time = new Date();
        for (PebSyncHtArriveAtomBO arriveAtomBO : pushList) {
            UocContractSyncLogPO uocContractSyncLogPO = new UocContractSyncLogPO();
            uocContractSyncLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
            uocContractSyncLogPO.setCreateTime(time);
            uocContractSyncLogPO.setType(UocConstant.ContractPushType.CONFIRM);
            uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
            uocContractSyncLogPO.setUrl(this.ESP_ARRIVE_SHIP_PUSH_URL);
            uocContractSyncLogPO.setObjId(orderId);
            if ("Arrived".equals(arriveAtomBO.getPushArriveOrderAllDTO().getDocumentType()) && arriveAtomBO.getPushArriveOrderAllDTO().getConfirmId() != null) {
                uocContractSyncLogPO.setObjId(arriveAtomBO.getPushArriveOrderAllDTO().getConfirmId());
                uocContractSyncLogPO.setType(UocConstant.ContractPushType.CONFIRM);
            }
            if ("Shipped".equals(arriveAtomBO.getPushArriveOrderAllDTO().getDocumentType()) && arriveAtomBO.getPushArriveOrderAllDTO().getShipVoucherId() != null) {
                uocContractSyncLogPO.setObjId(arriveAtomBO.getPushArriveOrderAllDTO().getShipVoucherId());
                uocContractSyncLogPO.setType(UocConstant.ContractPushType.SHIP);
            }
            uocContractSyncLogPO.setObjNo(arriveAtomBO.getPushArriveOrderAllDTO().getObjNo());
            JSONObject push = new JSONObject();
            push.put("payload", (Object)JSON.toJSONString((Object)arriveAtomBO));
            String reqStr = JSON.toJSONString((Object)push);
            String respStr = null;
            HashMap<String, String> stringMap = new HashMap<String, String>();
            stringMap.put("Authorization", this.getTokenInfo());
            try {
                log.info("\u5230\u8d27\u5355\u63a8\u9001\u5165\u53c2\uff1a" + reqStr);
                uocContractSyncLogPO.setReqStr(reqStr);
                respStr = HttpUtil.doPost(this.ESP_ARRIVE_SHIP_PUSH_URL, reqStr, stringMap);
                log.info("\u5230\u8d27\u5355\u63a8\u9001\u51fa\u53c2\uff1a" + respStr);
                uocContractSyncLogPO.setRspStr(respStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
                uocContractSyncLogPO.setRspStr(e.getMessage());
                this.insertPushLog(uocContractSyncLogPO);
                this.insertFailLog(uocContractSyncLogPO);
                log.error("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u5f02\u5e38 {}", (Object)e.getMessage());
                continue;
            }
            if (StringUtils.isEmpty((Object)respStr)) {
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
                uocContractSyncLogPO.setRspStr(respStr);
                this.insertPushLog(uocContractSyncLogPO);
                this.insertFailLog(uocContractSyncLogPO);
                log.error("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u5f02\u5e38\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a:");
                continue;
            }
            try {
                PebExtUnifySettleEncryptionAbilityRspBO rspBO = (PebExtUnifySettleEncryptionAbilityRspBO)JSONObject.parseObject((String)respStr, PebExtUnifySettleEncryptionAbilityRspBO.class);
                if (rspBO.getStatus().equals("200")) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    uocContractSyncLogPO.setRspStr(respStr);
                    if (!ObjectUtil.isEmpty((Object)rspBO.getPayload())) {
                        JSONObject jsonObject = JSON.parseObject((String)rspBO.getPayload());
                        if (!StringUtils.isEmpty((Object)jsonObject.getString("code")) && "S".equals(jsonObject.getString("code"))) {
                            uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.SUCCESS);
                            this.insertPushLog(uocContractSyncLogPO);
                            continue;
                        }
                        this.insertPushLog(uocContractSyncLogPO);
                        this.insertFailLog(uocContractSyncLogPO);
                        continue;
                    }
                    this.insertPushLog(uocContractSyncLogPO);
                    this.insertFailLog(uocContractSyncLogPO);
                    continue;
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
                uocContractSyncLogPO.setRspStr(respStr);
                this.insertPushLog(uocContractSyncLogPO);
                this.insertFailLog(uocContractSyncLogPO);
            }
            catch (Exception e) {
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
                uocContractSyncLogPO.setRspStr(respStr);
                this.insertPushLog(uocContractSyncLogPO);
                this.insertFailLog(uocContractSyncLogPO);
                log.error("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            }
        }
    }

    private String getTokenInfo() {
        ContractHtGetTokenAbilityRspBO htToken = this.contractHtGetTokenAbilityService.getHTToken(new ContractHtGetTokenAbilityReqBO());
        log.info("token\u83b7\u53d6\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)htToken));
        if ("0000".equals(htToken.getRespCode())) {
            return htToken.getToken();
        }
        throw new BusinessException("8888", "token\u83b7\u53d6\u5931\u8d25");
    }

    private void insertFailLog(UocContractSyncLogPO uocContractSyncLogPO) {
        UocContractSyncFailLogPO failLogPO = (UocContractSyncFailLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)uocContractSyncLogPO), UocContractSyncFailLogPO.class);
        failLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
        this.uocContractSyncFailLogMapper.insert(failLogPO);
    }

    private void insertPushLog(UocContractSyncLogPO uocContractSyncLogPO) {
        this.uocContractSyncLogMapper.insert(uocContractSyncLogPO);
        try {
            UocSyncAllLogAbilityReqBO syncAllLogAbilityReqBO = new UocSyncAllLogAbilityReqBO();
            syncAllLogAbilityReqBO.setObjId(uocContractSyncLogPO.getObjId());
            syncAllLogAbilityReqBO.setObjNo(uocContractSyncLogPO.getObjNo());
            syncAllLogAbilityReqBO.setSystemCode("1");
            syncAllLogAbilityReqBO.setPushType(uocContractSyncLogPO.getType());
            syncAllLogAbilityReqBO.setCenterCode("order");
            syncAllLogAbilityReqBO.setPushTime(new Date());
            syncAllLogAbilityReqBO.setPushStatus(uocContractSyncLogPO.getStatus());
            this.uocSyncAllLogAbilityService.addLog(syncAllLogAbilityReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getPushArriveInfo(OrdShipPushPO pUshShipInfo, PebSyncHtArriveAtomReqBO reqBO, List<PebSyncHtArriveAtomBO> pushList, UocOrdConfirmPO ordConfirmPO, ContractHtQryListAbilityBO contract) {
        if (!ObjectUtils.isEmpty((Object)pUshShipInfo)) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setConfirmId(reqBO.getConfirmId());
            List pushShipDetails = this.ordShipMapper.getPushShipDetails(ordShipPO);
            this.getPushInfo(pUshShipInfo, pushList, pushShipDetails, UocCoreConstant.ModelSettle.MATCH_UP, ordConfirmPO, contract);
        }
    }

    private void getPushInfo(OrdShipPushPO pUshShipInfo, List<PebSyncHtArriveAtomBO> pushList, List<OrdShipItemPushPO> pushShipDetails, Integer mode, UocOrdConfirmPO ordConfirmPO, ContractHtQryListAbilityBO contract) {
        PebSyncHtArriveAtomBO pebSaleSyncHtArriveAtomBO = new PebSyncHtArriveAtomBO();
        PebSyncHtArriveAtomMainBO mainBO = new PebSyncHtArriveAtomMainBO();
        mainBO.setContractNum(contract.getContractCode());
        mainBO.setPoNum(pUshShipInfo.getSaleVoucherNo());
        mainBO.setArrivalTime(DateUtil.dateToStrLongNew((Date)ordConfirmPO.getCreateTime()));
        mainBO.setArrivalAddress(pUshShipInfo.getContactAddress());
        mainBO.setContractUuid(contract.getOutContractUuId());
        mainBO.setDocumentType("Arrived");
        mainBO.setConfirmId(ordConfirmPO.getId());
        mainBO.setObjNo(ordConfirmPO.getConfirmCode());
        Date orderApproveMaxDate = null;
        HashMap<Long, BigDecimal> orderItemIdMap = new HashMap<Long, BigDecimal>();
        if (pUshShipInfo.getOrderId() != null && (orderApproveMaxDate = this.ordStateChgLogMapper.getOrderApproveMaxDate(pUshShipInfo.getOrderId())) != null) {
            OrdItemMapPO searchPO = new OrdItemMapPO();
            searchPO.setOrderId(pUshShipInfo.getOrderId());
            searchPO.setFieldCode("orderDeliveryDate");
            List ordItemMapPOS = this.ordItemMapMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty((Collection)ordItemMapPOS)) {
                for (OrdItemMapPO ordItemMapPO : ordItemMapPOS) {
                    BigDecimal orderDeliveryDate = null;
                    if (!StringUtils.isEmpty((Object)ordItemMapPO.getFieldValue())) {
                        try {
                            orderDeliveryDate = new BigDecimal(ordItemMapPO.getFieldValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (orderDeliveryDate == null) continue;
                    orderItemIdMap.put(ordItemMapPO.getOrderItemId(), orderDeliveryDate);
                }
            }
        }
        if (pUshShipInfo.getEstimateArrivalTime() != null) {
            mainBO.setExpectedArrivalTime(DateUtil.dateToStrLongNew((Date)pUshShipInfo.getEstimateArrivalTime()));
        }
        mainBO.setShipVoucherId(pUshShipInfo.getShipVoucherId());
        pebSaleSyncHtArriveAtomBO.setPushArriveOrderAllDTO(mainBO);
        if (!CollectionUtils.isEmpty(pushShipDetails)) {
            List<PebSyncHtArriveDetailAtomBO> detailAtomBOS = pushShipDetails.stream().map(e -> {
                PebSyncHtArriveDetailAtomBO pebSyncHtArriveDetailAtomBO = (PebSyncHtArriveDetailAtomBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), PebSyncHtArriveDetailAtomBO.class);
                pebSyncHtArriveDetailAtomBO.setArriveNum(ordConfirmPO.getConfirmCode());
                pebSyncHtArriveDetailAtomBO.setArriveLineUuid(e.getArriveItemId().toString());
                pebSyncHtArriveDetailAtomBO.setPoLineUuid(e.getOrdItemId().toString());
                pebSyncHtArriveDetailAtomBO.setItemNum(e.getSkuId());
                pebSyncHtArriveDetailAtomBO.setQuantity(e.getArriveCount().toString());
                pebSyncHtArriveDetailAtomBO.setUnit(e.getUnitName());
                pebSyncHtArriveDetailAtomBO.setItemName(e.getSkuName());
                pebSyncHtArriveDetailAtomBO.setTaxRate(e.getTax());
                if (e.getShipItemId() != null) {
                    pebSyncHtArriveDetailAtomBO.setShipLineUuid(e.getShipItemId().toString());
                }
                try {
                    pebSyncHtArriveDetailAtomBO.setPriceSell(UocMoneyUtil.Long2BigDecimal((Long)e.getSalePrice()));
                    pebSyncHtArriveDetailAtomBO.setPrice(UocMoneyUtil.Long2BigDecimal((Long)e.getPurchasePrice()));
                }
                catch (Exception exception) {
                    throw new BusinessException("8888", exception.getMessage());
                }
                BigDecimal taxFee = pebSyncHtArriveDetailAtomBO.getPriceSell().multiply(e.getArriveCount()).setScale(2, RoundingMode.HALF_UP);
                pebSyncHtArriveDetailAtomBO.setTaxIncluded(taxFee);
                BigDecimal tax = new BigDecimal(e.getTax()).multiply(new BigDecimal("0.01"));
                BigDecimal noTaxPrice = pebSyncHtArriveDetailAtomBO.getPriceSell().divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
                BigDecimal noTaxAmount = noTaxPrice.multiply(e.getArriveCount()).setScale(2, RoundingMode.HALF_UP);
                pebSyncHtArriveDetailAtomBO.setTaxNotincluded(noTaxAmount);
                pebSyncHtArriveDetailAtomBO.setTax(pebSyncHtArriveDetailAtomBO.getTaxIncluded().subtract(pebSyncHtArriveDetailAtomBO.getTaxNotincluded()).toString());
                return pebSyncHtArriveDetailAtomBO;
            }).collect(Collectors.toList());
            BigDecimal difference = null;
            Date arriveTime = pUshShipInfo.getArriveTime();
            arriveTime = ordConfirmPO.getCreateTime();
            if (arriveTime != null && orderApproveMaxDate != null && arriveTime.after(orderApproveMaxDate)) {
                LocalDateTime localDateTime1 = orderApproveMaxDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime localDateTime2 = arriveTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                long daysDifference = Math.abs(ChronoUnit.DAYS.between(localDateTime1, localDateTime2));
                difference = new BigDecimal(daysDifference);
            }
            if (!CollectionUtils.isEmpty(detailAtomBOS) && difference != null) {
                for (PebSyncHtArriveDetailAtomBO detailAtomBO : detailAtomBOS) {
                    if (!orderItemIdMap.containsKey(Long.valueOf(detailAtomBO.getPoLineUuid()))) continue;
                    BigDecimal orderDeliveryDate = (BigDecimal)orderItemIdMap.get(Long.valueOf(detailAtomBO.getPoLineUuid()));
                    if (difference.compareTo(orderDeliveryDate) > 0) {
                        detailAtomBO.setIsExtension("Y");
                        detailAtomBO.setExtensionTime(difference.subtract(orderDeliveryDate).toString());
                        continue;
                    }
                    detailAtomBO.setIsExtension("N");
                }
            }
            pebSaleSyncHtArriveAtomBO.setPushArriveOrderLinesDTOS(detailAtomBOS);
        }
        pushList.add(pebSaleSyncHtArriveAtomBO);
    }

    private void addShipInfo(List<PebSyncHtArriveAtomBO> pushList) {
        if (!CollectionUtils.isEmpty(pushList)) {
            ArrayList<PebSyncHtArriveAtomBO> shipList = new ArrayList<PebSyncHtArriveAtomBO>();
            for (PebSyncHtArriveAtomBO pebSyncHtArriveAtomBO : pushList) {
                PebSyncHtArriveAtomMainBO arriveAtomMainBO = pebSyncHtArriveAtomBO.getPushArriveOrderAllDTO();
                Long shipVoucherId = pebSyncHtArriveAtomBO.getPushArriveOrderAllDTO().getShipVoucherId();
                if (arriveAtomMainBO == null || shipVoucherId == null || StringUtils.isEmpty((Object)arriveAtomMainBO.getContractUuid())) continue;
                PebSyncHtArriveAtomBO shipBO = new PebSyncHtArriveAtomBO();
                PebSyncHtArriveAtomMainBO shipAtomMainBO = (PebSyncHtArriveAtomMainBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)arriveAtomMainBO), PebSyncHtArriveAtomMainBO.class);
                shipAtomMainBO.setShipVoucherId(shipVoucherId);
                shipAtomMainBO.setDocumentType("Shipped");
                OrdShipPO shipPO = this.ordShipMapper.getModelById(shipVoucherId.longValue());
                if (shipPO == null) continue;
                if (shipPO.getEstimateArrivalTime() != null) {
                    shipAtomMainBO.setExpectedArrivalTime(DateUtil.dateToStrLongNew((Date)shipPO.getEstimateArrivalTime()));
                }
                shipAtomMainBO.setArrivalTime(DateUtil.dateToStrLongNew((Date)shipPO.getCreateTime()));
                shipAtomMainBO.setArrivalAddress(shipPO.getShipAdress());
                shipAtomMainBO.setObjNo(shipPO.getShipVoucherCode());
                OrdShipPO searchPO = new OrdShipPO();
                searchPO.setShipVoucherId(shipVoucherId);
                List pushShipDetails = this.ordShipMapper.getPushShipItems(searchPO);
                if (CollectionUtils.isEmpty((Collection)pushShipDetails) || CollectionUtils.isEmpty((Collection)pushShipDetails)) continue;
                List<PebSyncHtArriveDetailAtomBO> detailAtomBOS = pushShipDetails.stream().filter(e -> e.getSendCount() != null).map(e -> {
                    PebSyncHtArriveDetailAtomBO pebSyncHtArriveDetailAtomBO = new PebSyncHtArriveDetailAtomBO();
                    pebSyncHtArriveDetailAtomBO.setArriveNum(shipPO.getShipVoucherCode());
                    pebSyncHtArriveDetailAtomBO.setArriveLineUuid(e.getShipItemId().toString());
                    pebSyncHtArriveDetailAtomBO.setPoLineUuid(e.getOrdItemId().toString());
                    pebSyncHtArriveDetailAtomBO.setItemNum(e.getSkuId());
                    pebSyncHtArriveDetailAtomBO.setQuantity(e.getSendCount().toString());
                    pebSyncHtArriveDetailAtomBO.setUnit(e.getUnitName());
                    pebSyncHtArriveDetailAtomBO.setItemName(e.getSkuName());
                    pebSyncHtArriveDetailAtomBO.setTaxRate(e.getTax());
                    try {
                        pebSyncHtArriveDetailAtomBO.setPriceSell(UocMoneyUtil.Long2BigDecimal((Long)e.getSalePrice()));
                        pebSyncHtArriveDetailAtomBO.setPrice(UocMoneyUtil.Long2BigDecimal((Long)e.getPurchasePrice()));
                    }
                    catch (Exception exception) {
                        throw new BusinessException("8888", exception.getMessage());
                    }
                    BigDecimal taxFee = pebSyncHtArriveDetailAtomBO.getPriceSell().multiply(e.getSendCount()).setScale(2, RoundingMode.HALF_UP);
                    pebSyncHtArriveDetailAtomBO.setTaxIncluded(taxFee);
                    BigDecimal tax = new BigDecimal(e.getTax()).multiply(new BigDecimal("0.01"));
                    BigDecimal noTaxPrice = pebSyncHtArriveDetailAtomBO.getPriceSell().divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
                    BigDecimal noTaxAmount = noTaxPrice.multiply(e.getSendCount()).setScale(2, RoundingMode.HALF_UP);
                    pebSyncHtArriveDetailAtomBO.setTaxNotincluded(noTaxAmount);
                    pebSyncHtArriveDetailAtomBO.setTax(pebSyncHtArriveDetailAtomBO.getTaxIncluded().subtract(pebSyncHtArriveDetailAtomBO.getTaxNotincluded()).toString());
                    return pebSyncHtArriveDetailAtomBO;
                }).collect(Collectors.toList());
                shipBO.setPushArriveOrderLinesDTOS(detailAtomBOS);
                shipBO.setPushArriveOrderAllDTO(shipAtomMainBO);
                shipList.add(shipBO);
            }
            pushList.addAll(shipList);
        }
    }
}

