/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemRspBOOld;
import com.tydic.uoc.common.ability.bo.UocCoreOryShipReqBO;
import com.tydic.uoc.common.atom.api.UocCoreQryOrdeShipItemListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderItemListAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreOryOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderItemListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderShipItemListRspBO;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="uocCoreQryOrdeShipItemListAtomService")
public class UocCoreQryOrdeShipItemListAtomServiceImpl
implements UocCoreQryOrdeShipItemListAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreQryOrdeShipItemListAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    OrdShipItemMapper ordShipItemMapper;
    @Autowired
    OrdShipMapper ordShipMapper;
    @Autowired
    UocCoreQryOrderItemListAtomService uocCoreQryOrderItemListAtomService;

    @Override
    public UocCoreQryOrderShipItemListRspBO qryCoreQryOrderShipItemList(UocCoreOryShipReqBO reqBO) {
        try {
            UocCoreQryOrderShipItemListRspBO rspBO = new UocCoreQryOrderShipItemListRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u6838\u5fc3\u67e5\u8be2\u6210\u529f");
            this.validateArg(reqBO);
            Page page = new Page();
            page.setPageNo(reqBO.getPageNo());
            page.setPageSize(reqBO.getPageSize());
            page.setLimit(reqBO.getPageSize());
            page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
            OrdShipItemPO condition = new OrdShipItemPO();
            ArrayList<Long> shipVoucherIds = new ArrayList<Long>();
            if (reqBO.getSaleVoucherId() != null && reqBO.getShipItemId() == null && reqBO.getOrderId() != null) {
                OrdShipPO ordShipCondition = new OrdShipPO();
                ordShipCondition.setSaleVoucherId(reqBO.getSaleVoucherId());
                ordShipCondition.setOrderId(reqBO.getOrderId());
                List shipList = this.ordShipMapper.getList(ordShipCondition);
                if (shipList != null && shipList.size() > 0) {
                    for (OrdShipPO ordShipPO : shipList) {
                        shipVoucherIds.add(ordShipPO.getShipVoucherId());
                    }
                    condition.setShipVoucherIds(shipVoucherIds);
                }
            }
            condition.setOrderId(reqBO.getOrderId());
            condition.setShipVoucherId(reqBO.getShipVoucherId());
            condition.setShipItemId(reqBO.getShipItemId());
            List rspList = this.ordShipItemMapper.getListPage(condition, page);
            for (OrdShipItemRspBOOld ordShipItemRspBOOld : rspList) {
                UocCoreOryOrderReqBO uocCoreOryOrderDetailReqBO = new UocCoreOryOrderReqBO();
                uocCoreOryOrderDetailReqBO.setOrderId(ordShipItemRspBOOld.getOrderId());
                uocCoreOryOrderDetailReqBO.setOrdItemId(ordShipItemRspBOOld.getOrdItemId());
                UocCoreQryOrderItemListRspBO uocCoreQryOrderItemListRspBO = this.uocCoreQryOrderItemListAtomService.qryCoreQryOrderItemList(uocCoreOryOrderDetailReqBO);
                if (uocCoreQryOrderItemListRspBO.getRespCode().equals("0000") && uocCoreQryOrderItemListRspBO.getRows().size() > 0) {
                    ordShipItemRspBOOld.setOrderItemRspBO((OrdItemRspBO)uocCoreQryOrderItemListRspBO.getRows().get(0));
                }
                if (ordShipItemRspBOOld.getArriveCount() == null) {
                    ordShipItemRspBOOld.setArriveCount(BigDecimal.ZERO);
                }
                if (ordShipItemRspBOOld.getAcceptanceCount() == null) {
                    ordShipItemRspBOOld.setAcceptanceCount(BigDecimal.ZERO);
                }
                ordShipItemRspBOOld.setRemainAcceptanceCount(ordShipItemRspBOOld.getSendCount().subtract(ordShipItemRspBOOld.getAcceptanceCount()));
            }
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRows(rspList);
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u53d1\u8d27\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101072", "\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void validateArg(UocCoreOryShipReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null && reqBO.getShipVoucherId() == null && reqBO.getShipItemId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010saleVoucherId\u3011\u548c \u3010shipVoucherId\u3011\u3010shipItemId\u3011\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
    }
}

