/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.pay.ability.api.FscShouldPayTerminationAbilityService;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfApplyCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderData;
import com.tydic.uoc.common.ability.api.PebExtContractMarkerPushOrderAbilityService;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocNoTaskAuditOrderAuditNoticeBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryTacheIntfAtomService;
import com.tydic.uoc.common.atom.api.UocPebUniCallIntfAtomService;
import com.tydic.uoc.common.atom.api.UocReturnFeeAtomService;
import com.tydic.uoc.common.atom.api.UocReturnFeeDealNotaxMoneyAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocSendNotificationExtAtomService;
import com.tydic.uoc.common.atom.bo.InterfaceDefBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.UnicallInterfaceDefBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTacheIntfReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTacheIntfRspBO;
import com.tydic.uoc.common.atom.bo.UocPebUniCallIntfReqBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeDealNotaxMoneyAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeDealNotaxMoneyAtomRspBO;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocCallPlanCenterBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushPurchaseContractService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceReqBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdFscShouldPayPo;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtCancelBusiServiceImpl
implements PebExtCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtCancelBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfApplyCancelOrderAbilityService pebIntfApplyCancelOrderAbilityService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocCallPlanCenterBusiService uocCallPlanCenterBusiService;
    @Autowired
    private UocOrdFscShouldPayMapper ordFscShouldPayMapper;
    @Autowired
    private FscShouldPayTerminationAbilityService fscShouldPayTerminationAbilityService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${SUPPLIER_JD_ID:100055}")
    private Long supplierIdJD;
    @Autowired
    private UocCoreQryTacheIntfAtomService uocCoreQryTacheIntfAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocReturnFeeAtomService uocReturnFeeAtomService;
    @Autowired
    private UccGateWayApplicationPushPurchaseContractService uccGateWayApplicationPushPurchaseContractService;
    @Autowired
    private PebExtContractMarkerPushOrderAbilityService markerPushOrderAbilityService;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private String snIdFl;
    @Autowired
    private UocSendNotificationExtAtomService uocSendNotificationExtAtomService;
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private UocReturnFeeDealNotaxMoneyAtomService uocReturnFeeDealNotaxMoneyAtomService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebExtCancelRspBO dealOrderCancelled(PebExtCancelReqBO reqBO) {
        boolean isPush;
        PebExtCancelRspBO rspBO = new PebExtCancelRspBO();
        log.debug("\u6267\u884c\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        this.cancelFscShouldPay(reqBO);
        ArrayList<Long> sendOrderIdList = new ArrayList<Long>();
        if (UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PRE_ORDER.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.CREATE.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ADMIN_COMFRIM.equals(salePO.getSaleState())) {
            isPush = false;
        } else if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(salePO.getSaleState())) {
            isPush = !PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource());
        } else {
            throw new UocProBusinessException("102035", "\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (!PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET.toString().equals(salePO.getOrderSource()) && UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            isPush = false;
        }
        OrdCancelPO cancelPo = new OrdCancelPO();
        cancelPo.setId(Long.valueOf(this.idUtil.nextId()));
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(salePO.getOrderSource()) || UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource()) || UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(salePO.getOrderSource())) {
            this.audit(reqBO, cancelPo, salePO, rspBO);
            isPush = false;
        }
        rspBO.setPush(Boolean.valueOf(isPush));
        rspBO.setSaleId(salePO.getSaleVoucherId());
        rspBO.setIsPush(Boolean.valueOf(false));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.save(salePO, reqBO, isPush, cancelPo);
        this.saveAccessory(reqBO, cancelPo.getId());
        if (!isPush && PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET.toString().equals(salePO.getOrderSource())) {
            UocCoreQryTacheIntfReqBO uocCoreQryTacheIntfReqBO = new UocCoreQryTacheIntfReqBO();
            uocCoreQryTacheIntfReqBO.setFlowFlag(UocConstant.FLOW_FLAG.NEGATIVE);
            uocCoreQryTacheIntfReqBO.setTacheCode(String.valueOf(UocConstant.SALE_ORDER_STATUS.CANCEL));
            UocCoreQryTacheIntfRspBO intfRspBO = this.uocCoreQryTacheIntfAtomService.qryTacheIntf(uocCoreQryTacheIntfReqBO);
            if (!"0000".equals(intfRspBO.getRespCode())) {
                rspBO.setRespCode("102078");
                rspBO.setRespDesc(intfRspBO.getRespDesc());
                return rspBO;
            }
            if (CollectionUtils.isNotEmpty(intfRspBO.getInterfaceList())) {
                for (InterfaceDefBO defBO : intfRspBO.getInterfaceList()) {
                    try {
                        UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
                        UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
                        BeanUtils.copyProperties((Object)defBO, (Object)interfaceDefBO);
                        callIntfReqBO.setInterfaceDef(interfaceDefBO);
                        callIntfReqBO.setOrderId(reqBO.getOrderId());
                        callIntfReqBO.setObjId(reqBO.getSaleVoucherId());
                        callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                        this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
                    }
                    catch (Exception callIntfReqBO) {}
                }
            }
            OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
            this.updateStatus(reqBO, salePO, orderPO);
            OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
            stakeholderPO.setOrderId(reqBO.getOrderId());
            stakeholderPO.setExtField3("1");
            this.ordStakeholderMapper.updateById(stakeholderPO);
            UocReturnFeeAtomReqBO atomReqBO = new UocReturnFeeAtomReqBO();
            UocReturnFeeDealNotaxMoneyAtomReqBO notTaxMoneyReqBO = new UocReturnFeeDealNotaxMoneyAtomReqBO();
            notTaxMoneyReqBO.setOrderId(reqBO.getOrderId());
            notTaxMoneyReqBO.setObjType(2);
            UocReturnFeeDealNotaxMoneyAtomRspBO notaxMoney = this.uocReturnFeeDealNotaxMoneyAtomService.getNotaxMoney(notTaxMoneyReqBO);
            try {
                atomReqBO.setFee(MoneyUtils.Long2BigDecimal((Long)salePO.getSaleFee()));
                atomReqBO.setProFee(MoneyUtils.Long2BigDecimal((Long)salePO.getPurchaseFee()));
                atomReqBO.setNoTaxProFee(MoneyUtil.coverTwo((BigDecimal)notaxMoney.getNoTaxProFee()));
                atomReqBO.setProTaxFee(MoneyUtil.coverTwo((BigDecimal)notaxMoney.getProTaxFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            atomReqBO.setOrderId(salePO.getOrderId());
            atomReqBO.setObjId(salePO.getSaleVoucherId());
            atomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            atomReqBO.setSaleState(salePO.getSaleState());
            atomReqBO.setToken(reqBO.getToken());
            atomReqBO.setRefundType(FscConstants.RefundType.CANCEL);
            UocReturnFeeAtomRspBO atomRspBO = this.uocReturnFeeAtomService.returnFee(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new UocProBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            atomReqBO.setOrderId(salePO.getOrderId());
            if (atomRspBO.getIsFl().booleanValue()) {
                rspBO.setReqJsonStr(JSONObject.toJSONString((Object)atomReqBO));
            }
            if (atomRspBO.getSendFlag() != null && atomRspBO.getSendFlag().booleanValue()) {
                sendOrderIdList.add(atomReqBO.getOrderId());
                rspBO.setSendOrderIdList(sendOrderIdList);
            }
            return rspBO;
        }
        this.push(salePO, isPush);
        if (!isPush) {
            UocCallPlanCenterBusiServiceReqBo updatePlan = new UocCallPlanCenterBusiServiceReqBo();
            updatePlan.setOrderId(salePO.getOrderId());
            updatePlan.setDirection(false);
            this.uocCallPlanCenterBusiService.updatePlanData(updatePlan);
        }
        this.run(reqBO);
        if (reqBO.getOrderId() != null) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(reqBO.getOrderId());
            this.pushInfo(list);
        }
        rspBO.setIsPush(Boolean.valueOf(isPush));
        return rspBO;
    }

    private void pushInfo(List<Long> list) {
        try {
            List pushOrderIds = this.markerPushOrderAbilityService.getOrderPushFlag(list);
            if (!CollectionUtils.isEmpty((Collection)pushOrderIds)) {
                PebSyncHtPurchaseContractAtomReqBO contractAtomReqBO = new PebSyncHtPurchaseContractAtomReqBO();
                contractAtomReqBO.setOrderIds(pushOrderIds);
                this.uccGateWayApplicationPushPurchaseContractService.syncHtPurchase(contractAtomReqBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @Override
    public PebExtCancelRspBO dealInvalidOrder(PebExtCancelReqBO reqBO) {
        OrdItemPO itemPO = new OrdItemPO();
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> sendOrderIdList = new ArrayList<Long>();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal proFee = BigDecimal.ZERO;
        BigDecimal totalTaxMoney = BigDecimal.ZERO;
        BigDecimal totalNoTaxAmount = BigDecimal.ZERO;
        for (OrdItemPO ordItemPO : list) {
            BigDecimal last = ordItemPO.getPurchaseCount().subtract(ordItemPO.getRefuseCount()).subtract(ordItemPO.getReturnCount());
            if (StringUtils.isNotBlank((CharSequence)ordItemPO.getExtField5()) && new BigDecimal(ordItemPO.getExtField5()).compareTo(BigDecimal.ZERO) > 0) {
                throw new UocProBusinessException("102078", "\u8ba2\u5355\u6ca1\u6709\u5168\u90e8\u9000\u5e93\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            if (ordItemPO.getSendCount().compareTo(BigDecimal.ZERO) > 0 && ordItemPO.getArriveCount().add(ordItemPO.getRefuseCount()).compareTo(ordItemPO.getSendCount()) < 0) {
                throw new UocProBusinessException("102078", "\u8ba2\u5355\u8fd8\u6709\u53d1\u8d27\u4e2d\u6570\u91cf\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
            }
            BigDecimal total = MoneyUtil.b2b((BigDecimal)ordItemPO.getSaleDecimalPrice().multiply(last));
            BigDecimal proTotal = MoneyUtil.b2b((BigDecimal)ordItemPO.getPurchaseDecimalPrice().multiply(last));
            fee = fee.add(total);
            proFee = proFee.add(proTotal);
            BigDecimal tax = new BigDecimal(ordItemPO.getTax()).multiply(new BigDecimal("0.01"));
            BigDecimal noTaxAmount = proTotal.divide(BigDecimal.ONE.add(tax), 2, RoundingMode.HALF_UP).stripTrailingZeros();
            BigDecimal taxMoney = proTotal.subtract(noTaxAmount);
            totalTaxMoney = totalTaxMoney.add(taxMoney);
            totalNoTaxAmount = totalNoTaxAmount.add(noTaxAmount);
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelReason())) {
            reqBO.setCancelReason(reqBO.getCancelDesc());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelDesc())) {
            reqBO.setCancelDesc(reqBO.getCancelReason());
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setCancelDesc(reqBO.getCancelDesc() == null ? "\u8ba2\u5355\u53d6\u6d88" : reqBO.getCancelDesc());
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelTime(new Date());
        orderPO.setCancelOperId(reqBO.getUserId() == null ? orderPO.getCreateOperId() : String.valueOf(reqBO.getUserId()));
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u53d6\u6d88\u66f4\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        this.updateStatus(reqBO, salePO, orderPO);
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        stakeholderPO.setExtField3("1");
        this.ordStakeholderMapper.updateById(stakeholderPO);
        OrdCancelPO cancelPo = new OrdCancelPO();
        cancelPo.setId(Long.valueOf(this.idUtil.nextId()));
        PebExtCancelRspBO rspBO = new PebExtCancelRspBO();
        rspBO.setSaleId(salePO.getSaleVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.save(salePO, reqBO, false, cancelPo);
        this.saveAccessory(reqBO, cancelPo.getId());
        this.pusherp(salePO, null, orderPO.getCancelDesc());
        UocReturnFeeAtomReqBO atomReqBO = new UocReturnFeeAtomReqBO();
        try {
            atomReqBO.setFee(fee);
            atomReqBO.setProFee(proFee);
            atomReqBO.setNoTaxProFee(MoneyUtil.coverTwo((BigDecimal)totalNoTaxAmount));
            atomReqBO.setProTaxFee(MoneyUtil.coverTwo((BigDecimal)totalTaxMoney));
        }
        catch (Exception tax) {
            // empty catch block
        }
        atomReqBO.setOrderId(salePO.getOrderId());
        atomReqBO.setObjId(salePO.getSaleVoucherId());
        atomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        atomReqBO.setSaleState(salePO.getSaleState());
        atomReqBO.setToken(reqBO.getToken());
        atomReqBO.setRefundType(FscConstants.RefundType.CANCEL);
        atomReqBO.setRefundType(FscConstants.RefundType.CANCEL);
        UocReturnFeeAtomRspBO atomRspBO = this.uocReturnFeeAtomService.returnFee(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new UocProBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        if (atomRspBO.getSendFlag() != null && atomRspBO.getSendFlag().booleanValue()) {
            sendOrderIdList.add(atomReqBO.getOrderId());
        }
        atomReqBO.setOrderId(salePO.getOrderId());
        rspBO.setOrderSource(salePO.getOrderSource());
        rspBO.setSendOrderIdList(sendOrderIdList);
        if (UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(salePO.getChangeSaleState())) {
            this.pushTodoWait(reqBO, salePO);
        }
        return rspBO;
    }

    @Override
    public PebExtCancelRspBO updateErpOrder(PebExtCancelReqBO reqBO) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO.setIsPushErp(Integer.valueOf(reqBO.getResult() == 0 ? 1 : 0));
        zmInfoPO.setErpStatus(Integer.valueOf(0));
        if (reqBO.getSzFlag().booleanValue()) {
            zmInfoPO.setIsPlanOrder(Integer.valueOf(0));
        }
        if (reqBO.getResult() == 0) {
            zmInfoPO.setVendorSiteId(reqBO.getVendorSiteId());
            zmInfoPO.setVendorSiteName(reqBO.getVendorSiteName());
            zmInfoPO.setConsignee(reqBO.getConsignee());
            zmInfoPO.setConsigneeId(reqBO.getConsigneeId());
            zmInfoPO.setAcquirer(reqBO.getAcquirer());
            zmInfoPO.setAcquirerId(reqBO.getAcquirerId());
        }
        this.uocOrdZmInfoMapper.update(zmInfoPO);
        if (reqBO.getResult() == 0) {
            List list = reqBO.getSaleOrderItemList().stream().map(x -> {
                OrdItemPO itemPO = new OrdItemPO();
                itemPO.setExtField2(x.getSkuMaterialDesc());
                itemPO.setExtField3(x.getSkuMaterialUnit());
                itemPO.setExtField4("0".equals(reqBO.getExt1()) ? "4" : "0");
                itemPO.setSkuId(x.getSkuId());
                itemPO.setOrderId(reqBO.getOrderId());
                itemPO.setSkuMaterialId(x.getSkuMaterialId());
                itemPO.setSkuName(x.getSkuMaterialName());
                itemPO.setOrganizationId(x.getOrganizationId());
                itemPO.setOrganizationName(x.getOrganizationName());
                itemPO.setOrganizationCode(x.getOrganizationCode());
                return itemPO;
            }).collect(Collectors.toList());
            this.ordItemMapper.updateByListErp(list, reqBO.getOrderId());
            this.ordItemMapper.updateByListGoodsErp(list, reqBO.getOrderId());
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            List itemPOList = this.ordItemMapper.getList(itemPO);
            Map<String, Long> idMap = itemPOList.stream().collect(Collectors.toMap(OrdItemPO::getSkuId, OrdItemPO::getOrdItemId));
            ArrayList inboundPathList = new ArrayList();
            reqBO.getSaleOrderItemList().forEach(x -> {
                OrdItemMapPO itemMapPO = new OrdItemMapPO();
                itemMapPO.setOrderId(reqBO.getOrderId());
                itemMapPO.setOrderItemId((Long)idMap.get(x.getSkuId()));
                itemMapPO.setFieldCode("inboundPath");
                itemMapPO.setFieldValue(StringUtils.isBlank((CharSequence)x.getInboundPath()) ? "" : x.getInboundPath());
                inboundPathList.add(itemMapPO);
            });
            if (!CollectionUtils.isEmpty(inboundPathList)) {
                this.ordItemMapMapper.updateItemMap(inboundPathList, reqBO.getOrderId(), "inboundPath");
            }
            ArrayList inboundPathIdList = new ArrayList();
            reqBO.getSaleOrderItemList().forEach(x -> {
                OrdItemMapPO itemMapPO = new OrdItemMapPO();
                itemMapPO.setOrderId(reqBO.getOrderId());
                itemMapPO.setOrderItemId((Long)idMap.get(x.getSkuId()));
                itemMapPO.setFieldCode("inboundPathId");
                itemMapPO.setFieldValue(StringUtils.isBlank((CharSequence)x.getInboundPathId()) ? "" : x.getInboundPathId());
                inboundPathIdList.add(itemMapPO);
            });
            if (!CollectionUtils.isEmpty(inboundPathIdList)) {
                this.ordItemMapMapper.updateItemMap(inboundPathIdList, reqBO.getOrderId(), "inboundPathId");
            }
            this.ordExtMapMapper.deleteByFscHandler(reqBO.getOrderId(), reqBO.getSaleVoucherId());
            ArrayList<OrdExtMapPO> fscList = new ArrayList<OrdExtMapPO>();
            if (Objects.nonNull(reqBO.getFschandlerId())) {
                this.build("fschandlerId", "\u7ed3\u7b97\u7ecf\u529e\u4ebaID", reqBO.getFschandlerId() + "", reqBO.getOrderId(), fscList, reqBO.getSaleVoucherId());
                this.build("fschandlerName", "\u7ed3\u7b97\u7ecf\u529e\u4eba\u540d\u79f0", reqBO.getFschandlerName(), reqBO.getOrderId(), fscList, reqBO.getSaleVoucherId());
                this.build("isPushSiku", "\u662f\u5426\u63a8\u9001\u53f8\u5e93", reqBO.getIsPushSiku() + "", reqBO.getOrderId(), fscList, reqBO.getSaleVoucherId());
            }
            if (fscList.size() > 0) {
                this.ordExtMapMapper.insertBatch(fscList);
            }
        } else {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            itemPO.setExtField4("4");
            this.ordItemMapper.updateByExt4(itemPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setExt4(reqBO.getExt1());
        this.ordSaleMapper.updateById(salePO);
        PebExtCancelRspBO rspBO = new PebExtCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void pusherp(OrdSalePO salePO, Long lineId, String desc) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(salePO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            return;
        }
        PebIntfCancelPurchaseOrderAbilityReqBo reqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        ArrayList<PebIntfCancelPurchaseOrderData> data = new ArrayList<PebIntfCancelPurchaseOrderData>();
        PebIntfCancelPurchaseOrderData orderData = new PebIntfCancelPurchaseOrderData();
        orderData.setCANCEL_REASON(desc);
        orderData.setPO_NUM(salePO.getSaleVoucherNo());
        orderData.setPO_LINE_ID(lineId);
        orderData.setUSER_NAME(zmInfoPO.getErpUserName());
        orderData.setORG_ID(Long.valueOf(zmInfoPO.getBuynerErpNo()));
        data.add(orderData);
        reqBo.setPBATCH_ID(String.valueOf(System.currentTimeMillis()));
        reqBo.setHEADER_DATA(data);
        PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(reqBo);
        if (!("0000".equals(rspBo.getRespCode()) || rspBo.getRespDesc().contains("\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c") || rspBo.getRespDesc().contains("\u5df2\u53d6\u6d88"))) {
            throw new UocProBusinessException(rspBo.getRespCode(), "\u53d6\u6d88erp\u5931\u8d25:" + rspBo.getRespDesc());
        }
        this.saveLog(salePO.getOrderId(), rspBo, reqBo);
    }

    private void saveLog(Long orderId, PebIntfCancelPurchaseOrderAbilityRspBo purchaseOrderRspBO, PebIntfCancelPurchaseOrderAbilityReqBo purchaseOrderReqBO) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(purchaseOrderRspBO.getRespCode());
        logBO.setOutContent(purchaseOrderRspBO.getReturnString());
        logBO.setOrderId(orderId);
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        logBO.setCallCount(1);
        logBO.setFlowFlag(1);
        logBO.setErrDetail("1");
        logBO.setInContent(JSON.toJSONString((Object)purchaseOrderReqBO));
        logBO.setInterCode("pushErp");
        logBO.setInterSn("1");
        logBO.setCallState("1");
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateStatus(PebExtCancelReqBO reqBO, OrdSalePO saleRspBO, OrderPO orderPO) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc("\u8ba2\u5355\u53d6\u6d88");
        if (reqBO.getUserId() != null) {
            voucherStateReqBO.setOperId(reqBO.getUserId().toString());
        } else {
            voucherStateReqBO.setOperId(orderPO.getCreateOperId());
        }
        voucherStateReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBOS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(UocConstant.SALE_ORDER_STATUS.CANCEL);
        voucherStateBO.setObjId(saleRspBO.getSaleVoucherId());
        voucherStateBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        voucherStateBOS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBOS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }

    private void saveAccessory(PebExtCancelReqBO reqBO, Long cancelId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        Long orderId = reqBO.getOrderId();
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.CANCEL);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(cancelId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void run(PebExtCancelReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("cancelFlag", "1");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void audit(PebExtCancelReqBO reqBO, OrdCancelPO cancelPO, OrdSalePO salePO, PebExtCancelRspBO rspBO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getUsername());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        infoReqBO.setUsername(reqBO.getUsername());
        infoReqBO.setRemark("\u8ba2\u5355\u53d6\u6d88\u9700\u8981\u8fdb\u884c\u5ba1\u6279");
        infoReqBO.setOrderId(reqBO.getOrderId());
        infoReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        noTaskAuditCreateReqBO.setProcDefKey("cancelOrder");
        approvalObjBO.setObjId(String.valueOf(cancelPO.getId()));
        approvalObjBO.setOrderId(cancelPO.getOrderId());
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditCreateRspBO.getAuditNoticeList())) {
            List auditNoticeList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO.getAuditNoticeList()), UocNoTaskAuditOrderAuditNoticeBO.class);
            rspBO.setAuditNoticeList(auditNoticeList);
        }
        cancelPO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
    }

    private void push(OrdSalePO salePO, boolean push) {
        PebIntfApplyCancelOrderRspBO rspBO;
        if (!push) {
            return;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
        if (Long.valueOf(stakeholderPO.getSupNo()).equals(this.supplierIdJD) || stakeholderPO.getSupNo().equals(this.jdIdFl)) {
            throw new UocProBusinessException("102035", "\u4eac\u4e1c\u786e\u8ba4\u8ba2\u5355\u4e0d\u80fd\u5728\u7ebf\u53d6\u6d88\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        if ((OrderPropertiesUtil.getProperty((String)"SUPPLIER_SUNING_ID").equals(String.valueOf(stakeholderPO.getSupNo())) || stakeholderPO.getSupNo().equals(this.snIdFl)) && salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP)) {
            throw new UocProBusinessException("102035", "\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u540e\uff0c\u82cf\u5b81\u4e0d\u5141\u8bb8\u6613\u8d2d\u76f4\u63a5\u53d6\u6d88\uff0c\u8bf7\u8054\u7cfb\u82cf\u5b81\u5ba2\u670d\u5904\u7406");
        }
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(salePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setObjId(salePO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfApplyCancelOrderReqBO reqBO = new PebIntfApplyCancelOrderReqBO();
        reqBO.setOrderId(indexPO.getOutOrderNo());
        reqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(salePO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            reqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfApplyCancelOrderAbilityService.applyCancel(reqBO)).getRespCode())) {
            throw new UocProBusinessException("102035", rspBO.getRespDesc());
        }
    }

    private void save(OrdSalePO salePO, PebExtCancelReqBO reqBO, boolean push, OrdCancelPO cancelPO) {
        cancelPO.setCancelNo(this.biuldNo("", "QXSQ", "ORDER_CANCEL_NO", salePO.getOrderSource()));
        cancelPO.setCancelReason(reqBO.getCancelReason());
        cancelPO.setOrderId(salePO.getOrderId());
        cancelPO.setSaleVoucherId(salePO.getSaleVoucherId());
        cancelPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        cancelPO.setCreateOperName(reqBO.getUsername());
        cancelPO.setCreateTime(new Date());
        cancelPO.setOrderStatus(salePO.getSaleState());
        if (push) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_APPLY);
        } else if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource())) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_AUDIT);
        } else {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_SUCCESS);
        }
        if (UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PRE_ORDER.equals(salePO.getSaleState())) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.UNSHIP_CANCEL);
        }
        this.ordCancelMapper.insert(cancelPO);
    }

    private String biuldNo(String planNo, String pro, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102035", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.biuldNo(planNo, pro);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }

    private void cancelFscShouldPay(PebExtCancelReqBO reqBO) {
        UocOrdFscShouldPayPo ordFscShouldPayPo = new UocOrdFscShouldPayPo();
        ordFscShouldPayPo.setOrderId(reqBO.getOrderId());
        List ordFscShouldPayPos = this.ordFscShouldPayMapper.getList(ordFscShouldPayPo);
        if (ObjectUtil.isNotEmpty((Object)ordFscShouldPayPos)) {
            ArrayList<Long> shouldPayIds = null;
            for (UocOrdFscShouldPayPo fscShouldPayPo : ordFscShouldPayPos) {
                if (null != fscShouldPayPo.getIsPayCompleted() && 1 == fscShouldPayPo.getIsPayCompleted()) {
                    log.info("\u90e8\u5206\u5e94\u4ed8\u8bb0\u5f55\u5df2\u7ecf\u652f\u4ed8\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)fscShouldPayPo));
                    continue;
                }
                if (null != fscShouldPayPo.getPaidFee() && fscShouldPayPo.getPaidFee() > 0L) {
                    log.info("\u90e8\u5206\u5e94\u4ed8\u8bb0\u5f55\u5df2\u7ecf\u90e8\u5206\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)fscShouldPayPo));
                    continue;
                }
                if (null == shouldPayIds) {
                    shouldPayIds = new ArrayList<Long>();
                }
                shouldPayIds.add(fscShouldPayPo.getFscShouldPayId());
            }
            if (ObjectUtil.isNotEmpty(shouldPayIds)) {
                FscShouldPayTerminationAbilityReqBO fscShouldPayTerminationAbilityReqBO = new FscShouldPayTerminationAbilityReqBO();
                fscShouldPayTerminationAbilityReqBO.setShouldPayIds(shouldPayIds);
                FscShouldPayTerminationAbilityRspBO fscShouldPayTerminationAbilityRspBO = this.fscShouldPayTerminationAbilityService.dealShouldPayTermination(fscShouldPayTerminationAbilityReqBO);
                if (!"0000".equals(fscShouldPayTerminationAbilityRspBO.getRespCode())) {
                    throw new UocProBusinessException(fscShouldPayTerminationAbilityRspBO.getRespCode(), fscShouldPayTerminationAbilityRspBO.getRespDesc());
                }
            }
        }
    }

    private void pushTodoWait(PebExtCancelReqBO reqBO, OrdSalePO saleRspBO) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(saleRspBO.getOrderId());
            uocTodoBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
            uocTodoBO.setChangeOrderId(saleRspBO.getChangeOrderId());
            uocTodoBO.setApproveType(ApproveTypeEnum.CANCLE.getCode());
            uocTodoBO.setOperatorId(reqBO.getUserId() + "");
            uocTodoBO.setOperatorNo(reqBO.getUsername());
            uocTodoBO.setOperatorName(reqBO.getName());
            uocTodoBO.setOrgId(reqBO.getOrgId());
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }

    private void build(String key, String name, String val, Long orderId, List<OrdExtMapPO> list, Long saleVoucherId) {
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        extMapPO.setObjId(saleVoucherId);
        extMapPO.setOrderId(orderId);
        list.add(extMapPO);
    }
}

