/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerFailBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerFailBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerFailBusiRspBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.UocContractPushLogPO;
import com.tydic.uoc.po.UocOrdContractPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushContractLedgerFailBusiServiceImpl
implements PebExtPushContractLedgerFailBusiService {
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;

    @Override
    public PebExtPushContractLedgerFailBusiRspBO savePushLedgerFailLog(PebExtPushContractLedgerFailBusiReqBO reqBO) {
        this.valid(reqBO);
        UocOrdContractPO contractPO = new UocOrdContractPO();
        contractPO.setOrderId(reqBO.getOrderId());
        contractPO = this.uocOrdContractMapper.getModelBy(contractPO);
        if (contractPO == null) {
            contractPO = new UocOrdContractPO();
            contractPO.setId(Long.valueOf(this.sequence.nextId()));
            contractPO.setOrderId(reqBO.getOrderId());
            contractPO.setSaleVoucherNo(reqBO.getOrderNo());
            contractPO.setFailReason(reqBO.getFailMsg());
            contractPO.setCreateTime(new Date());
            contractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            this.uocOrdContractMapper.insert(contractPO);
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO.setFieldName19("\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355id");
            cruxMapPO.setFieldValue19(reqBO.getOrderId().toString());
            this.ordCruxMapMapper.updateByOrder(cruxMapPO);
        } else {
            UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setOrderId(reqBO.getOrderId());
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            uocOrdContractPO.setFailReason(reqBO.getFailMsg());
            this.uocOrdContractMapper.updateByOrderId(uocOrdContractPO);
            uocOrdContractPO.setSaleVoucherNo(null);
            uocOrdContractPO.setExt2(reqBO.getOrderId().toString());
            this.uocOrdContractMapper.updateByUpperOrderId(uocOrdContractPO);
        }
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        this.uocContractPushLogMapper.insert(pushLogPO);
        PebExtPushContractLedgerFailBusiRspBO rspBO = new PebExtPushContractLedgerFailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebExtPushContractLedgerFailBusiRspBO savePushOrderFailLog(PebExtPushContractLedgerFailBusiReqBO reqBO) {
        this.valid(reqBO);
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        this.uocContractPushLogMapper.insert(pushLogPO);
        PebExtPushContractLedgerFailBusiRspBO rspBO = new PebExtPushContractLedgerFailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocContractPushLogPO buildPushLog(PebExtPushContractLedgerFailBusiReqBO reqBO) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setObjectId(reqBO.getOrderId());
        pushLogPO.setObjectNo(reqBO.getOrderNo());
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setType(reqBO.getPushType());
        pushLogPO.setPushData(reqBO.getFailMsg());
        return pushLogPO;
    }

    private void valid(PebExtPushContractLedgerFailBusiReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

