/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseShipStatusAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipStatusAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipStatusAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseShipStatusBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipStatusBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseShipStatusBusiRspBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushWarehouseShipStatusBusiServiceImpl
implements PebExtPushWarehouseShipStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseShipStatusBusiServiceImpl.class);
    @Autowired
    private PebExtPushWarehouseShipStatusAtomService pebExtPushWarehouseShipStatusAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @Override
    public PebExtPushWarehouseShipStatusBusiRspBO dealPushWarehouseShipStatus(PebExtPushWarehouseShipStatusBusiReqBO reqBO) {
        PebExtPushWarehouseShipStatusBusiRspBO rspBO = new PebExtPushWarehouseShipStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getShipVoucherId());
        if (reqBO.getSubmitStatus() == 1) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_IN);
        } else if (reqBO.getSubmitStatus() == 2) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_OUT);
        } else if (reqBO.getSubmitStatus() == 3) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_ARRIVE);
        } else if (reqBO.getSubmitStatus() == 4) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_ARRIVE_TWO);
        }
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLogPO = this.uocOrdWarehouseLogMapper.getModelBy(pushLogPO);
        if (pushLogPO != null) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        this.dealPush(reqBO, rspBO);
        return rspBO;
    }

    private void dealPush(PebExtPushWarehouseShipStatusBusiReqBO reqBO, PebExtPushWarehouseShipStatusBusiRspBO rspBO) {
        UocOrdWarehouseLogPO pushLogPO = this.buildPushLog(reqBO, reqBO.getReqData());
        PebExtPushWarehouseShipStatusAtomReqBO atomReqBO = new PebExtPushWarehouseShipStatusAtomReqBO();
        atomReqBO.setData(reqBO.getReqData());
        atomReqBO.setSupplierId(reqBO.getSupplierId());
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        atomReqBO.setSubmitStatus(reqBO.getSubmitStatus());
        PebExtPushWarehouseShipStatusAtomRspBO atomRspBO = this.pebExtPushWarehouseShipStatusAtomService.pushWarehouseShipStatus(atomReqBO);
        OrdShipPO ordShipStatusPO = new OrdShipPO();
        ordShipStatusPO.setOrderId(reqBO.getOrderId());
        ordShipStatusPO.setShipVoucherId(reqBO.getShipVoucherId());
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            if (reqBO.getSubmitStatus() == 1) {
                ordShipStatusPO.setPushInStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            } else if (reqBO.getSubmitStatus() == 2) {
                ordShipStatusPO.setPushOutStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            } else if (reqBO.getSubmitStatus() == 3) {
                ordShipStatusPO.setPushArriveStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            } else if (reqBO.getSubmitStatus() == 4) {
                ordShipStatusPO.setPushArriveTwoStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            }
        } else {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            if (reqBO.getSubmitStatus() == 1) {
                ordShipStatusPO.setPushInStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            } else if (reqBO.getSubmitStatus() == 2) {
                ordShipStatusPO.setPushOutStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            } else if (reqBO.getSubmitStatus() == 3) {
                ordShipStatusPO.setPushArriveStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            } else if (reqBO.getSubmitStatus() == 4) {
                ordShipStatusPO.setPushArriveTwoStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            }
        }
        this.ordShipMapper.updateById(ordShipStatusPO);
        pushLogPO.setRespData(atomRspBO.getRspData());
        this.uocOrdWarehouseLogMapper.insert(pushLogPO);
    }

    private UocOrdWarehouseLogPO buildPushLog(PebExtPushWarehouseShipStatusBusiReqBO reqBO, String reqData) {
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getShipVoucherId());
        pushLogPO.setReqData(JSONObject.toJSONString((Object)reqData));
        pushLogPO.setCreateTime(new Date());
        if (reqBO.getSubmitStatus() == 1) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_IN);
        } else if (reqBO.getSubmitStatus() == 2) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_OUT);
        } else if (reqBO.getSubmitStatus() == 3) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_ARRIVE);
        } else if (reqBO.getSubmitStatus() == 4) {
            pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_SHIP_ARRIVE_TWO);
        }
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        pushLogPO.setReqData(reqData);
        return pushLogPO;
    }
}

