/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.common.ability.bo.ExperssDeliveryBO;
import com.tydic.uoc.common.ability.bo.UocExperssDeliveryInsertAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocExperssDeliveryInsertAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocExperssDeliveryBusiService;
import com.tydic.uoc.common.busi.bo.UocExperssDeliveryBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocExperssDeliveryBusiRspBO;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocExpressDeliveryInfoMapper;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocExpressDeliveryInfoPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocExperssDeliveryBusiServiceImpl
implements UocExperssDeliveryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocExperssDeliveryBusiServiceImpl.class);
    @Autowired
    private UocExpressDeliveryInfoMapper uocExpressDeliveryInfoMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Value(value="${EXPRESS_DELIVERY_URL:https://poll.kuaidi100.com/poll/maptrack.do}")
    private String expressDeliveryUrl;
    @Value(value="${POLL_MAP_URL:http://poll.kuaidi100.com/pollmap}")
    private String pollMapUrl;
    @Value(value="${EXPERSS_CALL_BACK_URL:https://ego.chinacoal.com/dyc/busicommon/order/noauth/shipCall}")
    private String callbackUrl;
    @Value(value="${KUAIDI_100_CUSTOMER:A85A5CAED35950F60948FC52BE1F678E}")
    private String customer;
    @Value(value="${KUAIDI_100_KEY:DQkMzooN6154}")
    private String key;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;

    @Override
    public UocExperssDeliveryBusiRspBO dealExpressDelivery(UocExperssDeliveryBusiReqBO reqBO) {
        UocExperssDeliveryBusiRspBO rspBO = new UocExperssDeliveryBusiRspBO();
        rspBO.setOrderId(reqBO.getOrderId());
        rspBO.setShipVoucherId(reqBO.getShipVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<UocExpressDeliveryInfoPo> pos = this.uocExpressDeliveryInfoMapper.selectList(reqBO.getShipVoucherId());
        if (CollectionUtils.isEmpty((Collection)pos) && CollectionUtils.isEmpty(pos = this.qryExpressInfo(rspBO, reqBO))) {
            return rspBO;
        }
        return this.parseData(rspBO, pos);
    }

    @Override
    public UocExperssDeliveryInsertAbilityRspBO dealInsertInfo(UocExperssDeliveryInsertAbilityReqBO reqBO) {
        UocExperssDeliveryInsertAbilityRspBO rspBO = new UocExperssDeliveryInsertAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONObject param = reqBO.getParam();
        if (param.getJSONArray("data") != null && param.getJSONArray("data").size() > 0) {
            String nu = param.getString("nu");
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setShipId(nu);
            List shipList = this.ordShipMapper.getList(shipPO);
            if (CollectionUtils.isEmpty((Collection)shipList)) {
                throw new UocProBusinessException("8888", "\u5feb\u9012100\u53d1\u8d27\u5355\u53f7\u4e0d\u5b58\u5728\uff01\uff01\uff01,\u914d\u9001\u5355\u53f7:" + nu);
            }
            UocExpressDeliveryInfoPo infoPo = new UocExpressDeliveryInfoPo();
            infoPo.setShipVoucherIdList(shipList.stream().map(x -> x.getShipVoucherId()).collect(Collectors.toList()));
            this.uocExpressDeliveryInfoMapper.deleteList(infoPo);
            List deliveryInfoPos = JSONObject.parseArray((String)param.getString("data"), UocExpressDeliveryInfoPo.class);
            ArrayList<UocExpressDeliveryInfoPo> posList = new ArrayList<UocExpressDeliveryInfoPo>();
            Date date = new Date();
            for (OrdShipPO ship : shipList) {
                for (UocExpressDeliveryInfoPo x2 : deliveryInfoPos) {
                    UocExpressDeliveryInfoPo po = new UocExpressDeliveryInfoPo();
                    BeanUtils.copyProperties((Object)x2, (Object)po);
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setTrailUrl(param.getString("trailUrl"));
                    po.setArrivalTime(param.getString("arrivalTime"));
                    po.setRemainTime(param.getString("remainTime"));
                    po.setTotalTime(param.getString("totalTime"));
                    po.setIscheck(param.getString("ischeck"));
                    po.setNum(param.getString("nu"));
                    po.setOrderId(ship.getOrderId());
                    po.setShipVoucherId(ship.getShipVoucherId());
                    po.setCreateTime(date);
                    posList.add(po);
                }
            }
            this.uocExpressDeliveryInfoMapper.insertBatch(posList);
            rspBO.setIscheck(param.getString("ischeck"));
            rspBO.setOrderId(((OrdShipPO)shipList.get(0)).getOrderId());
            rspBO.setSaleVoucherId(((OrdShipPO)shipList.get(0)).getSaleVoucherId());
            rspBO.setShipVoucherId(((OrdShipPO)shipList.get(0)).getShipVoucherId());
        }
        return rspBO;
    }

    private List<UocExpressDeliveryInfoPo> qryExpressInfo(UocExperssDeliveryBusiRspBO rspBO, UocExperssDeliveryBusiReqBO reqBO) {
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
        List relaPOS = this.ordLogisticsRelaMapper.getList(ordLogisticsRelaPO);
        if (!CollectionUtils.isEmpty((Collection)relaPOS) && ((OrdLogisticsRelaPO)relaPOS.get(0)).getContactMobile() != null) {
            reqBO.setPhone(((OrdLogisticsRelaPO)relaPOS.get(0)).getContactMobile());
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("customer", this.customer);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("com", (Object)reqBO.getCom());
        jsonObject.put("num", (Object)reqBO.getNum());
        jsonObject.put("phone", (Object)reqBO.getPhone());
        jsonObject.put("from", (Object)reqBO.getFrom());
        jsonObject.put("to", (Object)reqBO.getTo());
        jsonObject.put("resultv2", (Object)"5");
        jsonObject.put("mapConfigKey", (Object)"");
        jsonObject.put("show", (Object)"0");
        jsonObject.put("order", (Object)"desc");
        paramMap.put("sign", this.genDigest(jsonObject.toJSONString(), this.key, this.customer));
        paramMap.put("param", jsonObject.toJSONString());
        log.info("\u5feb\u9012100\u67e5\u8be2\u5730\u56fe\u8f68\u8ff9\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
        String respStr = SSLClient.doPost((String)this.expressDeliveryUrl, paramMap, null);
        log.info("\u5feb\u9012100\u67e5\u8be2\u5730\u56fe\u8f68\u8ff9\u51fa\u53c2\uff1a" + respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u5feb\u9012100\u67e5\u8be2\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\uff01");
        }
        JSONObject parseObject = JSONObject.parseObject((String)respStr);
        if (parseObject.containsKey((Object)"returnCode") && "500".equals(parseObject.getString("returnCode"))) {
            rspBO.setRespDesc(parseObject.getString("message"));
            return new ArrayList<UocExpressDeliveryInfoPo>();
        }
        if (!"200".equals(parseObject.getString("status"))) {
            throw new UocProBusinessException("8888", "\u5feb\u9012100\u67e5\u8be2\u5730\u56fe\u8f68\u8ff9\u5931\u8d25\uff1a" + parseObject.getString("message"));
        }
        String data = parseObject.getString("data");
        Date date = new Date();
        List deliveryInfoPos = JSONArray.parseArray((String)data, UocExpressDeliveryInfoPo.class);
        deliveryInfoPos.forEach(x -> {
            x.setId(Long.valueOf(Sequence.getInstance().nextId()));
            x.setTrailUrl(parseObject.getString("trailUrl"));
            x.setArrivalTime(parseObject.getString("arrivalTime"));
            x.setTotalTime(parseObject.getString("totalTime"));
            x.setRemainTime(parseObject.getString("remainTime"));
            x.setIscheck(parseObject.getString("ischeck"));
            x.setNum(parseObject.getString("nu"));
            x.setCreateTime(date);
            x.setOrderId(reqBO.getOrderId());
            x.setShipVoucherId(reqBO.getShipVoucherId());
        });
        this.uocExpressDeliveryInfoMapper.insertBatch(deliveryInfoPos);
        if ("0".equals(parseObject.getString("ischeck"))) {
            this.subscribeMap(reqBO);
        }
        return deliveryInfoPos;
    }

    private void subscribeMap(UocExperssDeliveryBusiReqBO reqBO) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put("schema", "json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)this.key);
            jsonObject.put("company", (Object)reqBO.getCom());
            jsonObject.put("number", (Object)reqBO.getNum());
            jsonObject.put("from", (Object)reqBO.getFrom());
            jsonObject.put("to", (Object)reqBO.getTo());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("callbackurl", this.callbackUrl);
            parameters.put("resultv2", "5");
            parameters.put("phone", reqBO.getPhone());
            jsonObject.put("parameters", parameters);
            paramMap.put("param", jsonObject.toJSONString());
            log.info("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            String respStr = SSLClient.doPost((String)this.pollMapUrl, paramMap, null);
            log.info("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u51fa\u53c2\uff1a" + respStr);
            if (StringUtils.isEmpty((Object)respStr)) {
                throw new UocProBusinessException("8888", "\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\uff01");
            }
            JSONObject parseObject = JSONObject.parseObject((String)respStr);
            if (!"200".equals(parseObject.getString("returnCode"))) {
                throw new UocProBusinessException("8888", "\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5931\u8d25\uff1a" + parseObject.getString("message"));
            }
        }
        catch (UocProBusinessException e) {
            log.error("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5931\u8d25\uff1a" + e.getMessage() + "\uff0c\u53d1\u8d27\u5355id\uff1a" + reqBO.getShipVoucherId() + "\uff0c\u5165\u53c2" + JSONObject.toJSONString(paramMap));
        }
    }

    private UocExperssDeliveryBusiRspBO parseData(UocExperssDeliveryBusiRspBO rspBO, List<UocExpressDeliveryInfoPo> pos) {
        UocExpressDeliveryInfoPo deliveryInfoPo = pos.get(0);
        rspBO.setIscheck(deliveryInfoPo.getIscheck());
        rspBO.setArrivalTime(deliveryInfoPo.getArrivalTime());
        rspBO.setRemainTime(deliveryInfoPo.getRemainTime());
        rspBO.setTrailUrl(deliveryInfoPo.getTrailUrl());
        rspBO.setTotalTime(deliveryInfoPo.getTotalTime());
        rspBO.setBos(JSON.parseArray((String)JSON.toJSONString(pos), ExperssDeliveryBO.class));
        return rspBO;
    }

    private String genDigest(String param, String key, String customer) {
        return DigestUtils.md5Hex((String)(param + key + customer)).toUpperCase();
    }
}

