/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractPayBO;
import com.tydic.uoc.common.busi.api.UocFinanceContractCreateOfflineLineBusiService;
import com.tydic.uoc.common.busi.bo.UocFinanceContractCreateOfflineLineBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocFinanceContractCreateOfflineLineBusiRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocContractPayConfMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocContractPayConfPO;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocFinanceContractCreateOfflineLineBusiServiceImpl
implements UocFinanceContractCreateOfflineLineBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private UocContractPayConfMapper uocContractPayConfMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public UocFinanceContractCreateOfflineLineBusiRspBO dealContractOfflineLine(UocFinanceContractCreateOfflineLineBusiReqBO reqBO) {
        UocOfflineContractPO offlineContractPO = new UocOfflineContractPO();
        offlineContractPO.setContractId(reqBO.getContractId());
        offlineContractPO = this.uocOfflineContractMapper.getModelBy(offlineContractPO);
        if (offlineContractPO != null) {
            if (!reqBO.getContractNo().equals(offlineContractPO.getContractNo())) {
                throw new UocProBusinessException("8888", reqBO.getContractNo() + "\u5b58\u5728\u5408\u540cid\u4e0e\u7ebf\u4e0b\u5408\u540cid\u51b2\u7a81!" + offlineContractPO.getContractNo());
            }
            int count = this.uocOfflineContractMapper.deleteByContractId(reqBO.getContractId());
            if (count != 1) {
                throw new UocProBusinessException("8888", "\u5220\u9664\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.uocContractPayConfMapper.deleteByContractId(reqBO.getContractId());
            if (count < 0) {
                throw new UocProBusinessException("8888", "\u5220\u9664\u7ebf\u4e0b\u5408\u540c\u4ed8\u6b3e\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
            accessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.CONTRACT);
            accessoryPO.setObjectId(reqBO.getContractId());
            accessoryPO.setOrderId(reqBO.getContractId());
            accessoryPO.setObjectType(Integer.valueOf(101));
            count = this.ordAccessoryMapper.deleteBy(accessoryPO);
            if (count < 0) {
                throw new UocProBusinessException("8888", "\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.createContractOffline(reqBO, offlineContractPO);
        } else {
            this.createContractOffline(reqBO, offlineContractPO);
        }
        UocFinanceContractCreateOfflineLineBusiRspBO rspBO = new UocFinanceContractCreateOfflineLineBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void createContractOffline(UocFinanceContractCreateOfflineLineBusiReqBO reqBO, UocOfflineContractPO offlineContractPO) {
        UocOfflineContractPO contractPO = new UocOfflineContractPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)contractPO);
        contractPO.setUpdateTime(new Date());
        if (offlineContractPO != null) {
            contractPO.setCreateTime(offlineContractPO.getCreateTime());
            contractPO.setCreateUserId(offlineContractPO.getCreateUserId());
            contractPO.setCreateUserName(offlineContractPO.getCreateUserName());
        } else {
            contractPO.setCreateTime(new Date());
        }
        contractPO.setUpdateUserId(reqBO.getUpdateUserId());
        contractPO.setUpdateUserName(reqBO.getUpdateUserName());
        contractPO.setExt3("2");
        contractPO.setExt2(reqBO.getContractId() + "");
        contractPO.setExt1("2");
        contractPO.setContractStatus(UocConstant.OfflineContractStatus.TOOK_EFFECT);
        contractPO.setOrderType(Integer.valueOf(10));
        int count = this.uocOfflineContractMapper.insert(contractPO);
        if (count != 1) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayList())) {
            ArrayList<UocContractPayConfPO> payConfPoList = new ArrayList<UocContractPayConfPO>(reqBO.getPayList().size());
            for (UocExtensionOfflineContractPayBO contractPayBO : reqBO.getPayList()) {
                UocContractPayConfPO payConfPO = new UocContractPayConfPO();
                BeanUtils.copyProperties((Object)contractPayBO, (Object)payConfPO);
                payConfPO.setId(Long.valueOf(this.sequence.nextId()));
                payConfPO.setContractId(contractPO.getContractId());
                payConfPO.setCreateTime(new Date());
                payConfPO.setUpdateTime(new Date());
                payConfPoList.add(payConfPO);
            }
            count = this.uocContractPayConfMapper.insertBatch(payConfPoList);
            if (count < 0) {
                throw new UocProBusinessException("8888", "\u63d2\u5165\u5408\u540c\u4ed8\u6b3e\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<OrdAccessoryPO> fileList = new ArrayList<OrdAccessoryPO>(reqBO.getFileList().size());
            for (AccessoryBO accessoryBO : reqBO.getFileList()) {
                OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
                BeanUtils.copyProperties((Object)accessoryBO, (Object)ordAccessoryPO);
                ordAccessoryPO.setId(Long.valueOf(this.sequence.nextId()));
                ordAccessoryPO.setObjectId(reqBO.getContractId());
                ordAccessoryPO.setOrderId(reqBO.getContractId());
                ordAccessoryPO.setAccessoryId(ordAccessoryPO.getId());
                ordAccessoryPO.setObjectType(Integer.valueOf(101));
                ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.CONTRACT);
                fileList.add(ordAccessoryPO);
            }
            count = this.ordAccessoryMapper.insertBatch(fileList);
            if (count < 0) {
                throw new UocProBusinessException("8888", "\u5b58\u50a8\u7ebf\u4e0b\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }
}

