/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ard.security.utils.StringUtils;
import com.tydic.commodity.base.utils.BeanUtils;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.finance.UocFinanceOrderCreateOfflineContractAbilityService;
import com.tydic.uoc.common.ability.bo.UocFinanceSettlePlatformSyncBO;
import com.tydic.uoc.common.ability.bo.finance.UocFinanceOrderCreateOfflineContractReqBO;
import com.tydic.uoc.common.ability.bo.finance.UocFinanceOrderCreateOfflineContractRspBO;
import com.tydic.uoc.common.ability.bo.finance.UocFinanceSettlePlatformContractBO;
import com.tydic.uoc.common.busi.api.UocFinanceSettlePlatformChangeBusiService;
import com.tydic.uoc.common.busi.bo.UocFinanceSettlePlatformChangeBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocFinanceSettlePlatformChangeBusiRspBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOfflineContractPO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocFinanceSettlePlatformChangeBusiServiceImpl
implements UocFinanceSettlePlatformChangeBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocFinanceOrderCreateOfflineContractAbilityService uocFinanceOrderCreateOfflineContractAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long OPERATION_SUP_ID;

    @Override
    public UocFinanceSettlePlatformChangeBusiRspBO dealSettlePlatformChange(UocFinanceSettlePlatformChangeBusiReqBO reqBO) {
        UocFinanceSettlePlatformChangeBusiRspBO rspBO = new UocFinanceSettlePlatformChangeBusiRspBO();
        rspBO.setOrderList(new ArrayList<UocFinanceSettlePlatformContractBO>());
        List salePOList = this.ordSaleMapper.getListByOrderIds(reqBO.getObjIds());
        if (reqBO.getObjIds().size() != salePOList.size()) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        Map<Long, OrdSalePO> saleMap = salePOList.stream().collect(Collectors.toMap(OrdSalePO::getOrderId, Function.identity(), (k1, k2) -> k1));
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setOrderIds(reqBO.getObjIds());
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        List cruxMapPOList = this.ordCruxMapMapper.getList(cruxMapPO);
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> financeOrderIds = new ArrayList<Long>();
        for (OrdCruxMapPO ordCruxMapPO : cruxMapPOList) {
            if (!StringUtils.isEmpty((String)ordCruxMapPO.getFieldValue10()) && FscConstants.SettlePlatform.FINANCE.toString().equals(ordCruxMapPO.getFieldValue10())) {
                financeOrderIds.add(ordCruxMapPO.getOrderId());
                continue;
            }
            orderIds.add(ordCruxMapPO.getOrderId());
        }
        if (CollectionUtils.isEmpty(orderIds)) {
            return this.qryOrderContractInfo(reqBO, reqBO.getObjIds(), saleMap);
        }
        UocOrdContractPO contractQueryPO = new UocOrdContractPO();
        contractQueryPO.setOrderIdList(orderIds);
        List contractPOList = this.uocOrdContractMapper.getList(contractQueryPO);
        ArrayList<Long> hadContractOrderIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)contractPOList)) {
            for (UocOrdContractPO uocOrdContractPO : contractPOList) {
                orderIds.remove(uocOrdContractPO.getOrderId());
                hadContractOrderIds.add(uocOrdContractPO.getOrderId());
            }
        }
        if (!CollectionUtils.isEmpty(orderIds)) {
            if (reqBO.getObjType() == 2) {
                this.dealSettleOrderContract(orderIds, saleMap, rspBO, financeOrderIds);
            } else {
                this.dealOrderContract(orderIds, saleMap, rspBO, financeOrderIds);
            }
        }
        this.qryOrderContractInfo(reqBO, reqBO.getObjIds(), saleMap);
        orderIds.addAll(hadContractOrderIds);
        if (!CollectionUtils.isEmpty(orderIds)) {
            this.buildRspSyncInfo(orderIds, saleMap, rspBO);
        }
        OrdCruxMapPO updateCruxMap = new OrdCruxMapPO();
        updateCruxMap.setOrderIds(orderIds);
        updateCruxMap.setFieldValue10(FscConstants.SettlePlatform.FINANCE.toString());
        updateCruxMap.setFieldValue11("\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab");
        this.ordCruxMapMapper.updateValue10ByOrderIds(updateCruxMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("0000");
        return rspBO;
    }

    private UocFinanceSettlePlatformChangeBusiRspBO qryOrderContractInfo(UocFinanceSettlePlatformChangeBusiReqBO reqBO, List<Long> orderIds, Map<Long, OrdSalePO> saleMap) {
        if (reqBO.getObjType() != 2) {
            return new UocFinanceSettlePlatformChangeBusiRspBO();
        }
        UocFinanceSettlePlatformChangeBusiRspBO rspBO = new UocFinanceSettlePlatformChangeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<UocFinanceSettlePlatformContractBO> orderList = new ArrayList<UocFinanceSettlePlatformContractBO>();
        if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(saleMap.get(orderIds.get(0)).getOrderSource())) {
            List agreementPOList = this.ordAgreementMapper.getListByOrderIds(orderIds);
            for (OrdAgreementPO agreementPO : agreementPOList) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                contractBO.setOrderId(agreementPO.getOrderId());
                contractBO.setSaleVoucherNo(saleMap.get(agreementPO.getOrderId()).getSaleVoucherNo());
                contractBO.setContractName(agreementPO.getAgreementName());
                contractBO.setContractNo(agreementPO.getPlaAgreementCode());
                contractBO.setContractId(Long.valueOf(agreementPO.getAgreementId()));
                contractBO.setContractType("2");
                orderList.add(contractBO);
            }
        } else {
            UocOrdContractPO contractQueryPO = new UocOrdContractPO();
            contractQueryPO.setOrderIdList(reqBO.getObjIds());
            List ordContractPOS = this.uocOrdContractMapper.getList(contractQueryPO);
            for (UocOrdContractPO ordContractPO : ordContractPOS) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                BeanUtils.copyProperties((Object)ordContractPO, (Object)contractBO);
                contractBO.setContractType("3");
                orderList.add(contractBO);
            }
        }
        rspBO.setOrderList(orderList);
        return rspBO;
    }

    private void dealOrderContract(List<Long> orderIds, Map<Long, OrdSalePO> saleMap, UocFinanceSettlePlatformChangeBusiRspBO rspBO, List<Long> financeOrderIds) {
        int count;
        ArrayList<UocOrdContractPO> ordContractPOList = new ArrayList<UocOrdContractPO>();
        List zmInfoPOList = this.uocOrdZmInfoMapper.getListByOrderIds(orderIds);
        this.checkOrgSettlePlatform(zmInfoPOList, saleMap);
        Map zmInfoMap = zmInfoPOList.stream().collect(Collectors.toMap(UocOrdZmInfoPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        ArrayList<UocFinanceSettlePlatformContractBO> orderList = new ArrayList<UocFinanceSettlePlatformContractBO>();
        for (Long orderId : orderIds) {
            OrdSalePO salePO = saleMap.get(orderId);
            if (PebExtConstant.OrderType.GC.equals(salePO.getOrderType())) continue;
            if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource())) {
                orderIds.addAll(financeOrderIds);
                List agreementPOList = this.ordAgreementMapper.getListByOrderIds(orderIds);
                for (OrdAgreementPO agreementPO : agreementPOList) {
                    UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                    contractBO.setOrderId(agreementPO.getOrderId());
                    contractBO.setSaleVoucherNo(saleMap.get(agreementPO.getOrderId()).getSaleVoucherNo());
                    contractBO.setContractName(agreementPO.getAgreementName());
                    contractBO.setContractNo(agreementPO.getPlaAgreementCode());
                    contractBO.setContractId(Long.valueOf(agreementPO.getAgreementId()));
                    contractBO.setContractType("2");
                    orderList.add(contractBO);
                }
                rspBO.setOrderList(orderList);
                continue;
            }
            if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(salePO.getOrderSource()) && PebExtConstant.Modelsettle.CH.equals(salePO.getModelSettle()) || PebExtConstant.OrderType.FL.equals(salePO.getOrderType()) && PebExtConstant.Modelsettle.CH.equals(salePO.getModelSettle())) {
                this.createOffLineContract(salePO);
                financeOrderIds.add(salePO.getOrderId());
                continue;
            }
            UocOfflineContractPO uocOfflineContractPO = this.qryContractInfo(salePO, (UocOrdZmInfoPO)zmInfoMap.get(orderId));
            ordContractPOList.add(this.buildContractPO(uocOfflineContractPO, salePO));
        }
        if (!CollectionUtils.isEmpty(ordContractPOList) && (count = this.uocOrdContractMapper.insertBatch(ordContractPOList)) != ordContractPOList.size()) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u8ba2\u5355\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        for (UocOrdContractPO ordContractPO : ordContractPOList) {
            UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
            BeanUtils.copyProperties((Object)ordContractPO, (Object)contractBO);
            contractBO.setContractType("3");
            orderList.add(contractBO);
        }
        if (!CollectionUtils.isEmpty(financeOrderIds)) {
            UocOrdContractPO contractQueryPO = new UocOrdContractPO();
            contractQueryPO.setOrderIdList(financeOrderIds);
            List ordContractPOS = this.uocOrdContractMapper.getList(contractQueryPO);
            for (UocOrdContractPO ordContractPO : ordContractPOS) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                BeanUtils.copyProperties((Object)ordContractPO, (Object)contractBO);
                contractBO.setContractType("3");
                orderList.add(contractBO);
            }
        }
        rspBO.setOrderList(orderList);
    }

    private void checkOrgSettlePlatform(List<UocOrdZmInfoPO> zmInfoPOList, Map<Long, OrdSalePO> saleMap) {
        List buynerNos = zmInfoPOList.stream().map(UocOrdZmInfoPO::getBuynerNo).distinct().collect(Collectors.toList());
        if (StringUtils.isEmpty((String)zmInfoPOList.get(0).getBuynerNo())) {
            buynerNos = new ArrayList();
            for (Long orderId : saleMap.keySet()) {
                if (PebExtConstant.OrderType.GC.equals(saleMap.get(orderId).getOrderType())) {
                    throw new UocProBusinessException("8888", "\u5458\u5de5\u4e2a\u91c7\u4e0d\u80fd\u8f6c\u5171\u4eab\u6a21\u5f0f\uff01");
                }
                buynerNos.add(saleMap.get(orderId).getFlOrgCode());
                if (!StringUtils.isEmpty((String)saleMap.get(orderId).getFlOrgCode())) continue;
                throw new UocProBusinessException("8888", saleMap.get(orderId).getSaleVoucherNo() + "\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8865\u5145\u798f\u70b9\u5355\u4f4d\u4fe1\u606f\uff01");
            }
        }
        for (String buynerNo : buynerNos) {
            UmcEnterpriseOrgQryDetailAbilityReqBO orgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setOrgCode(buynerNo);
            UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            if (!"0000".equals(orgQryDetailAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", buynerNo + "\u67e5\u8be2\u7ed3\u6784\u4fe1\u606f\u5931\u8d25" + orgQryDetailAbilityRspBO.getRespDesc());
            }
            if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new UocProBusinessException("8888", buynerNo + "\u67e5\u8be2\u7ed3\u6784\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() != null && FscConstants.SettlePlatform.FINANCE.equals(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn())) continue;
            throw new UocProBusinessException("8888", "\u5f53\u524d\u5355\u4f4d\u672a\u542f\u7528\u5bf9\u63a5\u5171\u4eab\u914d\u7f6e\uff01");
        }
    }

    private void dealSettleOrderContract(List<Long> orderIds, Map<Long, OrdSalePO> saleMap, UocFinanceSettlePlatformChangeBusiRspBO rspBO, List<Long> financeOrderIds) {
        Long orderId = orderIds.get(0);
        if (orderId == null) {
            return;
        }
        OrdSalePO salePO = saleMap.get(orderId);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(orderId);
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (zmInfoPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4e70\u53d7\u4eba\u4fe1\u606f\uff01");
        }
        if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource())) {
            orderIds.addAll(financeOrderIds);
            List agreementPOList = this.ordAgreementMapper.getListByOrderIds(orderIds);
            ArrayList<UocFinanceSettlePlatformContractBO> orderList = new ArrayList<UocFinanceSettlePlatformContractBO>(agreementPOList.size());
            for (OrdAgreementPO ordAgreementPO : agreementPOList) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                contractBO.setOrderId(ordAgreementPO.getOrderId());
                contractBO.setSaleVoucherNo(saleMap.get(ordAgreementPO.getOrderId()).getSaleVoucherNo());
                contractBO.setContractName(ordAgreementPO.getAgreementName());
                contractBO.setContractNo(ordAgreementPO.getPlaAgreementCode());
                contractBO.setContractId(Long.valueOf(ordAgreementPO.getAgreementId()));
                contractBO.setContractType("2");
                orderList.add(contractBO);
            }
            rspBO.setOrderList(orderList);
            return;
        }
        ArrayList<UocOrdContractPO> ordContractPOList = new ArrayList<UocOrdContractPO>();
        if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(salePO.getOrderSource()) && PebExtConstant.Modelsettle.CH.equals(salePO.getModelSettle()) && !PebExtConstant.OrderType.FL.equals(salePO.getOrderType()) && !PebExtConstant.OrderType.GC.equals(salePO.getOrderType())) {
            for (Long l : orderIds) {
                this.createOffLineContract(saleMap.get(l));
                financeOrderIds.add(l);
            }
        } else {
            UocOfflineContractPO uocOfflineContractPO = this.qryContractInfo(salePO, zmInfoPO);
            for (Long l : orderIds) {
                ordContractPOList.add(this.buildContractPO(uocOfflineContractPO, saleMap.get(l)));
            }
        }
        ArrayList orderList = new ArrayList(ordContractPOList.size());
        if (!CollectionUtils.isEmpty(ordContractPOList)) {
            int n = this.uocOrdContractMapper.insertBatch(ordContractPOList);
            if (n != ordContractPOList.size()) {
                throw new UocProBusinessException("8888", "\u63d2\u5165\u8ba2\u5355\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            for (UocOrdContractPO ordContractPO : ordContractPOList) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                BeanUtils.copyProperties((Object)ordContractPO, (Object)contractBO);
                contractBO.setContractType("3");
                orderList.add(contractBO);
            }
        }
        if (!CollectionUtils.isEmpty(financeOrderIds)) {
            UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setOrderIdList(financeOrderIds);
            List list = this.uocOrdContractMapper.getList(uocOrdContractPO);
            for (UocOrdContractPO ordContractPO : list) {
                UocFinanceSettlePlatformContractBO contractBO = new UocFinanceSettlePlatformContractBO();
                BeanUtils.copyProperties((Object)ordContractPO, (Object)contractBO);
                contractBO.setContractType("3");
                orderList.add(contractBO);
            }
        }
        rspBO.setOrderList(orderList);
    }

    private UocOfflineContractPO qryContractInfo(OrdSalePO salePO, UocOrdZmInfoPO zmInfoPO) {
        UocOfflineContractPO offLinePO = new UocOfflineContractPO();
        offLinePO.setBuynerNo(zmInfoPO.getBuynerNo());
        offLinePO.setSupplierId(this.OPERATION_SUP_ID);
        if (PebExtConstant.OrderType.GC.equals(salePO.getOrderType())) {
            throw new UocProBusinessException("8888", "\u5458\u5de5\u4e2a\u91c7\u4e0d\u80fd\u8f6c\u5171\u4eab\u6a21\u5f0f\uff01");
        }
        if (PebExtConstant.OrderType.FL.equals(salePO.getOrderType())) {
            offLinePO.setOrderType(Integer.valueOf(4));
            if (!StringUtils.isEmpty((String)salePO.getFlOrgCode())) {
                offLinePO.setBuynerNo(salePO.getFlOrgCode());
            }
            if (PebExtConstant.Modelsettle.CH.equals(salePO.getModelSettle())) {
                try {
                    offLinePO.setSupplierId(salePO.getSupNo());
                }
                catch (Exception e) {
                    throw new UocProBusinessException("8888", salePO.getSaleVoucherNo() + "\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38,\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff01" + zmInfoPO.getSupplier());
                }
            }
        } else if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(salePO.getOrderSource()) && PebExtConstant.Modelsettle.MY.equals(salePO.getModelSettle())) {
            offLinePO.setOrderType(Integer.valueOf(5));
        } else if (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(salePO.getOrderSource()) && PebExtConstant.Modelsettle.MY.equals(salePO.getModelSettle())) {
            offLinePO.setOrderType(Integer.valueOf(0));
        } else {
            throw new UocProBusinessException("8888", salePO.getOrderId() + "\u672a\u77e5\u8ba2\u5355\u7c7b\u578b\uff01");
        }
        offLinePO.setExt3("2");
        List offLineList = this.uocOfflineContractMapper.getEffectModel(offLinePO);
        if (CollectionUtils.isEmpty((Collection)offLineList)) {
            throw new UocProBusinessException("103030", "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ebf\u4e0b\u5408\u540c\u914d\u7f6e!");
        }
        if (offLineList.size() > 1) {
            throw new UocProBusinessException("103030", "\u7ebf\u4e0b\u5408\u540c\u914d\u7f6e\u9519\u8bef!");
        }
        return (UocOfflineContractPO)offLineList.get(0);
    }

    private void createOffLineContract(OrdSalePO salePO) {
        UocFinanceOrderCreateOfflineContractReqBO createOfflineContractReqBO = new UocFinanceOrderCreateOfflineContractReqBO();
        createOfflineContractReqBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        createOfflineContractReqBO.setOrderId(salePO.getOrderId());
        UocFinanceOrderCreateOfflineContractRspBO offlineContractRspBO = this.uocFinanceOrderCreateOfflineContractAbilityService.dealOrderOfflineContractCreate(createOfflineContractReqBO);
        if (!"0000".equals(offlineContractRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", salePO.getSaleVoucherNo() + "\u751f\u6210\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01" + offlineContractRspBO.getRespDesc());
        }
    }

    private void buildRspSyncInfo(List<Long> orderIds, Map<Long, OrdSalePO> saleMap, UocFinanceSettlePlatformChangeBusiRspBO rspBO) {
        ArrayList<UocFinanceSettlePlatformSyncBO> syncBOList = new ArrayList<UocFinanceSettlePlatformSyncBO>();
        for (Long orderId : orderIds) {
            UocFinanceSettlePlatformSyncBO syncBO = new UocFinanceSettlePlatformSyncBO();
            syncBO.setOrderId(orderId);
            syncBO.setObjId(saleMap.get(orderId).getSaleVoucherId());
            syncBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            syncBOList.add(syncBO);
        }
        List inspectionPOList = this.ordInspectionMapper.getListByOrderIds(orderIds);
        for (OrdInspectionPO inspectionPO : inspectionPOList) {
            UocFinanceSettlePlatformSyncBO syncBO = new UocFinanceSettlePlatformSyncBO();
            syncBO.setOrderId(inspectionPO.getOrderId());
            syncBO.setObjId(inspectionPO.getInspectionVoucherId());
            syncBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
            syncBOList.add(syncBO);
        }
        rspBO.setSyncBOList(syncBOList);
    }

    private UocOrdContractPO buildContractPO(UocOfflineContractPO uocOfflineContractPO, OrdSalePO salePO) {
        UocOrdContractPO ordContractPO = new UocOrdContractPO();
        ordContractPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordContractPO.setOrderId(salePO.getOrderId());
        ordContractPO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        ordContractPO.setContractName(uocOfflineContractPO.getContractName());
        ordContractPO.setContractNo(uocOfflineContractPO.getContractNo());
        ordContractPO.setContractId(uocOfflineContractPO.getContractId());
        ordContractPO.setPushStatus(Integer.valueOf(2));
        ordContractPO.setFailCount(Integer.valueOf(0));
        ordContractPO.setExt3(FscConstants.SettlePlatform.FINANCE.toString());
        ordContractPO.setCreateTime(new Date());
        return ordContractPO;
    }
}

