/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdPayItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdPayItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdPayRspBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailRspBO;
import com.tydic.uoc.common.ability.bo.UocStakeOrderPassInfoBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCorePayOrderDetailQueryAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailQueryRspBO;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailRspBO;
import com.tydic.uoc.common.busi.api.UocPayOrderDetailQueryBusiService;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPayOrderDetailQueryBusiService")
public class UocPayOrderDetailQueryBusiServiceImpl
implements UocPayOrderDetailQueryBusiService {
    @Autowired
    private UocCorePayOrderDetailQueryAtomService uocCorePayOrderDetailQueryAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @Override
    public UocPayOrderDetailQueryRspBO getPayOrderDetail(UocPayOrderDetailQueryReqBO reqBO) {
        UocPayOrderDetailQueryRspBO rspBO = new UocPayOrderDetailQueryRspBO();
        this.validateParams(reqBO);
        UocCorePayOrderDetailQueryReqBO atomReqBO = new UocCorePayOrderDetailQueryReqBO();
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setObjId(reqBO.getObjId());
        atomReqBO.setObjType(reqBO.getObjType());
        atomReqBO.setQueryLevel(reqBO.getQueryLevel());
        UocCorePayOrderDetailQueryRspBO atomRspBO = this.uocCorePayOrderDetailQueryAtomService.getPayOrderDetailQuery(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            rspBO.setRespCode(atomRspBO.getRespCode());
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO = this.buildAtomRspBO(atomRspBO);
        for (UocPayOrderDetailRspBO uocPayOrderDetailRspBO : rspBO.getPayOrderDetailRspBOList()) {
            this.transOrdPay(uocPayOrderDetailRspBO.getOrdPayRspBO());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public Boolean insertOrderPassInfo(UocStakeOrderPassInfoBO uocStakeOrderPassInfoBO) {
        return this.ordStakeholderMapper.updatePassById(this.BoToPo(uocStakeOrderPassInfoBO)) == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private OrdStakeholderPO BoToPo(UocStakeOrderPassInfoBO uocStakeOrderPassInfoBO) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        BeanUtils.copyProperties((Object)uocStakeOrderPassInfoBO, (Object)ordStakeholderPO);
        return ordStakeholderPO;
    }

    private void validateParams(UocPayOrderDetailQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null != reqBO.getObjId()) {
            if (null == reqBO.getObjType()) {
                throw new UocProBusinessException("100001", "\u7edf\u4e00\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u4e3a\u7a7a\u7684\u8bdd\uff0c\u5bf9\u8c61\u7c7b\u578b\u3010objType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (0L == reqBO.getObjId()) {
                throw new UocProBusinessException("100001", "\u7edf\u4e00\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u96f6");
            }
        }
    }

    private UocPayOrderDetailQueryRspBO buildAtomRspBO(UocCorePayOrderDetailQueryRspBO atomRspBO) {
        UocPayOrderDetailQueryRspBO rspBO = new UocPayOrderDetailQueryRspBO();
        if (CollectionUtils.isNotEmpty(atomRspBO.getPayOrderDetailRspBOList())) {
            ArrayList<UocPayOrderDetailRspBO> payOrderDetailRspBOList = new ArrayList<UocPayOrderDetailRspBO>();
            for (UocCorePayOrderDetailRspBO uocCorePayOrderDetailRspBO : atomRspBO.getPayOrderDetailRspBOList()) {
                UocPayOrderDetailRspBO uocPayOrderDetailRspBO = new UocPayOrderDetailRspBO();
                BeanUtils.copyProperties((Object)uocCorePayOrderDetailRspBO, (Object)uocPayOrderDetailRspBO);
                UocOrdPayRspBO uocOrdPayRspBO = new UocOrdPayRspBO();
                BeanUtils.copyProperties((Object)uocCorePayOrderDetailRspBO.getOrdPayRspBO(), (Object)uocOrdPayRspBO);
                uocPayOrderDetailRspBO.setOrdPayRspBO(uocOrdPayRspBO);
                if (CollectionUtils.isNotEmpty(uocCorePayOrderDetailRspBO.getOrdPayItemRspBOList())) {
                    ArrayList<UocOrdPayItemRspBO> ordPayItemRspBOList = new ArrayList<UocOrdPayItemRspBO>();
                    for (OrdPayItemRspBO ordPayItemRspBO : uocCorePayOrderDetailRspBO.getOrdPayItemRspBOList()) {
                        UocOrdPayItemRspBO uocOrdPayItemRspBO = new UocOrdPayItemRspBO();
                        BeanUtils.copyProperties((Object)ordPayItemRspBO, (Object)uocOrdPayItemRspBO);
                        ordPayItemRspBOList.add(uocOrdPayItemRspBO);
                    }
                    uocPayOrderDetailRspBO.setOrdPayItemRspBOList(ordPayItemRspBOList);
                }
                payOrderDetailRspBOList.add(uocPayOrderDetailRspBO);
            }
            rspBO.setPayOrderDetailRspBOList(payOrderDetailRspBOList);
        }
        return rspBO;
    }

    private void transOrdPay(UocOrdPayRspBO uocOrdPayRspBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        uocOrdPayRspBO.setPayNode(uocOrdPayRspBO.getObjType());
        dictReqBO.setCode(uocOrdPayRspBO.getPayType() + "");
        dictReqBO.setPcode("PAY_TYPE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            uocOrdPayRspBO.setPayNodeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(uocOrdPayRspBO.getPayState() + "");
        dictReqBO.setPcode("PAY_ORDER_STATUS");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            uocOrdPayRspBO.setPayStatusStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(uocOrdPayRspBO.getPayType() + "");
        dictReqBO.setPcode("PAY_TYPE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            uocOrdPayRspBO.setPayTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(uocOrdPayRspBO.getPayState() + "");
        dictReqBO.setPcode("PAY_RESULT");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            uocOrdPayRspBO.setPayResultStr(dictRspBO.getDicDictionarys().getDescrip());
        }
    }

    private void transOrdPayNode(UocOrdPayRspBO uocOrdPayRspBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        uocOrdPayRspBO.setPayNode(uocOrdPayRspBO.getObjType());
        dictReqBO.setCode(uocOrdPayRspBO.getPayNode() + "");
        dictReqBO.setPcode("PAY_NODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            uocOrdPayRspBO.setPayNodeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
    }
}

