/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.plan.PushMdmBusiService;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationForMasterDataMaterialOfChinaCoalService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.plan.PushMdmReqBO;
import com.tydic.uoc.common.busi.bo.plan.PushMdmRspBO;
import com.tydic.uoc.common.busi.bo.plan.UccCreateEgToMdmDataBO;
import com.tydic.uoc.common.busi.bo.plan.UccGateWayApplicationForMasterDataReqBO;
import com.tydic.uoc.common.busi.bo.plan.UccGateWayApplicationForMasterDataRspBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrgSubCodeMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrgSubCodePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PushMdmBusiServiceImpl
implements PushMdmBusiService {
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Autowired
    private UccGateWayApplicationForMasterDataMaterialOfChinaCoalService uccGateWayApplicationForMasterDataMaterialOfChinaCoalService;
    @Autowired
    private UocOrgSubCodeMapper uocOrgSubCodeMapper;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Value(value="${EG_TO_MDM_ZZFP}")
    private String egToMdmzzfp;
    @Value(value="${MDM_USERCODE}")
    private String mdmUserCode;
    @Value(value="${MDM_PASSWORD}")
    private String mdmPassword;

    @Override
    public PushMdmRspBO dealPush(PushMdmReqBO reqBO) {
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(reqBO.getOrderId());
        List goodsPOS = this.ordGoodsMapper.getList(goodsPO);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.ordZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getIsPushErp())) {
            PushMdmRspBO rspBO = new PushMdmRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        ArrayList<UccCreateEgToMdmDataBO> createEgToMdmDataBOList = new ArrayList<UccCreateEgToMdmDataBO>();
        Map<Long, OrdGoodsPO> map = goodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, i -> i));
        UccGateWayApplicationForMasterDataReqBO dataReqBO = new UccGateWayApplicationForMasterDataReqBO();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OrdItemPO ordItemPO : list) {
            if (!StringUtils.isNotBlank((CharSequence)ordItemPO.getOrganizationId())) continue;
            ids.add(Long.valueOf(ordItemPO.getOrganizationId()));
        }
        List subCodePOS = new ArrayList();
        if (ids.size() > 0) {
            UocOrgSubCodePO codePO = new UocOrgSubCodePO();
            codePO.setBfOrgIdList(ids);
            subCodePOS = this.uocOrgSubCodeMapper.selectByCondition(codePO);
        }
        for (OrdItemPO ordItemPO : list) {
            OrdGoodsPO po;
            if (StringUtils.isBlank((CharSequence)ordItemPO.getOrganizationId()) || StringUtils.isBlank((CharSequence)(po = map.get(ordItemPO.getOrdItemId())).getSkuMaterialId())) continue;
            UccCreateEgToMdmDataBO createEgToMdmDataBO = new UccCreateEgToMdmDataBO();
            createEgToMdmDataBO.setDESC6(itemPO.getOrganizationName());
            createEgToMdmDataBO.setDESC7(itemPO.getOrganizationId());
            if (CollectionUtils.isNotEmpty(subCodePOS)) {
                for (UocOrgSubCodePO codePO : subCodePOS) {
                    if (!codePO.getBfOrgId().toString().equals(itemPO.getOrganizationId())) continue;
                    createEgToMdmDataBO.setDESC7(codePO.getAfsOrgId().toString());
                    createEgToMdmDataBO.setDESC6(codePO.getAfsOrgName());
                    break;
                }
            }
            createEgToMdmDataBO.setDESC18(zmInfoPO.getExt2());
            createEgToMdmDataBO.setDESC1(po.getSkuMaterialId());
            createEgToMdmDataBO.setDESC4(itemPO.getExtField2());
            createEgToMdmDataBO.setUUID(itemPO.getOrdItemId());
            createEgToMdmDataBOList.add(createEgToMdmDataBO);
        }
        dataReqBO.setUUID(reqBO.getOrderId().toString());
        dataReqBO.setAdmin(this.mdmUserCode);
        dataReqBO.setPassword(this.mdmPassword);
        dataReqBO.setUrl(this.egToMdmzzfp);
        dataReqBO.setCreateEgToMdmDataBOS(createEgToMdmDataBOList);
        UccGateWayApplicationForMasterDataRspBO rspBO = this.uccGateWayApplicationForMasterDataMaterialOfChinaCoalService.applicationForMasterData(dataReqBO);
        PushMdmRspBO mdmRspBO = new PushMdmRspBO();
        if (!PebExtConstant.YES.equals(zmInfoPO.getIsPushErp())) {
            mdmRspBO.setRespCode("0000");
        }
        if (!mdmRspBO.getRespCode().equals("0000")) {
            this.saveLog(reqBO.getOrderId(), rspBO);
        }
        BeanUtils.copyProperties((Object)((Object)rspBO), (Object)((Object)mdmRspBO));
        return mdmRspBO;
    }

    private void saveLog(Long orderId, UccGateWayApplicationForMasterDataRspBO purchaseOrderRspBO) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(JSON.toJSONString((Object)purchaseOrderRspBO.getInStr()));
        logBO.setInterCode("pushErp");
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(purchaseOrderRspBO.getRespCode());
        logBO.setOutContent(purchaseOrderRspBO.getOutStr());
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

