/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.finance.UocFinanceOrderGenerateVirtualContractReqBO;
import com.tydic.uoc.common.ability.bo.finance.UocFinanceOrderGenerateVirtualContractRspBO;
import com.tydic.uoc.common.busi.api.UocFinanceOrderGenerateVirtualContractBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOfflineContractPO;
import com.tydic.uoc.po.UocOrdContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocFinanceOrderGenerateVirtualContractBusiServiceImpl
implements UocFinanceOrderGenerateVirtualContractBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @Override
    public UocFinanceOrderGenerateVirtualContractRspBO dealGenerateVirtualContract(UocFinanceOrderGenerateVirtualContractReqBO reqBO) {
        UocOrdContractPO ordContractPO = new UocOrdContractPO();
        ordContractPO.setOrderIdList(reqBO.getOrderIds());
        List ordList = this.uocOrdContractMapper.getList(ordContractPO);
        for (UocOrdContractPO uocOrdContractPO : ordList) {
            reqBO.getOrderIds().remove(uocOrdContractPO.getOrderId());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            return new UocFinanceOrderGenerateVirtualContractRspBO();
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderIdList(reqBO.getOrderIds());
        List saleList = this.ordSaleMapper.getList(salePO);
        for (OrdSalePO ordSalePO : saleList) {
            if (!UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(ordSalePO.getOrderSource())) continue;
            reqBO.getOrderIds().remove(ordSalePO.getOrderId());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            return new UocFinanceOrderGenerateVirtualContractRspBO();
        }
        UocOrdContractPO qryOrdPO = new UocOrdContractPO();
        qryOrdPO.setOrderIdList(reqBO.getOrderIds());
        List orderInfoList = this.uocOrdContractMapper.getGenerateOrderList(qryOrdPO);
        HashMap orderMap = new HashMap();
        for (UocOrdContractPO uocOrdContractPO : orderInfoList) {
            String key;
            if (uocOrdContractPO.getOrderType().equals(PebExtConstant.OrderType.GC)) continue;
            String supplierId = uocOrdContractPO.getSupplier();
            if (UocCoreConstant.TradeMode.MATCHMAKING_MODE.equals(uocOrdContractPO.getModelSettle())) {
                supplierId = uocOrdContractPO.getSupNo() + "";
            }
            int busiType = 6;
            String buyerNo = uocOrdContractPO.getBuynerNo();
            if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.equals(uocOrdContractPO.getOrderSource()) && UocCoreConstant.TradeMode.TRADE_MODEL.equals(uocOrdContractPO.getModelSettle())) {
                busiType = 5;
            }
            if (uocOrdContractPO.getOrderType().equals(PebExtConstant.OrderType.FL)) {
                buyerNo = uocOrdContractPO.getFlOrgCode();
                busiType = 4;
            }
            if (StringUtils.isEmpty((CharSequence)buyerNo)) continue;
            if (uocOrdContractPO.getOrderType().equals(PebExtConstant.OrderType.TH)) {
                busiType = 0;
            }
            if (orderMap.containsKey(key = supplierId + "-" + buyerNo + "-" + busiType)) {
                ((List)orderMap.get(key)).add(uocOrdContractPO);
                continue;
            }
            ArrayList<UocOrdContractPO> list = new ArrayList<UocOrdContractPO>();
            list.add(uocOrdContractPO);
            orderMap.put(key, list);
        }
        ArrayList addContractList = new ArrayList();
        for (String key : orderMap.keySet()) {
            String[] split = key.split("-");
            UocOfflineContractPO offLinePO = new UocOfflineContractPO();
            offLinePO.setSupplierId(Long.valueOf(split[0]));
            offLinePO.setBuynerNo(split[1]);
            offLinePO.setOrderType(Integer.valueOf(split[2]));
            offLinePO.setExt3("2");
            List offLineList = this.uocOfflineContractMapper.getEffectModel(offLinePO);
            if (CollectionUtils.isEmpty((Collection)offLineList)) continue;
            if (offLineList.size() > 1) {
                throw new UocProBusinessException("103030", "\u7ebf\u4e0b\u5408\u540c\u914d\u7f6e\u9519\u8bef!");
            }
            UocOfflineContractPO uocOfflineContractPO = (UocOfflineContractPO)offLineList.get(0);
            List contractPOList = (List)orderMap.get(key);
            for (UocOrdContractPO uocOrdContractPO : contractPOList) {
                uocOrdContractPO.setId(Long.valueOf(this.idUtil.nextId()));
                uocOrdContractPO.setContractNo(uocOfflineContractPO.getContractNo());
                uocOrdContractPO.setContractId(uocOfflineContractPO.getContractId());
                uocOrdContractPO.setContractName(uocOfflineContractPO.getContractName());
                uocOrdContractPO.setPushStatus(Integer.valueOf(2));
                uocOrdContractPO.setFailCount(Integer.valueOf(0));
                uocOrdContractPO.setExt3(FscConstants.SettlePlatform.FINANCE.toString());
                uocOrdContractPO.setCreateTime(new Date());
            }
            addContractList.addAll(contractPOList);
        }
        if (!CollectionUtils.isEmpty(addContractList)) {
            this.uocOrdContractMapper.insertBatch(addContractList);
        }
        return new UocFinanceOrderGenerateVirtualContractRspBO();
    }
}

