/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPurchaseSingleDetailsListQueryBO;
import com.tydic.uoc.common.ability.bo.UocPurchaseSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocPurchaseSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.busi.api.UocEsQryPurchaseListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryPurchaseListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryPurchaseListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsQryPurchaseListSingleBO;
import com.tydic.uoc.common.comb.api.UocPurchaseSingleDetailsListQueryCombService;
import com.tydic.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.uoc.po.ConfTabOrdStatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UocPurchaseSingleDetailsListQueryCombServiceImpl
implements UocPurchaseSingleDetailsListQueryCombService {
    @Autowired
    private UocEsQryPurchaseListBusiService esQryPurchaseListBusiService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;

    @Override
    public UocPurchaseSingleDetailsListQueryRspBO getPurchaseSingleDetailsListQuery(UocPurchaseSingleDetailsListQueryReqBO reqBO) {
        UocEsQryPurchaseListReqBO esQryPurchaseListReqBO = this.buildEsQryPurchaseListReqBO(reqBO);
        UocEsQryPurchaseListRspBO esQryPurchaseListRspBO = this.esQryPurchaseListBusiService.esQryPurchaseList(esQryPurchaseListReqBO);
        if (!"0000".equals(esQryPurchaseListRspBO.getRespCode())) {
            throw new UocProBusinessException(esQryPurchaseListRspBO.getRespCode(), esQryPurchaseListRspBO.getRespDesc());
        }
        return this.transEsQryPurchaseListRspBO(esQryPurchaseListRspBO);
    }

    private UocEsQryPurchaseListReqBO buildEsQryPurchaseListReqBO(UocPurchaseSingleDetailsListQueryReqBO reqBO) {
        UocEsQryPurchaseListReqBO esQryPurchaseListReqBO = new UocEsQryPurchaseListReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)esQryPurchaseListReqBO);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTabIdList())) {
            esQryPurchaseListReqBO.setPurchaseStateList(this.getStatueList(reqBO.getTabIdList()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            ArrayList<String> orderSourceList = new ArrayList<String>();
            orderSourceList.add(reqBO.getOrderSource());
            esQryPurchaseListReqBO.setOrderSourceList(orderSourceList);
        }
        return esQryPurchaseListReqBO;
    }

    private List<Integer> getStatueList(List<Integer> tabIds) {
        ConfTabOrdStatePO tabOrdStatePO = new ConfTabOrdStatePO();
        ArrayList<Integer> statueList = new ArrayList<Integer>();
        tabOrdStatePO.setTabIdList(tabIds);
        List confTabOrdStatePOList = this.confTabOrdStateMapper.getList(tabOrdStatePO);
        if (CollectionUtils.isNotEmpty((Collection)confTabOrdStatePOList)) {
            for (ConfTabOrdStatePO confTabOrdStatePO : confTabOrdStatePOList) {
                String statueStr = confTabOrdStatePO.getOrderStatusCode();
                if (StringUtils.isEmpty((Object)statueStr)) continue;
                String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                for (String state : statue) {
                    statueList.add(Integer.valueOf(state));
                }
            }
        }
        return statueList;
    }

    private UocPurchaseSingleDetailsListQueryRspBO transEsQryPurchaseListRspBO(UocEsQryPurchaseListRspBO esQryPurchaseListRspBO) {
        UocPurchaseSingleDetailsListQueryRspBO rspBO = new UocPurchaseSingleDetailsListQueryRspBO();
        rspBO.setPageNo(esQryPurchaseListRspBO.getPageNo());
        rspBO.setRecordsTotal(esQryPurchaseListRspBO.getRecordsTotal());
        if (CollectionUtils.isNotEmpty((Collection)esQryPurchaseListRspBO.getRows())) {
            ArrayList<UocPurchaseSingleDetailsListQueryBO> rows = new ArrayList<UocPurchaseSingleDetailsListQueryBO>();
            for (UocEsQryPurchaseListSingleBO esQryPurchaseListSingleBO : esQryPurchaseListRspBO.getRows()) {
                rows.add(esQryPurchaseListSingleBO.getPurchaseSingleDetailsListQueryBO());
            }
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

