/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocDealCancelMsgAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocDealCancelMsgShipReqBO;
import com.tydic.uoc.common.ability.bo.UocDealCancelMsgShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebGeneralConsumerReqBO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocPebUpdateMsgPoolReqBO;
import com.tydic.uoc.common.atom.bo.UocPebUpdateMsgPoolRspBO;
import com.tydic.uoc.common.busi.api.UocPebUpdateMsgPoolBusiService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PebCancelOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(PebCancelOrderConsumer.class);
    @Autowired
    private UocDealCancelMsgAbilityService uocDealCancelMsgAbilityService;
    @Autowired
    private UocPebUpdateMsgPoolBusiService uocPebUpdateMsgPoolBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC:DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC}")
    private String pushFzOrderEvaluateTopic;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TAG:DEAL_PUSH_FZ_ORDER_EVALUATE_TAG}")
    private String pushFzOrderEvaluateTag;
    @Resource(name="dealPushFzOrderEvaluateProvider")
    private ProxyMessageProducer dealPushFzOrderEvaluateProvider;
    @Value(value="${DEAL_WAREHOUSE_ORDER_CANCEL_TOPIC:DEAL_WAREHOUSE_ORDER_CANCEL_TOPIC}")
    private String pushWarehouseOrderCancelTopic;
    @Value(value="${DEAL_WAREHOUSE_ORDER_CANCEL_TAG:DEAL_WAREHOUSE_ORDER_CANCEL_TAG}")
    private String pushWarehouseOrderCancelTag;
    @Resource(name="dealPushWarehouseOrderCancelProvider")
    private ProxyMessageProducer dealPushWarehouseOrderCancelProvider;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        UocPebGeneralConsumerReqBO uocPebGeneralConsumerReqBO = (UocPebGeneralConsumerReqBO)JSON.parseObject((String)message.getContent(), UocPebGeneralConsumerReqBO.class);
        UocDealCancelMsgShipReqBO reqBO = new UocDealCancelMsgShipReqBO();
        BeanUtils.copyProperties((Object)uocPebGeneralConsumerReqBO, (Object)reqBO);
        UocDealCancelMsgShipRspBO rspBO = this.uocDealCancelMsgAbilityService.dealCancelMsg(reqBO);
        this.updateMsgPoolInfo(uocPebGeneralConsumerReqBO, rspBO);
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void updateMsgPoolInfo(UocPebGeneralConsumerReqBO consumerReqBO, UocDealCancelMsgShipRspBO rspBO) {
        UocPebUpdateMsgPoolRspBO updateMsgPoolRspBO;
        UocPebUpdateMsgPoolReqBO uocPebUpdateMsgPoolReqBO = new UocPebUpdateMsgPoolReqBO();
        uocPebUpdateMsgPoolReqBO.setMsgId(consumerReqBO.getMsgId());
        uocPebUpdateMsgPoolReqBO.setGoodSupplierId(consumerReqBO.getSupplierId());
        if (!"0000".equals(rspBO.getRespCode())) {
            uocPebUpdateMsgPoolReqBO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.RUN_FAILURE);
            uocPebUpdateMsgPoolReqBO.setFailureReason(rspBO.getRespDesc());
        } else {
            PebExtSyncUnifyChangeAbilityReqBO changeReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
            changeReqBO.setOrderId(consumerReqBO.getOrderId());
            changeReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
            this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeReqBO);
            uocPebUpdateMsgPoolReqBO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.RUN_SUCCESS);
        }
        if ("0000".equals(rspBO.getRespCode()) && "0".equals(String.valueOf(consumerReqBO.getStatus()))) {
            PebExtWarehouseOrderCancelAbilityReqBO cancelAbilityReqBO = new PebExtWarehouseOrderCancelAbilityReqBO();
            cancelAbilityReqBO.setOrderId(consumerReqBO.getOrderId());
            this.dealPushWarehouseOrderCancelProvider.send(new ProxyMessage(this.pushWarehouseOrderCancelTopic, this.pushWarehouseOrderCancelTag, JSONObject.toJSONString((Object)cancelAbilityReqBO)));
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setUserId(1L);
            sendNotificationExtAtomReqBO.setOrderId(consumerReqBO.getOrderId());
            sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_CANCEL);
            this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
        }
        if (!"0000".equals((updateMsgPoolRspBO = this.uocPebUpdateMsgPoolBusiService.updateMsgPool(uocPebUpdateMsgPoolReqBO)).getRespCode())) {
            this.logger.error("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u5b8c\u6210\u540e\u66f4\u65b0\u6d88\u606f\u6c60\u6570\u636e\u5931\u8d25\uff1a" + updateMsgPoolRspBO.getRespDesc());
        }
    }
}

