/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ard.security.utils.StringUtils;
import com.ard.security.utils.sm3.SM3Digest;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncConsumerVO;
import com.tydic.uoc.common.enums.ESGPayTypeEnum;
import com.tydic.uoc.common.vo.UocESGOrderDetailConsumerVO;
import com.tydic.uoc.common.vo.UocESGOrderDetailGoodsConsumerVO;
import com.tydic.uoc.common.vo.UocESGOrderInfoConsumerVO;
import com.tydic.uoc.common.vo.UocESGOrderSyncRspConsumerVO;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocEsgPushLogMapper;
import com.tydic.uoc.dao.UocEsgPushLogPreMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocEsgPushLogPO;
import com.tydic.uoc.po.UocEsgPushLogPrePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class UocESGCreateOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocESGCreateOrderConsumer.class);
    @Resource
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrdStakeholderMapper ordStakeholderMapper;
    @Resource
    private OrdPayMapper ordPayMapper;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdGoodsMapper ordGoodsMapper;
    @Resource
    private OrdItemMapper ordItemMapper;
    @Resource
    private UocEsgPushLogMapper uocEsgPushLogMapper;
    @Resource
    private UocEsgPushLogPreMapper uocEsgPushLogPreMapper;
    @Autowired
    private UocESGConfig uocESGConfig;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005");
        try {
            log.info("---------------\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            UocESGOrderSyncConsumerVO reqConsumerVO = (UocESGOrderSyncConsumerVO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<UocESGOrderSyncConsumerVO>(){}, (Feature[])new Feature[0]);
            if (Objects.isNull(reqConsumerVO) || CollectionUtils.isEmpty((Collection)reqConsumerVO.getOrderIds())) {
                log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u6d88\u606f\u4f53\u4e3a\u7a7a\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.info("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u606f\u4f53\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqConsumerVO));
            List<UocESGOrderInfoConsumerVO> reqVOList = this.orderData(reqConsumerVO);
            if (CollectionUtils.isEmpty(reqVOList)) {
                log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u7ec4\u88c5\u63a8\u9001\u6570\u636e\u4e3a\u7a7a");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            reqVOList.forEach(vo -> {
                int status = 0;
                String respData = null;
                JSONObject param = JSON.parseObject((String)JSON.toJSONString((Object)vo));
                String response = null;
                this.insertLogPre(Long.valueOf(vo.getOrderOldCode()), status, JSON.toJSONString((Object)vo));
                try {
                    response = this.send(this.uocESGConfig.getCreateUrl(), param);
                }
                catch (IOException e) {
                    log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u606f\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38\uff1a" + e);
                }
                if (StringUtils.isNotBlank((CharSequence)response)) {
                    UocESGOrderSyncRspConsumerVO rspConsumerVO = (UocESGOrderSyncRspConsumerVO)JSON.parseObject((String)response, UocESGOrderSyncRspConsumerVO.class);
                    if (Objects.isNull(rspConsumerVO) || !"200".equals(rspConsumerVO.getApistatus())) {
                        log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + rspConsumerVO.getMsg());
                    } else {
                        status = 1;
                    }
                    respData = JSON.toJSONString((Object)rspConsumerVO);
                }
                this.insertLog(Long.valueOf(vo.getOrderOldCode()), status, JSON.toJSONString((Object)vo), respData);
            });
        }
        catch (Exception e) {
            log.error("\u5165\u53c2\uff1a{} \u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + e, (Object)message.getContent());
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        stopWatch.stop();
        log.error(stopWatch.getLastTaskName() + "\u8017\u65f6:" + stopWatch.getTotalTimeMillis() + "s");
        log.info("---------------\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u7ed3\u675f---------------");
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void insertLog(Long orderId, int status, String pushDate, String respDate) {
        UocEsgPushLogPO uocEsgPushLogPO = new UocEsgPushLogPO();
        uocEsgPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uocEsgPushLogPO.setObjectId(orderId);
        uocEsgPushLogPO.setPushStatus(Integer.valueOf(status));
        uocEsgPushLogPO.setType(Integer.valueOf(1));
        uocEsgPushLogPO.setPushData(pushDate);
        uocEsgPushLogPO.setRespData(respDate);
        uocEsgPushLogPO.setPushTime(new Date());
        this.uocEsgPushLogMapper.insert(uocEsgPushLogPO);
    }

    private void insertLogPre(Long orderId, int status, String pushDate) {
        UocEsgPushLogPrePO prePO = new UocEsgPushLogPrePO();
        prePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        prePO.setObjectId(orderId);
        prePO.setPushStatus(Integer.valueOf(status));
        prePO.setType(Integer.valueOf(1));
        prePO.setPushData(pushDate);
        prePO.setPushTime(new Date());
        this.uocEsgPushLogPreMapper.insert(prePO);
    }

    public List<UocESGOrderInfoConsumerVO> orderData(UocESGOrderSyncConsumerVO uocESGOrderSyncConsumerVO) {
        ArrayList<UocESGOrderInfoConsumerVO> reqVOList = new ArrayList<UocESGOrderInfoConsumerVO>();
        uocESGOrderSyncConsumerVO.getOrderIds().forEach(e -> {
            UocOrdZmInfoPO ordZmInfoPOReq = new UocOrdZmInfoPO();
            ordZmInfoPOReq.setOrderId(e);
            UocOrdZmInfoPO ordZmInfoPO = this.uocOrdZmInfoMapper.selectOne(ordZmInfoPOReq);
            if (Objects.isNull(ordZmInfoPO) || StringUtils.isEmpty((String)ordZmInfoPO.getAssistDistName())) {
                log.error("\u8ba2\u5355\u53f7\uff1a{} \u4e0d\u662f\u6276\u8d2b\u4e13\u533a\u8ba2\u5355\uff0c\u65e0\u9700\u63a8\u9001", e);
                return;
            }
            UocEsgPushLogPO uocEsgPushLogPO = new UocEsgPushLogPO();
            uocEsgPushLogPO.setObjectId(e);
            uocEsgPushLogPO.setType(Integer.valueOf(1));
            uocEsgPushLogPO.setPushStatus(Integer.valueOf(1));
            List pushLogPOList = this.uocEsgPushLogMapper.getList(uocEsgPushLogPO);
            if (CollectionUtils.isNotEmpty((Collection)pushLogPOList)) {
                log.error("\u8ba2\u5355\u53f7\uff1a{} \u91cd\u590d\u63a8\u9001\uff0c\u5f53\u524d\u65e0\u9700\u63a8\u9001", e);
                return;
            }
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(e);
            orderPO = this.orderMapper.getModelBy(orderPO);
            OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
            ordStakeholderPO.setOrderId(e);
            ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(e);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrderId(e);
            List ordGoodsPOList = this.ordGoodsMapper.getList(ordGoodsPO);
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(e);
            List ordItemPOList = this.ordItemMapper.getList(ordItemPO);
            if (Objects.isNull(ordStakeholderPO) || Objects.isNull(ordSalePO) || CollectionUtils.isEmpty((Collection)ordGoodsPOList) || CollectionUtils.isEmpty((Collection)ordItemPOList)) {
                return;
            }
            Integer payType = ESGPayTypeEnum.OTHERS.getCode();
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(e);
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            List ordPayPOList = this.ordPayMapper.getList(ordPayPO);
            if (CollectionUtils.isNotEmpty((Collection)ordPayPOList) && Objects.nonNull(((OrdPayPO)ordPayPOList.get(0)).getPayType())) {
                if (((OrdPayPO)ordPayPOList.get(0)).getPayType() == 1) {
                    payType = ESGPayTypeEnum.WECHAT.getCode();
                } else if (((OrdPayPO)ordPayPOList.get(0)).getPayType() == 2) {
                    payType = ESGPayTypeEnum.ALIPAY.getCode();
                }
            }
            UocESGOrderInfoConsumerVO reqVO = new UocESGOrderInfoConsumerVO();
            reqVO.setCentralName(this.uocESGConfig.getCentralName());
            reqVO.setPlatformName(this.uocESGConfig.getPlatformName());
            reqVO.setOrderOldCode(String.valueOf(e));
            reqVO.setOrderTime(DateUtil.dateToStr((Date)orderPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            reqVO.setPayType(String.valueOf(payType));
            reqVO.setPayTypeName(ESGPayTypeEnum.getInstance(payType).getCodeDesc());
            reqVO.setOrderPrice(Objects.isNull(ordSalePO.getSaleFee()) ? "0" : String.valueOf(MoneyUtil.l2B((Long)ordSalePO.getSaleFee())));
            reqVO.setShoppingName(ordStakeholderPO.getPurPlaceOrderName());
            ArrayList<UocESGOrderDetailConsumerVO> orderDetails = new ArrayList<UocESGOrderDetailConsumerVO>();
            UocESGOrderDetailConsumerVO detailReqConsumerVO = new UocESGOrderDetailConsumerVO();
            detailReqConsumerVO.setOrderCode(String.valueOf(e));
            detailReqConsumerVO.setOrderPrice(Objects.isNull(ordSalePO.getSaleFee()) ? "0" : String.valueOf(MoneyUtil.l2B((Long)ordSalePO.getSaleFee())));
            detailReqConsumerVO.setOrderStatus("1");
            detailReqConsumerVO.setOrderType(Objects.nonNull(orderPO.getOrderType()) && orderPO.getOrderType() == 7 ? "2" : "1");
            ArrayList<UocESGOrderDetailGoodsConsumerVO> orderDetailGoods = new ArrayList<UocESGOrderDetailGoodsConsumerVO>();
            Map ordItemPOMap = ordItemPOList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
            ordGoodsPOList.forEach(item -> {
                UocESGOrderDetailGoodsConsumerVO detailGoodsReqConsumerVO = new UocESGOrderDetailGoodsConsumerVO();
                detailGoodsReqConsumerVO.setAssistDistName(ordZmInfoPO.getAssistDistName());
                detailGoodsReqConsumerVO.setGoodsItemNo(item.getSkuId());
                detailGoodsReqConsumerVO.setGoodsName(item.getSkuName());
                detailGoodsReqConsumerVO.setBrandName(item.getSkuBrandName());
                detailGoodsReqConsumerVO.setCategoryCode("B01");
                detailGoodsReqConsumerVO.setCategoryName("\u6d88\u8d39\u5e2e\u6276");
                detailGoodsReqConsumerVO.setGoodsPrice(Objects.isNull(item.getSaleDecimalPrice()) ? "0" : String.valueOf(item.getSaleDecimalPrice()));
                detailGoodsReqConsumerVO.setGoodsPreferPrice(Objects.isNull(item.getSaleDecimalPrice()) ? "0" : String.valueOf(item.getSaleDecimalPrice()));
                if (ordItemPOMap.size() > 0 && Objects.nonNull(ordItemPOMap.get(item.getOrdItemId()))) {
                    detailGoodsReqConsumerVO.setNumber(String.valueOf(((OrdItemPO)ordItemPOMap.get(item.getOrdItemId())).getPurchaseCount()));
                } else {
                    detailGoodsReqConsumerVO.setNumber("0");
                }
                detailGoodsReqConsumerVO.setStoreName(ordZmInfoPO.getSupplierName());
                orderDetailGoods.add(detailGoodsReqConsumerVO);
            });
            detailReqConsumerVO.setOrderDetailGoods(orderDetailGoods);
            orderDetails.add(detailReqConsumerVO);
            reqVO.setOrderDetail(orderDetails);
            reqVOList.add(reqVO);
        });
        return reqVOList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String send(String url, JSONObject param) throws IOException {
        String body = "";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            JSONObject paramJson = new JSONObject();
            paramJson.put("param", (Object)JSONObject.toJSONString(Collections.singletonList(param)));
            String signcf = "h5_iden:" + new Date().getTime() + param.getString("orderOldCode");
            paramJson.put("sign_cf", (Object)signcf);
            String s = this.replaceParam(signcf, JSON.toJSONString((Object)paramJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
            String signYq = SM3Digest.sm3Digest((String)s);
            paramJson.put("sign_yq", (Object)signYq);
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                ContentType contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (String)"UTF-8");
                builder.addPart(key, (ContentBody)new StringBody(paramJson.getString(key), contentType));
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            log.info("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u540c\u6b65\u8bf7\u6c42\u5730\u5740\uff1a" + url + "\u8bf7\u6c42\u5165\u53c2\uff1a " + paramJson.toJSONString());
            StopWatch stopWatch = new StopWatch();
            stopWatch.start("\u8c03\u7528\u5174\u519c\u8282\u63a5\u53e3\u8017\u65f6\uff1a");
            try {
                Throwable throwable;
                CloseableHttpResponse response;
                block36: {
                    String string;
                    block37: {
                        response = client.execute((HttpUriRequest)httpPost);
                        throwable = null;
                        stopWatch.stop();
                        log.error(stopWatch.getLastTaskName() + stopWatch.getTotalTimeMillis() + "s");
                        if (!Objects.isNull(response)) break block36;
                        log.error("\u5bf9\u63a5\u5174\u519c\u8282\u8ba2\u5355\u5e73\u53f0\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        string = null;
                        if (response == null) return string;
                        if (throwable == null) break block37;
                        try {
                            response.close();
                            return string;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return string;
                        }
                    }
                    response.close();
                    return string;
                }
                try {
                    HttpEntity responseEntity = response.getEntity();
                    body = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf8");
                    log.info("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\uff1a" + body);
                    EntityUtils.consume((HttpEntity)entity);
                    return body;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u540c\u6b65\u5f02\u5e38\uff1a" + e);
                return body;
            }
        }
        catch (Exception e) {
            log.error("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u540c\u6b65\u5f02\u5e38\uff1a" + e);
        }
        return body;
    }

    public String replaceParam(String sign_cf, String requstParam) {
        requstParam = requstParam.replaceAll("\\[|\\]", "");
        if (sign_cf.contains("h5_iden:")) {
            requstParam = requstParam.replaceAll("\\[|\\]|\\+|\\\\r|\\\\n|\\\\t|\\\\|\\/|\"|'|\\s*|\\s|\\<|\\>", "");
            String regEx = "[@`~#\uffe5%&*\u2018\u201c\u2019\u201d\"'<>?=.;^]";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(requstParam);
            requstParam = matcher.replaceAll("");
            requstParam = requstParam.replaceAll(" ", "");
            requstParam = requstParam.replaceAll(" ", "");
        }
        return requstParam;
    }
}

