/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.tydic.uoc.common.utils.PdfUtil;
import java.util.List;

public class PdfNewUtils {
    public static void addCellToTable(PdfPTable table, String content, Font font, Integer horizontalAlignment, Integer verticalAlignment, Float fixedHeight, Integer colspan, Integer border) {
        PdfUtil.addCellToTable(table, content, font, horizontalAlignment, verticalAlignment, fixedHeight, colspan, border);
    }

    public static void addCellToTableNew(PdfPTable table, String content, Font font, Integer horizontalAlignment, Integer verticalAlignment, Float fixedHeight, Integer colspan, Integer border, List<String> disAbleBorder) {
        PdfPCell cell = new PdfPCell(new Phrase(content, font));
        if (fixedHeight != null) {
            cell.setFixedHeight(fixedHeight.floatValue());
        }
        if (horizontalAlignment != null) {
            cell.setHorizontalAlignment(horizontalAlignment.intValue());
        }
        if (verticalAlignment != null) {
            cell.setVerticalAlignment(verticalAlignment.intValue());
        }
        if (colspan != null) {
            cell.setColspan(colspan.intValue());
        }
        if (border != null) {
            cell.setBorder(border.intValue());
        }
        if (disAbleBorder != null && !disAbleBorder.isEmpty()) {
            if (disAbleBorder.contains("top")) {
                cell.disableBorderSide(1);
            }
            if (disAbleBorder.contains("bottom")) {
                cell.disableBorderSide(2);
            }
            if (disAbleBorder.contains("left")) {
                cell.disableBorderSide(4);
            }
            if (disAbleBorder.contains("right")) {
                cell.disableBorderSide(8);
            }
        }
        table.addCell(cell);
    }

    public static void addTableListToDoc(Document document, List<PdfPTable> tableList) {
        if (tableList.isEmpty()) {
            return;
        }
        tableList.forEach(table -> {
            try {
                document.add((Element)table);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        });
    }
}

