/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.uoc.common.consumer.UocTodoConsumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqToDoWaitConfiguration {
    @Value(value="${UOC_SYNC_TODO_PID:UOC_SYNC_TODO_PID}")
    private String pid;
    @Value(value="${UOC_SYNC_TODO_CID:UOC_SYNC_TODO_CID}")
    private String cid;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String topic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String tag;

    @Bean(value={"uocPushTodoProxyMessageConfig"})
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(this.pid);
        return defaultProxyMessageConfig;
    }

    @Bean(value={"uocPushTodoProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean(value={"uocTodoConsumer"})
    public UocTodoConsumer uocCreateOrderConsumer() {
        UocTodoConsumer uocTodoConsumer = new UocTodoConsumer();
        uocTodoConsumer.setId(this.cid);
        uocTodoConsumer.setSubject(this.topic);
        String[] tags = new String[]{this.tag};
        uocTodoConsumer.setTags(tags);
        return uocTodoConsumer;
    }
}

