/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractItemCanBuyListQryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryRspBO;
import com.tydic.umc.general.ability.api.UmcLogisticsRelaAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemIdByUserIdAbilityService;
import com.tydic.umc.general.ability.bo.LogisticsRelaAbilityBO;
import com.tydic.umc.general.ability.bo.UmcLogisticsRelaAbilitReqBO;
import com.tydic.umc.general.ability.bo.UmcLogisticsRelaAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoByUserIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoByUserIdAbilityRspBO;
import com.tydic.uoc.base.bo.UocOrdGoodsTempBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderAuditInfoBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderRelItemBo;
import com.tydic.uoc.common.busi.api.PebOrderItemTempBusiService;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.UocOrderRelItemMapper;
import com.tydic.uoc.zone.ability.api.PebExtAgreementCreateOrderAbilityService;
import com.tydic.uoc.zone.ability.api.PebZnhtAutoOrderAbilityService;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import com.tydic.uoc.zone.ability.bo.PebZnhtAutoOrderAbilityReqBO;
import com.tydic.uoc.zone.ability.bo.PebZnhtAutoOrderAbilityRspBO;
import com.tydic.uoc.zone.ability.bo.UocMemInfoBO;
import com.tydic.uoc.zone.ability.bo.UocStationWebBO;
import com.tydic.uoc.zone.ability.bo.UocSupSaleOrgBO;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.PebZnhtAutoOrderAbilityService"})
public class PebZnhtAutoOrderAbilityServiceImpl
implements PebZnhtAutoOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebZnhtAutoOrderAbilityServiceImpl.class);
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private ContractItemCanBuyListQryAbilityService contractItemCanBuyListQryAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private PebOrderItemTempBusiService pebOrderItemTempBusiService;
    @Autowired
    private UmcQryMemIdByUserIdAbilityService umcQryMemIdByUserIdAbilityService;
    @Autowired
    private PebExtAgreementCreateOrderAbilityService pebExtAgreementCreateOrderAbilityService;
    @Autowired
    private UmcLogisticsRelaAbilityService umcLogisticsRelaAbilityService;
    @Value(value="${znht.auto.order.contactId:781932337508159488}")
    private String contactId;
    @Value(value="${znht.auto.order.purUserNo:10051902}")
    private String purUserNo;
    @Value(value="${znht.auto.order.pageSize:1000}")
    private Integer PageSize;
    @Value(value="${znht.auto.order.procKey:\u804c\u80fd\u5408\u540c\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u6d41\u7a0b}")
    private String procKey;
    @Value(value="${checkCrcSupSignUpUrl:http://172.20.175.3/dyc/busicommon/crc/noauth/checkCrcSupSignUp}")
    private String checkCrcSupSignUpUrl;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;
    @Autowired
    private XwgLSaveLogAbilityService xwglSaveLogAbilityService;
    @Value(value="${order.check.sup.yjCode.ruleNos:LYGL-DD-00005}")
    private String orderCheckSupYjCode;
    @Autowired
    private UocOrderRelItemMapper uocOrderRelItemMapper;

    @PostMapping(value={"dealZnhtAutoOrder"})
    public PebZnhtAutoOrderAbilityRspBO dealZnhtAutoOrder(@RequestBody PebZnhtAutoOrderAbilityReqBO reqBO) {
        ContractDetailQueryAbilityRspBO contractInfoBo;
        if (Objects.nonNull(reqBO.getContractId())) {
            ContractDetailQueryAbilityReqBO condetailReqBo = new ContractDetailQueryAbilityReqBO();
            condetailReqBo.setContractId(reqBO.getContractId());
            ContractDetailQueryAbilityRspBO condetailRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(condetailReqBo);
            log.info("\u67e5\u8be2\u5408\u540c\u4e3b\u4f53\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)condetailRspBO));
            if (Objects.isNull(condetailRspBO)) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u5408\u540c\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (Objects.isNull(condetailRspBO.getContractId())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u5408\u540c\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25\uff1a" + condetailRspBO.getMessage());
            }
            reqBO.setJson(JSON.toJSONString((Object)condetailRspBO));
        }
        if ((contractInfoBo = (ContractDetailQueryAbilityRspBO)JSON.parseObject((String)reqBO.getJson(), ContractDetailQueryAbilityRspBO.class)).getContractStatus() != 8) {
            throw new UocProBusinessException("8888", "\u5408\u540c\u4e0d\u662f\u751f\u6548\u72b6\u6001 \u4e0d\u5141\u8bb8\u751f\u6210\u8ba2\u5355");
        }
        this.checkSup(contractInfoBo);
        UocMemInfoBO userInfo = this.dealUserInfo(contractInfoBo.getCreateUserId());
        ContractItemCanBuyListQryAbilityReqBO itemCanBuyReqBO = new ContractItemCanBuyListQryAbilityReqBO();
        itemCanBuyReqBO.setContractIds(Arrays.asList(contractInfoBo.getContractId()));
        itemCanBuyReqBO.setOrgId(userInfo.getOrgId());
        itemCanBuyReqBO.setOccupation(userInfo.getOccupation());
        itemCanBuyReqBO.setPageNo(Integer.valueOf(-1));
        itemCanBuyReqBO.setPageSize(this.PageSize);
        ContractItemCanBuyListQryAbilityRspBO itemCanBuyRspBO = this.contractItemCanBuyListQryAbilityService.queryItemCanBuyList(itemCanBuyReqBO);
        log.info("\u67e5\u8be2\u5408\u540c\u7269\u6599\u660e\u7ec6{}", (Object)JSON.toJSONString((Object)itemCanBuyRspBO));
        if (!"0000".equals(itemCanBuyRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)itemCanBuyRspBO.getRows())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5408\u540c\u7269\u6599\u660e\u7ec6\u5931\u8d25\uff1a" + itemCanBuyRspBO.getRespDesc());
        }
        if (Objects.isNull(((ContractItemCanBuyListQryRspBO)itemCanBuyRspBO.getRows().get(0)).getCanSaleNum()) || ((ContractItemCanBuyListQryRspBO)itemCanBuyRspBO.getRows().get(0)).getCanSaleNum().compareTo(BigDecimal.ZERO) == 0) {
            throw new UocProBusinessException("8888", "\u5408\u540c\u7269\u6599\u660e\u7ec6\u6ca1\u6709\u53ef\u4e0b\u5355\u6570\u91cf");
        }
        Long orderId = this.idUtil.nextId();
        BigDecimal totalAmount = BigDecimal.ZERO;
        PebExtAgreementCreateOrderReqBO zoneOrderReq = (PebExtAgreementCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)userInfo), PebExtAgreementCreateOrderReqBO.class);
        zoneOrderReq.setMergeOrderId(Long.valueOf(this.idUtil.nextId()));
        zoneOrderReq.setOrderSource("1");
        zoneOrderReq.setOrderId(orderId);
        zoneOrderReq.setTaxrate(((ContractItemCanBuyListQryRspBO)itemCanBuyRspBO.getRows().get(0)).getRate());
        if (Objects.nonNull(contractInfoBo.getContractInfoExtBO())) {
            zoneOrderReq.setFuncAccountId(contractInfoBo.getContractInfoExtBO().getFuncAccountId());
            zoneOrderReq.setFuncAccountName(contractInfoBo.getContractInfoExtBO().getFuncAccountName());
            zoneOrderReq.setUnifyDeptId(contractInfoBo.getContractInfoExtBO().getUnifyDeptId());
            zoneOrderReq.setUnifyDeptName(contractInfoBo.getContractInfoExtBO().getUnifyDeptName());
        }
        zoneOrderReq.setGenerateMethod("1");
        zoneOrderReq.setInspExecution("2");
        this.dealTempItems(orderId, itemCanBuyRspBO, contractInfoBo, userInfo, zoneOrderReq);
        this.dealParam(zoneOrderReq, contractInfoBo);
        CompletableFuture.runAsync(() -> {
            log.info("\u804c\u80fd\u5408\u540c\u81ea\u52a8\u751f\u6210\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)zoneOrderReq));
            PebExtAgreementCreateOrderRspBO zoneOrderRsp = this.pebExtAgreementCreateOrderAbilityService.dealPebExtAgreementCreateOrder(zoneOrderReq);
            log.info("\u804c\u80fd\u5408\u540c\u81ea\u52a8\u751f\u6210\u8ba2\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)zoneOrderRsp));
        });
        return new PebZnhtAutoOrderAbilityRspBO();
    }

    private void checkSup(ContractDetailQueryAbilityRspBO contractInfoBo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("signUpType", (Object)4);
        jsonObject.put("supplierIdWeb", (Object)contractInfoBo.getSupplierId());
        String result = HttpUtil.doPost((String)this.checkCrcSupSignUpUrl, (String)JSONObject.toJSONString((Object)jsonObject));
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        if (!"0".equals(resultJsonObject.getString("code"))) {
            throw new UocProBusinessException("8888", "\u5f3a\u5236\u6821\u9a8c\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8ba2\u5355");
        }
        if (StringUtils.isEmpty((Object)resultJsonObject.getString("yjFlag"))) {
            throw new UocProBusinessException("8888", "\u5f3a\u5236\u6821\u9a8c\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25yjFlag\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8ba2\u5355");
        }
        if (UocConstant.YjFlag.YES.equals(resultJsonObject.getInteger("yjFlag"))) {
            XwglRuleGetNoauthDetailRspBo xwglRuleGetNoauthDetailRspBo = this.getXwglRuleGetNoauthDetailRspBo();
            this.saveXwgl(contractInfoBo, xwglRuleGetNoauthDetailRspBo, null);
            throw new UocProBusinessException("8888", "\u5f3a\u5236\u6821\u9a8c\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u5931\u4fe1\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8ba2\u5355");
        }
    }

    private void saveXwgl(ContractDetailQueryAbilityRspBO contractInfoBo, XwglRuleGetNoauthDetailRspBo expRuleRspBo, String url) {
        XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
        ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
        XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
        BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
        x.setBusinessName(contractInfoBo.getContractName());
        x.setBusinessId(contractInfoBo.getContractId() + "");
        x.setBusinessCode(contractInfoBo.getContractNo());
        x.setIsZj(Integer.valueOf(1));
        x.setBusinessUrl(url);
        x.setRulId(expRuleRspBo.getRuleId());
        x.setManagerId(contractInfoBo.getCreateUserId());
        x.setManagerName(contractInfoBo.getCreateUserName());
        x.setCompanyId(contractInfoBo.getCreateDeptId() + "");
        x.setDeptId(contractInfoBo.getCreateDeptId() + "");
        x.setCompanyName(contractInfoBo.getCreateDeptName());
        x.setDeptName(contractInfoBo.getCreateDeptName());
        xwglLogs.add(x);
        reqBo.setXwglLogs(xwglLogs);
        reqBo.setUserId(Long.valueOf(1L));
        reqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        log.debug("dealUocEvaluationTimeOutScheduledTask-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBo));
        XwgLSaveLogRspBo rspBo = this.xwglSaveLogAbilityService.saveXwglLog(reqBo);
        log.debug("dealUocEvaluationTimeOutScheduledTask-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBo));
    }

    private XwglRuleGetNoauthDetailRspBo getXwglRuleGetNoauthDetailRspBo() {
        log.debug("dealZnhtAutoOrder-\u8ba2\u5355\u4f9b\u5e94\u5546\u5931\u4fe1\u9884\u8b66\u89c4\u5219\u5f00\u59cb\u4e86");
        XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
        ruleReqBo.setRuleNo(this.orderCheckSupYjCode);
        XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
        log.debug("dealZnhtAutoOrder-\u8ba2\u5355\u4f9b\u5e94\u5546\u5931\u4fe1\u9884\u8b66\u89c4\u5219\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)expRuleRspBo));
        if (!"0000".equals(expRuleRspBo.getRespCode())) {
            throw new BusinessException(expRuleRspBo.getRespCode(), expRuleRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleManagementVariableValue()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleContent()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleName())) {
            throw new BusinessException("8888", "\u89c4\u5219\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
        }
        return expRuleRspBo;
    }

    private void dealTempItems(Long orderId, ContractItemCanBuyListQryAbilityRspBO itemCanBuyRspBO, ContractDetailQueryAbilityRspBO contractInfoBo, UocMemInfoBO userInfo, PebExtAgreementCreateOrderReqBO zoneOrderReq) {
        Date date = new Date();
        String formatDate = LocalDate.now().plusDays(30L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        PebOrderItemTepmReqBO tepmReq = (PebOrderItemTepmReqBO)JSON.parseObject((String)JSON.toJSONString((Object)userInfo), PebOrderItemTepmReqBO.class);
        tepmReq.setOrderId(orderId);
        BigDecimal totalAmount = BigDecimal.ZERO;
        zoneOrderReq.setTotalAmount(totalAmount);
        tepmReq.setTempList(itemCanBuyRspBO.getRows().stream().map(x -> {
            UocOrdGoodsTempBO tempBO = new UocOrdGoodsTempBO();
            tempBO.setArrivalTime(formatDate);
            tempBO.setArrivalTimeStr(formatDate);
            tempBO.setCateCode(x.getCatalogCode());
            tempBO.setCateName(x.getCatalogName());
            tempBO.setCreateOperId(contractInfoBo.getCreateUserId() + "");
            tempBO.setCreateTime(date);
            tempBO.setExt8(x.getMaterialName());
            tempBO.setHtId(contractInfoBo.getContractId() + "");
            tempBO.setHtItemId(x.getItemId());
            tempBO.setMaterialId(x.getMaterialId());
            tempBO.setMaterialUnitName(x.getUnitName());
            tempBO.setModel(x.getModel());
            BigDecimal rate = BigDecimal.valueOf(x.getRate().intValue()).divide(BigDecimal.valueOf(100L)).add(BigDecimal.ONE);
            tempBO.setNakePrice(x.getTaxUnitPrice().divide(rate, 8, 1));
            tempBO.setOrderId(orderId);
            tempBO.setPurchaseCount(x.getCanSaleNum());
            tempBO.setSalePrice(x.getTaxUnitPrice());
            tempBO.setSkuMaterialId(x.getMaterialCode());
            tempBO.setSkuMaterialName(x.getMaterialDesc());
            tempBO.setSkuSupplierId(x.getSupplierId());
            tempBO.setSkuSupplierName(x.getSupplierName());
            tempBO.setSpec(x.getSpec());
            tempBO.setSupplier(x.getSupplierId() + "");
            tempBO.setSupplierShopId(x.getSupplierId());
            tempBO.setTax(Long.valueOf(x.getRate().longValue()));
            tempBO.setTotalNakePrice(tempBO.getNakePrice().multiply(tempBO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP));
            tempBO.setTotalSalePrice(tempBO.getSalePrice().multiply(tempBO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP));
            tempBO.setTaxPrice(tempBO.getTotalSalePrice().subtract(tempBO.getTotalNakePrice()));
            tempBO.setUnitName(x.getUnitName());
            zoneOrderReq.setTotalAmount(zoneOrderReq.getTotalAmount().add(tempBO.getTotalSalePrice()));
            return tempBO;
        }).collect(Collectors.toList()));
        PebOrderItemTepmRspBO pebOrderItemTepmRspBO = this.pebOrderItemTempBusiService.dealCreate(tepmReq);
        if (!"0000".equals(pebOrderItemTepmRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u521b\u5efa\u5408\u540c\u8ba2\u5355\u4e34\u65f6\u660e\u7ec6\u5931\u8d25\uff1a" + itemCanBuyRspBO.getRespDesc());
        }
    }

    private void dealParam(PebExtAgreementCreateOrderReqBO zoneOrderReq, ContractDetailQueryAbilityRspBO contractInfoBo) {
        zoneOrderReq.setSubmit("1");
        zoneOrderReq.setPurUserNo(this.purUserNo);
        zoneOrderReq.setCurrency("CNY");
        zoneOrderReq.setAdjustType("\u4ee5\uff08\u542b\u7a0e\uff09\u5355\u4ef7\u4e3a\u57fa\u51c6\u8c03\u6574");
        zoneOrderReq.setAcquirer(contractInfoBo.getAcceptOrgName());
        zoneOrderReq.setAcquirerId(contractInfoBo.getAcceptOrgId());
        zoneOrderReq.setConsignee(contractInfoBo.getConsigneeOrgName());
        zoneOrderReq.setConsigneeId(contractInfoBo.getConsigneeOrgId());
        zoneOrderReq.setMaterialCategory("\u670d\u52a1");
        zoneOrderReq.setOrigin("1");
        zoneOrderReq.setIsPushErp(Integer.valueOf(0));
        zoneOrderReq.setIsTax(Integer.valueOf(1));
        zoneOrderReq.setPurType(contractInfoBo.getPurchaseTypeStr());
        zoneOrderReq.setBuynerNo(contractInfoBo.getBuyerNo());
        zoneOrderReq.setBuynerName(contractInfoBo.getBuyerName());
        zoneOrderReq.setBuynerErpNo(contractInfoBo.getBuynerErpNo());
        zoneOrderReq.setIsHt(Integer.valueOf(1));
        zoneOrderReq.setTatleTransportationFee(BigDecimal.ZERO);
        zoneOrderReq.setAddrJc(contractInfoBo.getSupplierAddressAlias());
        if (!StringUtils.isEmpty((Object)contractInfoBo.getSupplierAddressAlias())) {
            zoneOrderReq.setVendorSiteId(Long.valueOf(Long.parseLong(contractInfoBo.getSupplierAddressAliasId())));
        }
        zoneOrderReq.setVendorSiteName(contractInfoBo.getSupplierAddressAlias());
        PebOrderAuditInfoBO auditInfoBO = new PebOrderAuditInfoBO();
        auditInfoBO.setType("M001102");
        auditInfoBO.setProcKey(this.procKey);
        zoneOrderReq.setAuditInfo(Stream.of(auditInfoBO).collect(Collectors.toList()));
        UmcLogisticsRelaAbilitReqBO logisticsRelaAbilitReqBO = new UmcLogisticsRelaAbilitReqBO();
        logisticsRelaAbilitReqBO.setContactId(this.contactId);
        logisticsRelaAbilitReqBO.setOperType("5");
        UmcLogisticsRelaAbilityRspBO umcLogisticsRelaAbilityRspBO = this.umcLogisticsRelaAbilityService.operLogisticsRela(logisticsRelaAbilitReqBO);
        log.info("umcLogisticsRelaAbilityRspBO\uff0c\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)umcLogisticsRelaAbilityRspBO));
        if (!CollectionUtils.isEmpty((Collection)umcLogisticsRelaAbilityRspBO.getRows())) {
            LogisticsRelaAbilityBO logisticsRelaAbilityBO = (LogisticsRelaAbilityBO)umcLogisticsRelaAbilityRspBO.getRows().get(0);
            PebExtAddressInfoIntfceReqBO addressInfo = new PebExtAddressInfoIntfceReqBO();
            addressInfo.setReceiverCountryId(logisticsRelaAbilityBO.getContactCountryId());
            addressInfo.setReceiverCountryName(logisticsRelaAbilityBO.getContactCountryName());
            addressInfo.setReceiverProvinceId(logisticsRelaAbilityBO.getContactProvinceId());
            addressInfo.setReceiverProvinceName(logisticsRelaAbilityBO.getContactProvinceName());
            addressInfo.setReceiverCityId(logisticsRelaAbilityBO.getContactCityId());
            addressInfo.setReceiverCityName(logisticsRelaAbilityBO.getContactCityName());
            addressInfo.setReceiverCountyId(logisticsRelaAbilityBO.getContactCountyId());
            addressInfo.setReceiverCountyName(logisticsRelaAbilityBO.getContactCountyName());
            addressInfo.setReceiverTownId(logisticsRelaAbilityBO.getContactTownId());
            addressInfo.setReceiverTown(logisticsRelaAbilityBO.getContactTown());
            addressInfo.setReceiverAddress(logisticsRelaAbilityBO.getContactAddress());
            addressInfo.setReceiverCompany(logisticsRelaAbilityBO.getContactCompany());
            addressInfo.setReceiverName(logisticsRelaAbilityBO.getContactName());
            addressInfo.setReceiverFixPhone(logisticsRelaAbilityBO.getContactFixPhone());
            addressInfo.setReceiverMobileNumber(logisticsRelaAbilityBO.getContactMobile());
            addressInfo.setReceiverEmail(logisticsRelaAbilityBO.getContactEmail());
            zoneOrderReq.setAddressInfo(addressInfo);
        }
    }

    private UocMemInfoBO dealUserInfo(Long userId) {
        UmcQryMemInfoByUserIdAbilityReqBO abilityReqBO = new UmcQryMemInfoByUserIdAbilityReqBO();
        abilityReqBO.setUserIdWeb(userId);
        UmcQryMemInfoByUserIdAbilityRspBO rspUser = this.umcQryMemIdByUserIdAbilityService.qryMemInfoByUserId(abilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)rspUser));
        if (!"0000".equals(rspUser.getRespCode())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + rspUser.getRespDesc());
        }
        UocMemInfoBO userInfo = (UocMemInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)rspUser), UocMemInfoBO.class);
        userInfo.setNeedResetPwd(rspUser.getNeedResetPwd());
        userInfo.setUserId(rspUser.getUserId());
        userInfo.setName(rspUser.getMemName2());
        userInfo.setCompanyIdExt(userInfo.getCompanyId());
        userInfo.setMgOrgIdsExt(rspUser.getMgOrgIds());
        userInfo.setMemIdIn(rspUser.getMemId());
        userInfo.setOrgIdIn(userInfo.getOrgId());
        userInfo.setOrgCodeIn(rspUser.getOrgCode());
        userInfo.setUserIdIn(userInfo.getUserId());
        userInfo.setMemAffiliationExt(userInfo.getMemAffiliation());
        userInfo.setMemIdExt(rspUser.getMemId());
        userInfo.setSupSaleOrgList(JSON.parseArray((String)JSON.toJSONString((Object)rspUser.getSupSaleOrgList()), UocSupSaleOrgBO.class));
        userInfo.setIsprofess(rspUser.getIsprofess());
        userInfo.setSex(rspUser.getSex());
        userInfo.setRegEmail(rspUser.getRegEmail());
        userInfo.setPsDiscountRate(rspUser.getPsDiscountRate());
        userInfo.setOrgLevelIn(rspUser.getOrgLevel());
        userInfo.setUmcStationsListWebExt(JSON.parseArray((String)JSON.toJSONString((Object)rspUser.getUmcStationsListWeb()), UocStationWebBO.class));
        userInfo.setUsername(rspUser.getRegAccount());
        userInfo.setOrgId(rspUser.getOrgId());
        userInfo.setOrgCodeIn(rspUser.getOrgCode());
        userInfo.setCellphone(rspUser.getRegMobile());
        userInfo.setOrgTypeIn(rspUser.getOrgType());
        userInfo.setOrgPath(rspUser.getOrgTreePath());
        userInfo.setOrgName(rspUser.getOrgName());
        userInfo.setOldMemIdIn(rspUser.getOldMemIdIn());
        userInfo.setMemUserType(rspUser.getUserType());
        userInfo.setIntExtPropertyCook(rspUser.getIntExtPropertyCook());
        userInfo.setTradeCapacityCook(rspUser.getTradeCapacityCook());
        userInfo.setTradeUserTypeCook(rspUser.getTradeUserTypeCook());
        userInfo.setTradeUserTypeSelectCook(rspUser.getTradeUserTypeSelectCook());
        userInfo.setOrgClass(rspUser.getOrgClass());
        userInfo.setManualDeal(rspUser.getManualDeal());
        userInfo.setImportErp(rspUser.getImportErp());
        userInfo.setAutoPush(rspUser.getAutoPush());
        userInfo.setTaxInclude(rspUser.getTaxInclude());
        userInfo.setErpPlan(rspUser.getErpPlan());
        userInfo.setMatchSwitch(rspUser.getMatchSwitch());
        userInfo.setSupplierSource(rspUser.getSupplierSource());
        userInfo.setAccessStatus(rspUser.getAccessStatus());
        userInfo.setAuditStatus(rspUser.getAuditStatus());
        userInfo.setAuditMsg(rspUser.getAuditMsg());
        userInfo.setErpOrgCode(rspUser.getErpOrgCode());
        userInfo.setDiffUserType(rspUser.getDiffUserType());
        userInfo.setModifyNotificationFlag(rspUser.getModifyNotificationFlag());
        Long adminId = 1L;
        if (adminId.equals(rspUser.getMemId())) {
            ArrayList<Long> mgOrgIds = new ArrayList<Long>();
            mgOrgIds.add(1L);
            userInfo.setMgOrgIdsExt(mgOrgIds);
        }
        ArrayList<String> outerUserTypes = new ArrayList<String>();
        if ("2".equals(rspUser.getIsProfessionalOrgExt())) {
            if (null != rspUser.getIsBranchUnit() && 1 == rspUser.getIsBranchUnit()) {
                outerUserTypes.add("6");
            } else {
                outerUserTypes.add("5");
            }
        } else {
            outerUserTypes.add(rspUser.getUserType());
        }
        userInfo.setOuterUserTypes(outerUserTypes);
        userInfo.setBlackStatus(rspUser.getBlackStatus());
        userInfo.setCreditNo(rspUser.getCreditNo());
        return userInfo;
    }

    @PostMapping(value={"queryZnhtByInspectionOrderId"})
    public PebZnhtAutoOrderAbilityRspBO queryZnhtByInspectionOrderId(@RequestBody PebZnhtAutoOrderAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getInspectionOrderIdList())) {
            throw new UocProBusinessException("8888", "\u9a8c\u6536\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.uocOrderRelItemMapper.queryByInspectionOrderIdZnht(reqBO.getInspectionOrderIdList());
        PebZnhtAutoOrderAbilityRspBO rsBo = new PebZnhtAutoOrderAbilityRspBO();
        rsBo.setRespCode("0000");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            rsBo.setBos(JSON.parseArray((String)JSON.toJSONString((Object)list), UocOrderRelItemBo.class));
        }
        return rsBo;
    }
}

