/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.utils.BhDycAuthUtil;
import com.tydic.uoc.dao.UocBhOrderSyncFailLogMapper;
import com.tydic.uoc.dao.UocBhOrderSyncLogMapper;
import com.tydic.uoc.po.UocBhOrderSyncFailLogPO;
import com.tydic.uoc.po.UocBhOrderSyncLogPO;
import com.tydic.uoc.zone.atom.api.PebBHOrderPushPlanAtomService;
import com.tydic.uoc.zone.atom.bo.PebBHOrderPushPlanAtomReqBO;
import com.tydic.uoc.zone.atom.bo.PebBHOrderPushPlanAtomRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebBHOrderPushPlanAtomServiceImpl
implements PebBHOrderPushPlanAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebBHOrderPushPlanAtomServiceImpl.class);
    @Value(value="${BH_ORDER_PUSH_PLAN_URL:http://172.20.175.51:8080/api/plan/plan/bpm/updateRepOrder}")
    private String bHOrderPushPlanUrl;
    @Autowired
    private UocBhOrderSyncFailLogMapper uocBhOrderSyncFailLogMapper;
    @Autowired
    private UocBhOrderSyncLogMapper uocBhOrderSyncLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Value(value="${AMJ_APP_KEY:65141CCB3D46C2438D2B565239BD36B4}")
    private String amjAppKey;
    @Value(value="${AMJ_APP_SECRET:2a82b690ffb011ef89e4347379910188}")
    private String amjAppSecret;
    @Value(value="${BH_ORDER_PUSH_PLAN_SHORT_URL:/plan/plan/bpm/updateRepOrder}")
    private String bHOrderPushPlanShortUrl;

    @Override
    public PebBHOrderPushPlanAtomRspBO dealBHOrderPushPlan(PebBHOrderPushPlanAtomReqBO reqBO) {
        PebBHOrderPushPlanAtomRspBO rspBO = new PebBHOrderPushPlanAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Date time = new Date();
        UocBhOrderSyncLogPO uocContractSyncLogPO = new UocBhOrderSyncLogPO();
        uocContractSyncLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
        uocContractSyncLogPO.setCreateTime(time);
        uocContractSyncLogPO.setType(UocConstant.ContractPushType.CONFIRM);
        uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.SUCCESS);
        uocContractSyncLogPO.setUrl(this.bHOrderPushPlanUrl);
        uocContractSyncLogPO.setObjId(reqBO.getOrderId());
        String reqStr = JSONObject.toJSONString((Object)reqBO.getAtomBO());
        rspBO.setReqStr(reqStr);
        uocContractSyncLogPO.setReqStr(reqStr);
        String strResult = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Header[] headers = new Header[5];
            Date date = new Date();
            headers[0] = new BasicHeader("requestrime", simpleDateFormat.format(date));
            headers[1] = new BasicHeader("appKey", this.amjAppKey);
            headers[2] = new BasicHeader("Content-Type", "application/json;charset=UTF-8");
            headers[3] = new BasicHeader("appSecret", this.amjAppSecret);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("appKey", this.amjAppKey);
            param.put("requestrime", simpleDateFormat.format(date));
            String sign = BhDycAuthUtil.sign((String)this.amjAppSecret, (String)this.bHOrderPushPlanShortUrl, param);
            headers[4] = new BasicHeader("authsignature", sign);
            log.error("\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u8bf7\u6c42\u5934\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)headers));
            log.info("\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u5165\u53c2\uff1a" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.bHOrderPushPlanUrl), (Header[])headers, (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u8ba1\u5212\u5e73\u53f0\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.bHOrderPushPlanUrl + "]");
            }
            strResult = httpRetBean.getStr();
            log.info("\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u51fa\u53c2\uff1a" + strResult);
            rspBO.setRspStr(strResult);
            uocContractSyncLogPO.setRspStr(strResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
            uocContractSyncLogPO.setRspStr(e.getMessage());
            this.insertPushLog(uocContractSyncLogPO);
            this.insertFailLog(uocContractSyncLogPO);
            log.error("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u5f02\u5e38 {}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u5f02\u5e38" + e.getMessage());
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)strResult)) {
            uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
            this.insertPushLog(uocContractSyncLogPO);
            this.insertFailLog(uocContractSyncLogPO);
            log.error("\u8c03\u7528\u53d1\u8d27\u5355\u63a8\u9001\u5f02\u5e38\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a:");
            return rspBO;
        }
        try {
            PebExtUnifySettleEncryptionAbilityRspBO rspResultBO = (PebExtUnifySettleEncryptionAbilityRspBO)JSONObject.parseObject((String)strResult, PebExtUnifySettleEncryptionAbilityRspBO.class);
            if ("200".equals(rspResultBO.getCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.SUCCESS);
                this.insertPushLog(uocContractSyncLogPO);
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspResultBO.getMsg());
                uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
                this.insertPushLog(uocContractSyncLogPO);
                this.insertFailLog(uocContractSyncLogPO);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
            this.insertPushLog(uocContractSyncLogPO);
            this.insertFailLog(uocContractSyncLogPO);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u89e3\u6790\u66f4\u65b0\u8865\u8d27\u5355\u53f7\u63a8\u9001\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
        }
        return rspBO;
    }

    private void insertPushLog(UocBhOrderSyncLogPO uocContractSyncLogPO) {
        this.uocBhOrderSyncLogMapper.insert(uocContractSyncLogPO);
    }

    private void insertFailLog(UocBhOrderSyncLogPO uocContractSyncLogPO) {
        UocBhOrderSyncFailLogPO failLogPO = (UocBhOrderSyncFailLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)uocContractSyncLogPO), UocBhOrderSyncFailLogPO.class);
        failLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
        this.uocBhOrderSyncFailLogMapper.insert(failLogPO);
    }
}

