package com.tydic.dyc.pro.base.utils.esb;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * @Author yuhao
 * @Date 2025/5/20 11:01
 * @Description:调用能力平台工具
 **/

public class DycProBaseCallEsbUtil {

    /**
     * 获取电商商品价格信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuPriceForJd(DycProBaseCallEsbUtilGetSkuPriceForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuPriceForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuPriceForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品价格信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuPriceForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuPriceForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品图片信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuImageForJdRspBO getSkuImageForJd(DycProBaseCallEsbUtilGetSkuImageForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuImageForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuImageForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品图片信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuImageForJdResultBO> result = resultJsonObj.getJSONObject("result").getJSONArray(reqBO.getSku()).toJavaList(DycProBaseCallEsbUtilGetSkuImageForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品详细信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuDetailForJdRspBO getSkuDetailForJd(DycProBaseCallEsbUtilGetSkuDetailForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuDetailForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuDetailForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetSkuDetailForJdResultBO result = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetSkuDetailForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取商品上下架状态(京东)
     */
    public static DycProBaseCallEsbUtilGetSkuStateForJdRspBO getSkuStateForJd(DycProBaseCallEsbUtilGetSkuStateForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuStateForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuStateForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuStateForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuStateForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 通过区域名称获取地址库编码(京东)
     */
    public static DycProBaseCallEsbUtilGetJdAdressRspBO getJdAdress(DycProBaseCallEsbUtilGetJdAdressReqBO reqBO){
        DycProBaseCallEsbUtilGetJdAdressRspBO rspBO = new DycProBaseCallEsbUtilGetJdAdressRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject object = resultJsonObj.getJSONObject("result");
            DycProBaseCallEsbUtilGetJdAdressResultBO result = JSON.parseObject(JSON.toJSONString(object), DycProBaseCallEsbUtilGetJdAdressResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品区域购买限制信息（京东）
     */
    public static DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO getCheckAreaLimitForJd(DycProBaseCallEsbUtilGetCheckAreaLimitForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO rspBO = new DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品区域购买限制信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetCheckAreaLimitForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckAreaLimitForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品可售信息（京东）
     */
    public static DycProBaseCallEsbUtilGetCheckForJdRspBO getCheckForJd(DycProBaseCallEsbUtilGetCheckForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckForJdRspBO rspBO = new DycProBaseCallEsbUtilGetCheckForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetCheckForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品预计送达时间信息（京东Iop）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO getPromiseTipsForJdIop(DycProBaseCallEsbUtilGetPromiseTipsForJdIopReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            rspBO.setResult(resultJsonObj.getString("result"));
        }
        return rspBO;
    }

    /**
     * 获取电商商品预计送达时间信息（京东Vop）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO getPromiseTipsForJdVop(DycProBaseCallEsbUtilGetPromiseTipsForJdVopReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetPromiseTipsForJdVopResultBO resultBO = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetPromiseTipsForJdVopResultBO.class);
            rspBO.setResult(resultBO);
        }
        return rspBO;
    }

    /**
     * 获取电商商品库存信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetStockForJdRspBO getStockForJd(DycProBaseCallEsbUtilGetStockForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetStockForJdRspBO rspBO = new DycProBaseCallEsbUtilGetStockForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetStockForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetStockForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取商品上下架状态(非京东)
     */
    public static DycProBaseCallEsbUtilGetSkuStateRspBO getSkuState(DycProBaseCallEsbUtilGetSkuStateReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuStateRspBO rspBO = new DycProBaseCallEsbUtilGetSkuStateRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuStateResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuStateResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品详细信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuDetailRspBO getSkuDetail(DycProBaseCallEsbUtilGetSkuDetailReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuDetailRspBO rspBO = new DycProBaseCallEsbUtilGetSkuDetailRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetSkuDetailResultBO result = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetSkuDetailResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品图片信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuImageRspBO getSkuImage(DycProBaseCallEsbUtilGetSkuImageReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuImageRspBO rspBO = new DycProBaseCallEsbUtilGetSkuImageRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品图片信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuImageResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuImageResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品价格信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuPrice(DycProBaseCallEsbUtilGetSkuPriceReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuPriceRspBO rspBO = new DycProBaseCallEsbUtilGetSkuPriceRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品价格信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuPriceResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuPriceResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品区域购买限制信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetCheckAreaLimitRspBO getCheckAreaLimit(DycProBaseCallEsbUtilGetCheckAreaLimitReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckAreaLimitRspBO rspBO = new DycProBaseCallEsbUtilGetCheckAreaLimitRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品区域购买限制信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetCheckAreaLimitResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckAreaLimitResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品可售信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetCheckRspBO getCheck(DycProBaseCallEsbUtilGetCheckReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckRspBO rspBO = new DycProBaseCallEsbUtilGetCheckRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetCheckResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品库存信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetStockRspBO getStock(DycProBaseCallEsbUtilGetStockReqBO reqBO){
        DycProBaseCallEsbUtilGetStockRspBO rspBO = new DycProBaseCallEsbUtilGetStockRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetStockResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetStockResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品预计送达时间信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsRspBO getPromiseTips(DycProBaseCallEsbUtilGetPromiseTipsReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialnumber(getSerialNumber(timeStamp));
        String resultStr = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            rspBO.setResult(result.getString("tips"));
        }
        return rspBO;
    }

    private static String getSerialNumber(long timeStamp){
        int min = 1000;
        int max = 9999;
        Random random = new Random();
        int resultInt = random.nextInt(max) % (max - min + 1) + min;
        return "DMC_PRO" + timeStamp + resultInt;
    }
}
