/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.common.communal.api.ComUocFileUploadAppService;
import com.tydic.dyc.common.communal.bo.ComUocFileAppBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppReqBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.common.communal.api.ComUocFileUploadAppService"})
public class ComUocFileUploadAppServiceImpl
implements ComUocFileUploadAppService {
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    @PostMapping(value={"upload"})
    public ComUocFileUploadAppRspBO upload(@RequestBody ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            String fileUrl;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = UUID.randomUUID().toString().replaceAll("-", "") + file.getFileType();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }
}

