/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.common.communal.api.PesappCommonBatchDownloadService;
import com.tydic.dyc.common.communal.bo.PesappCommonAttachmentInfoBO;
import com.tydic.dyc.common.communal.bo.PesappCommonBatchDownloadReqBO;
import com.tydic.dyc.common.communal.bo.PesappCommonBatchDownloadRspBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.common.communal.api.PesappCommonBatchDownloadService"})
public class PesappCommonBatchDownloadServiceImpl
implements PesappCommonBatchDownloadService {
    private static final Logger log = LoggerFactory.getLogger(PesappCommonBatchDownloadServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${fastdfs.removePort:true}")
    private boolean fastdfsRemovePort;

    @PostMapping(value={"batchDownload"})
    public PesappCommonBatchDownloadRspBO batchDownload(@RequestBody PesappCommonBatchDownloadReqBO reqBO) {
        log.info("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f7d\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        PesappCommonBatchDownloadRspBO rspBO = new PesappCommonBatchDownloadRspBO();
        URL rootPath = PesappCommonBatchDownloadServiceImpl.class.getResource("/");
        String rootPathStr = rootPath.getPath() + "temp" + System.currentTimeMillis();
        File directoryFile = new File(rootPathStr);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        if (reqBO.getBatchFile() != null) {
            for (PesappCommonAttachmentInfoBO attachmentInfoBO : reqBO.getBatchFile()) {
                String url = attachmentInfoBO.getAttachmentAddr();
                if ("FASTDFS".equals(this.fileType)) {
                    for (int i = 0; i < 3; ++i) {
                        url = url.substring(url.indexOf("/") + 1);
                    }
                    url = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + url;
                }
                log.info("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u66ff\u6362\uff1a" + url);
                HttpGet httpGet = new HttpGet(url);
                CloseableHttpResponse response = null;
                InputStream content = null;
                FileOutputStream fileOutputStream = null;
                try {
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        int len;
                        HttpEntity responseEntity = response.getEntity();
                        File downloadFile = new File(rootPathStr + "/" + attachmentInfoBO.getAttachmentName());
                        content = responseEntity.getContent();
                        fileOutputStream = new FileOutputStream(downloadFile);
                        byte[] buff = new byte[1024];
                        while ((len = content.read(buff)) != -1) {
                            fileOutputStream.write(buff, 0, len);
                        }
                        fileOutputStream.flush();
                        continue;
                    }
                    throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u8fd4\u56de\u5931\u8d25\uff01");
                }
                catch (IOException e) {
                    throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u5931\u8d25\uff01");
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (response == null) continue;
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            String fileUrl;
            String zipFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".zip";
            File zipFile = new File(rootPathStr + "/" + zipFileName);
            this.generateZipFile(directoryFile.listFiles(), zipFile);
            FileInputStream inputStream = new FileInputStream(zipFile);
            String path = this.fileClient.uploadFileByInputStream(PATH, zipFileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                fileUrl = "";
            }
            rspBO.setCompressFileUrl(fileUrl);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u538b\u7f29\u4e0a\u4f20\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
        }
        finally {
            this.deleteTempFile(directoryFile);
        }
        return rspBO;
    }

    private boolean deleteTempFile(File file) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                int subFileCount = subFiles.length;
                int deleteFileCount = 0;
                for (File subFile : subFiles) {
                    if (!subFile.delete()) continue;
                    ++deleteFileCount;
                }
                if (subFileCount == deleteFileCount) {
                    return file.delete();
                }
                return false;
            }
            return file.delete();
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateZipFile(File[] subFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    int len;
                    fileInputStream = new FileInputStream(subFile);
                    zipEntry = new ZipEntry(subFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buff = new byte[1024];
                    while ((len = fileInputStream.read(buff)) != -1) {
                        zipOutputStream.write(buff, 0, len);
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u538b\u7f29\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
            }
        }
    }
}

