/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.ComHttpUtil;
import com.tydic.dyc.common.communal.api.ComGeminiInnerMessageQryService;
import com.tydic.dyc.common.communal.bo.ComGeminiInnerMessageDataBO;
import com.tydic.dyc.common.communal.bo.ComGeminiInnerMessageQryReqBO;
import com.tydic.dyc.common.communal.bo.ComGeminiInnerMessageQryRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.common.communal.api.ComGeminiInnerMessageQryService"})
public class ComGeminiInnerMessageQryServiceImpl
implements ComGeminiInnerMessageQryService {
    private static final Logger log = LoggerFactory.getLogger(ComGeminiInnerMessageQryServiceImpl.class);
    @Value(value="${gemini.host:127.0.0.1:10240}")
    private String geminiHost;
    @Value(value="${gemini.inner.page.url:/gemini/innerMessage/qryInnerMessagePageList}")
    private String geminiInnerPageQryUrl;

    @PostMapping(value={"qryInnerMessage"})
    public ComGeminiInnerMessageQryRspBO qryInnerMessage(@RequestBody ComGeminiInnerMessageQryReqBO reqBO) {
        String result;
        ComGeminiInnerMessageQryRspBO rspBO = new ComGeminiInnerMessageQryRspBO();
        JSONObject paramJson = new JSONObject();
        if (!StringUtils.isEmpty((Object)reqBO.getStatus())) {
            paramJson.put("status", (Object)reqBO.getStatus());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUserId())) {
            paramJson.put("userId", (Object)reqBO.getUserId());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUserName())) {
            paramJson.put("userName", (Object)reqBO.getUserName());
        }
        paramJson.put("pageNo", (Object)reqBO.getPageNo());
        paramJson.put("pageSize", (Object)reqBO.getPageSize());
        String url = this.geminiHost + this.geminiInnerPageQryUrl;
        try {
            log.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)url, (Object)paramJson);
            result = ComHttpUtil.sendPost((String)url, (String)paramJson.toJSONString());
            log.info("\u901a\u77e5\u4e2d\u5fc3\u8fd4\u56de\uff1a" + result);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u67e5\u8be2\u7ad9\u5185\u4fe1\u5217\u8868\u5f02\u5e38" + e);
        }
        if (StringUtils.isEmpty((Object)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        rspBO.setCode(resultJson.getString("respCode"));
        rspBO.setMessage(resultJson.getString("respDesc"));
        if (!"0000".equals(rspBO.getCode())) {
            return rspBO;
        }
        rspBO.setRows(JSON.parseArray((String)resultJson.getJSONObject("data").getString("rows"), ComGeminiInnerMessageDataBO.class));
        rspBO.setPageNo(resultJson.getJSONObject("data").getInteger("pageNo").intValue());
        rspBO.setRecordsTotal(resultJson.getJSONObject("data").getInteger("recordsTotal").intValue());
        rspBO.setTotal(resultJson.getJSONObject("data").getInteger("total").intValue());
        return rspBO;
    }
}

