/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.plan.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.plan.api.DycPlanOrgConfigUpdateService;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigDetailsBO;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigUpdateReqBO;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigUpdateRspBO;
import com.tydic.ppc.ability.api.PpcPlanOrgConfigUpdateAbilityService;
import com.tydic.ppc.ability.bo.PpcPlanOrgConfigUpdateAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPlanOrgConfigUpdateAbilityRspBO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.plan.api.DycPlanOrgConfigUpdateService"})
public class DycPlanOrgConfigUpdateServiceImpl
implements DycPlanOrgConfigUpdateService {
    private static final Logger log = LoggerFactory.getLogger(DycPlanOrgConfigUpdateServiceImpl.class);
    @Autowired
    private PpcPlanOrgConfigUpdateAbilityService ppcPlanOrgConfigUpdateAbilityService;

    @PostMapping(value={"updatePlanOrgConfig"})
    public DycPlanOrgConfigUpdateRspBO updatePlanOrgConfig(@RequestBody DycPlanOrgConfigUpdateReqBO reqBo) {
        this.validators(reqBo);
        String json = JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        PpcPlanOrgConfigUpdateAbilityReqBO abilityReqBo = (PpcPlanOrgConfigUpdateAbilityReqBO)JSONObject.parseObject((String)json, PpcPlanOrgConfigUpdateAbilityReqBO.class);
        PpcPlanOrgConfigUpdateAbilityRspBO result = this.ppcPlanOrgConfigUpdateAbilityService.updatePlanOrgConfig(abilityReqBo);
        if (!"0000".equals(result.getRespCode())) {
            throw new ZTBusinessException(result.getRespDesc());
        }
        DycPlanOrgConfigUpdateRspBO rspBo = new DycPlanOrgConfigUpdateRspBO();
        rspBo.setCode("0000");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void validators(DycPlanOrgConfigUpdateReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getId() == null) {
            throw new ZTBusinessException("\u5165\u53c2 Id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrgId() == null) {
            throw new ZTBusinessException("\u5165\u53c2 OrgId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrgName() == null) {
            throw new ZTBusinessException("\u5165\u53c2 OrgName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPlanOrgConfigDetailsBo())) {
            throw new ZTBusinessException("\u5165\u53c2PlanOrgConfigDetailsBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycPlanOrgConfigDetailsBO bo : reqBO.getPlanOrgConfigDetailsBo()) {
            if (bo.getCompanyIdReq() == null) {
                throw new ZTBusinessException("\u5165\u53c2 CompanyId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getCompanyNameReq() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2 CompanyName \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

