/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.encoded.CfcEncodedRuleQryDetailAbilityService;
import com.tydic.cfc.ability.encoded.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.EncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.EncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.EncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.EncodedSerialPO;
import com.tydic.plugin.encoded.exception.EncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="encodedSerialGetService")
public class EncodedSerialGetServiceImpl
implements EncodedSerialGetService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSerialGetServiceImpl.class);
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedRuleQryDetailAbilityService cfcEncodedRuleQryDetailAbilityService;
    @Autowired
    private EncodedSerialMapper encodedSerialMapper;
    @Autowired
    private EncodedSerialGenerateMapper encodedSerialGenerateMapper;
    @Resource
    private CacheClient cacheService;
    private static final String CHANGE_ENCODED = "change_encoded";

    @Override
    @Transactional
    public EncodedSerialGetServiceRspBO getEncodedSerial(EncodedSerialGetServiceReqBO reqBO) {
        EncodedSerialGetServiceRspBO rspBO = new EncodedSerialGetServiceRspBO();
        EncodedSerialServiceRspBO encodedSerialServiceRspBO = this.getSerial(reqBO);
        rspBO.setSerialNoList(encodedSerialServiceRspBO.getSerialNoList());
        return rspBO;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public EncodedSerialServiceRspBO getSerial(EncodedSerialGetServiceReqBO reqBO) {
        void var11_21;
        int i;
        EncodedSerialServiceRspBO rspBO = new EncodedSerialServiceRspBO();
        this.validParam(reqBO);
        Map<Long, Integer> restartMap = this.changeValid(reqBO);
        EncodedSerialPO esParam = new EncodedSerialPO();
        esParam.setCenter(reqBO.getCenter());
        esParam.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        esParam.setEffFlag("1");
        List<EncodedSerialPO> encodedSerialPOS = this.encodedSerialMapper.getList(esParam);
        ArrayList<EncodedSerialPO> effList = new ArrayList<EncodedSerialPO>();
        ArrayList<String> serialNoList = new ArrayList<String>();
        EncodedSerialPO encodedSerialPO = null;
        if (encodedSerialPOS != null && encodedSerialPOS.size() > 0) {
            for (EncodedSerialPO encodedSerialPO2 : encodedSerialPOS) {
                String string = this.composeEffDate(encodedSerialPO2);
                if (string == null || !"".equals(string) && !string.equals(encodedSerialPO2.getEffDate())) continue;
                effList.add(encodedSerialPO2);
            }
        }
        if (effList.size() < 1) {
            effList.addAll(this.saveEncodedSerialPO(esParam));
        }
        int extendLength = -1;
        for (EncodedSerialPO encodedSerialPO3 : effList) {
            if (StringUtils.isBlank((CharSequence)reqBO.getRelId())) {
                if (!StringUtils.isBlank((CharSequence)encodedSerialPO3.getRelId())) continue;
                encodedSerialPO = encodedSerialPO3;
                break;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRelType())) {
                reqBO.setRelType("org");
            }
            if (StringUtils.isBlank((CharSequence)encodedSerialPO3.getRelId())) {
                if (encodedSerialPO != null) continue;
                encodedSerialPO = encodedSerialPO3;
                continue;
            }
            if ("1".equals(reqBO.getExtendFlag())) {
                if (!reqBO.getRelId().contains(encodedSerialPO3.getRelId()) || !reqBO.getRelType().equals(encodedSerialPO3.getRelType())) continue;
                String[] ids = reqBO.getRelId().split("-");
                for (int i2 = 0; i2 < ids.length; ++i2) {
                    if (!ids[i2].equals(encodedSerialPO3.getRelId()) || i2 <= extendLength) continue;
                    extendLength = i2;
                    encodedSerialPO = encodedSerialPO3;
                }
                continue;
            }
            if (!reqBO.getRelId().equals(encodedSerialPO3.getRelId()) || !reqBO.getRelType().equals(encodedSerialPO3.getRelType())) continue;
            encodedSerialPO = encodedSerialPO3;
            break;
        }
        EncodedSerialGeneratePO encodedSerialGeneratePO = new EncodedSerialGeneratePO();
        String string = encodedSerialPO.getEncodedSerialPrefix();
        if (reqBO.getReplaceJson() != null) {
            for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                void var11_18;
                String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                String string2 = var11_18.replaceAll(itemJsonKey, itemJson.getValue().toString());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getReplaceValue())) {
            String sp = "\\$\\{\\w+\\}";
            Pattern p = Pattern.compile(sp);
            Matcher m = p.matcher(string);
            StringBuffer sb = new StringBuffer();
            i = 0;
            while (m.find()) {
                if (i >= reqBO.getReplaceValue().size()) continue;
                String key = m.group(0);
                m.appendReplacement(sb, reqBO.getReplaceValue().get(i++));
            }
            m.appendTail(sb);
            String string3 = sb.toString();
        }
        encodedSerialGeneratePO.setSerialId(encodedSerialPO.getId());
        encodedSerialGeneratePO.setGeneratePrefix((String)var11_21);
        List<EncodedSerialGeneratePO> esgList = this.encodedSerialGenerateMapper.getList(encodedSerialGeneratePO);
        Integer num = reqBO.getNum() != null ? reqBO.getNum() : 1;
        Long esgId = null;
        if (esgList != null && esgList.size() > 0) {
            esgId = esgList.get(0).getId();
            int updateFlag = this.encodedSerialGenerateMapper.updateGenerateValue(esgId, num);
            if (updateFlag < 1) {
                throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        } else {
            esgId = Sequence.getInstance().nextId();
            encodedSerialGeneratePO.setId(esgId);
            if (restartMap.get(encodedSerialPO.getId()) != null) {
                encodedSerialGeneratePO.setGenerateValue(num + restartMap.get(encodedSerialPO.getId()));
            } else {
                encodedSerialGeneratePO.setGenerateValue(num);
            }
            int insertFlag = this.encodedSerialGenerateMapper.insert(encodedSerialGeneratePO);
            if (insertFlag < 1) {
                throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        }
        EncodedSerialGeneratePO esgPO = this.encodedSerialGenerateMapper.selectByPrimaryKey(esgId);
        for (i = num - 1; i >= 0; --i) {
            String serialNo = esgPO.getGeneratePrefix() + String.format("%0" + encodedSerialPO.getEncodedSerialDigit() + "d", esgPO.getGenerateValue() - i);
            serialNoList.add(serialNo);
        }
        rspBO.setSerialNoList(serialNoList);
        rspBO.setEncodedSerialPO(encodedSerialPO);
        rspBO.setEncodedSerialGeneratePO(esgPO);
        return rspBO;
    }

    private Map<Long, Integer> changeValid(EncodedSerialGetServiceReqBO reqBO) {
        LOGGER.info("=============\u7f16\u7801\u53d8\u66f4\u6821\u9a8c\u5f00\u59cb==============");
        HashMap<Long, Integer> restartMap = new HashMap<Long, Integer>();
        String changeRedisKey = "change_encoded_" + reqBO.getCenter();
        LOGGER.info("\u7f16\u7801\u53d8\u66f4     changeRedisKey : {}", (Object)changeRedisKey);
        HashMap<String, List<EncodedSerialPO>> map = new HashMap<String, List<EncodedSerialPO>>();
        Object changeRedisObject = this.cacheService.get(changeRedisKey);
        JSONArray jsonArray = null;
        if (changeRedisObject != null) {
            jsonArray = JSONArray.parseArray((String)changeRedisObject.toString());
            this.cacheService.delete(changeRedisKey);
        } else {
            jsonArray = new JSONArray();
        }
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
                cfcEncodedRuleQryDetailAbilityReqBO.setId(jsonObject.getLong("id"));
                CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
                if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
                    throw new EncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
                }
                CfcEncodedRuleBO cfcEncodedRuleBO = null;
                if (!CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
                    cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
                }
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     cfcEncodedRuleBO : {}", (Object)JSONObject.toJSONString(cfcEncodedRuleBO));
                List<EncodedSerialPO> encodedSerialPOS = (List<EncodedSerialPO>)map.get(cfcEncodedRuleBO.getEncodedRuleCode());
                if (CollectionUtils.isEmpty((Collection)encodedSerialPOS)) {
                    EncodedSerialPO esParam = new EncodedSerialPO();
                    esParam.setCenter(cfcEncodedRuleBO.getCenter());
                    esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
                    esParam.setEffFlag("1");
                    encodedSerialPOS = this.encodedSerialMapper.getList(esParam);
                }
                if (CollectionUtils.isEmpty((Collection)encodedSerialPOS)) continue;
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     encodedSerialPOMap : {}", (Object)JSONObject.toJSONString((Object)encodedSerialPOS));
                EncodedSerialPO insertPO = new EncodedSerialPO();
                BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
                insertPO.setId(Sequence.getInstance().nextId());
                insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
                insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
                insertPO.setEffFlag("1");
                insertPO.setEffType(cfcEncodedRuleBO.getEffType());
                insertPO.setEffDate(this.composeEffDate(insertPO));
                insertPO.setRelType(cfcEncodedRuleBO.getRelType());
                insertPO.setRelId(cfcEncodedRuleBO.getRelId());
                EncodedSerialPO restartPO = null;
                int currentValidNum = 0;
                if (!CollectionUtils.isEmpty(encodedSerialPOS)) {
                    for (EncodedSerialPO itemPO : encodedSerialPOS) {
                        String effDate;
                        int operateFlag = 0;
                        if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                            operateFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                            operateFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if ((effDate = this.composeEffDate(itemPO)) != null && ("".equals(effDate) || effDate.equals(itemPO.getEffDate()))) {
                            if ("1".equals(jsonObject.getString("restartFlag")) && operateFlag > 0) {
                                restartPO = itemPO;
                            }
                            ++currentValidNum;
                        }
                        LOGGER.info("\u7f16\u7801\u53d8\u66f4     updateInvalid : {}", (Object)operateFlag);
                    }
                }
                if (currentValidNum <= 0) continue;
                int operateFlag = this.encodedSerialMapper.insert(insertPO);
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     insert : {}", (Object)operateFlag);
                encodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), encodedSerialPOS);
                if (restartPO == null) continue;
                EncodedSerialGeneratePO esgParam = new EncodedSerialGeneratePO();
                esgParam.setSerialId(restartPO.getId());
                List<EncodedSerialGeneratePO> esgList = this.encodedSerialGenerateMapper.getList(esgParam);
                if (CollectionUtils.isEmpty(esgList) || esgList.size() != 1) continue;
                restartMap.put(insertPO.getId(), esgList.get(0).getGenerateValue());
            }
        }
        return restartMap;
    }

    private String composeEffDate(EncodedSerialPO encodedSerialPO) {
        if ("none".equals(encodedSerialPO.getEffType())) {
            return "";
        }
        if ("date".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }

    private List<EncodedSerialPO> saveEncodedSerialPO(EncodedSerialPO esPO) {
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleSelectCodeAbilityReqBo = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleSelectCodeAbilityReqBo.setCenter(esPO.getCenter());
        cfcEncodedRuleSelectCodeAbilityReqBo.setEncodedRuleCode(esPO.getEncodedRuleCode());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleSelectCodeAbilityReqBo);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new EncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        List encodedRuleList = cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList();
        ArrayList<EncodedSerialPO> addList = new ArrayList<EncodedSerialPO>();
        for (CfcEncodedRuleBO encodedRuleBO : encodedRuleList) {
            EncodedSerialPO insertPO = new EncodedSerialPO();
            BeanUtils.copyProperties((Object)esPO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(encodedRuleBO.getEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(encodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(encodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(encodedRuleBO.getRelType());
            insertPO.setRelId(encodedRuleBO.getRelId());
            addList.add(insertPO);
        }
        int insertFlag = this.encodedSerialMapper.insertBatch(addList);
        if (insertFlag < 1) {
            throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
        }
        return addList;
    }

    private void validParam(EncodedSerialGetServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
    }
}

