/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.EncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.EncodedSerialMapper;
import com.tydic.plugin.encoded.exception.EncodedPluginBusinessException;
import com.tydic.plugin.encoded.po.EncodedSerialGeneratePO;
import com.tydic.plugin.encoded.po.EncodedSerialPO;
import com.tydic.plugin.encoded.service.EncodedSerialMqSyncService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialMqSyncServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialMqSyncServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="encodedSerialMqSyncService")
public class EncodedSerialMqSyncServiceImpl
implements EncodedSerialMqSyncService {
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private EncodedSerialMapper encodedSerialMapper;
    @Autowired
    private EncodedSerialGenerateMapper encodedSerialGenerateMapper;

    @Override
    public EncodedSerialMqSyncServiceRspBO syncMqEncodedSerial(EncodedSerialMqSyncServiceReqBO reqBO) {
        this.syncMethod(reqBO);
        return new EncodedSerialMqSyncServiceRspBO();
    }

    private void syncMethod(EncodedSerialMqSyncServiceReqBO reqBO) {
        List<EncodedSerialPO> encodedSerialPOS;
        HashMap<String, List<EncodedSerialPO>> map = new HashMap<String, List<EncodedSerialPO>>();
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleQryDetailAbilityReqBO.setId(reqBO.getId());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new EncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        CfcEncodedRuleBO cfcEncodedRuleBO = null;
        if (!CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
            cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
        }
        if (CollectionUtils.isEmpty((Collection)(encodedSerialPOS = (List<EncodedSerialPO>)map.get(cfcEncodedRuleBO.getEncodedRuleCode())))) {
            EncodedSerialPO esParam = new EncodedSerialPO();
            esParam.setCenter(cfcEncodedRuleBO.getCenter());
            esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
            esParam.setEffFlag("1");
            encodedSerialPOS = this.encodedSerialMapper.getList(esParam);
        }
        if (!CollectionUtils.isEmpty((Collection)encodedSerialPOS)) {
            EncodedSerialPO insertPO = new EncodedSerialPO();
            BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(cfcEncodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(cfcEncodedRuleBO.getRelType());
            insertPO.setRelId(cfcEncodedRuleBO.getRelId());
            Boolean isInsertNewSerial = false;
            if (!CollectionUtils.isEmpty(encodedSerialPOS)) {
                for (EncodedSerialPO itemPO : encodedSerialPOS) {
                    int updateOldFlag = 0;
                    if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                        updateOldFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                    }
                    if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                        updateOldFlag = this.encodedSerialMapper.updateInvalid(itemPO.getId());
                    }
                    if (updateOldFlag <= 0) continue;
                    isInsertNewSerial = true;
                    String effDate = this.composeEffDate(itemPO);
                    if (StringUtils.isEmpty((CharSequence)effDate)) continue;
                    EncodedSerialGeneratePO esgParam = new EncodedSerialGeneratePO();
                    esgParam.setSerialId(itemPO.getId());
                    List<EncodedSerialGeneratePO> esgList = this.encodedSerialGenerateMapper.getList(esgParam);
                    if (CollectionUtils.isEmpty(esgList)) continue;
                    Integer oldGenerateSerial = esgList.get(0).getGenerateValue();
                    EncodedSerialGeneratePO newGeneratePo = new EncodedSerialGeneratePO();
                    newGeneratePo.setId(Sequence.getInstance().nextId());
                    newGeneratePo.setSerialId(insertPO.getId());
                    newGeneratePo.setGeneratePrefix(insertPO.getEncodedSerialPrefix());
                    newGeneratePo.setGenerateValue(1);
                    if (!"1".equals(reqBO.getRestartFlag()) && itemPO.getEncodedSerialPrefix().equals(insertPO.getEncodedSerialPrefix()) && itemPO.getEncodedSerialDigit().equals(insertPO.getEncodedSerialDigit())) {
                        newGeneratePo.setGenerateValue(oldGenerateSerial);
                        if (!"none".equals(effDate) && !effDate.equals(itemPO.getEffDate())) {
                            newGeneratePo.setGenerateValue(1);
                        }
                    }
                    this.encodedSerialGenerateMapper.insert(newGeneratePo);
                }
            }
            if (isInsertNewSerial.booleanValue()) {
                int operateFlag = this.encodedSerialMapper.insert(insertPO);
                encodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), encodedSerialPOS);
            }
        }
    }

    private String composeEffDate(EncodedSerialPO encodedSerialPO) {
        if ("none".equals(encodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }
}

