/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialMqSyncService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialMqSyncServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialMqSyncServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="cfcEncodedSerialMqSyncService")
public class CfcEncodedSerialMqSyncServiceImpl
implements CfcEncodedSerialMqSyncService {
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedSerialMapper cfcEncodedSerialMapper;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;

    @Override
    public CfcEncodedSerialMqSyncServiceRspBO syncMqEncodedSerial(CfcEncodedSerialMqSyncServiceReqBO reqBO) {
        this.syncMethod(reqBO);
        return new CfcEncodedSerialMqSyncServiceRspBO();
    }

    private void syncMethod(CfcEncodedSerialMqSyncServiceReqBO reqBO) {
        List<CfcEncodedSerialPO> cfcEncodedSerialPOS;
        HashMap<String, List<CfcEncodedSerialPO>> map = new HashMap<String, List<CfcEncodedSerialPO>>();
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleQryDetailAbilityReqBO.setId(reqBO.getId());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        CfcEncodedRuleBO cfcEncodedRuleBO = null;
        if (!CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
            cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
        }
        if (CollectionUtils.isEmpty((Collection)(cfcEncodedSerialPOS = (List<CfcEncodedSerialPO>)map.get(cfcEncodedRuleBO.getEncodedRuleCode())))) {
            CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
            esParam.setCenter(cfcEncodedRuleBO.getCenter());
            esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
            esParam.setEffFlag("1");
            cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
        }
        if (!CollectionUtils.isEmpty((Collection)cfcEncodedSerialPOS)) {
            CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
            BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(cfcEncodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(cfcEncodedRuleBO.getRelType());
            insertPO.setRelId(cfcEncodedRuleBO.getRelId());
            Boolean isInsertNewSerial = false;
            if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
                for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                    int updateOldFlag = 0;
                    if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                        updateOldFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                    }
                    if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                        updateOldFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                    }
                    if (updateOldFlag <= 0) continue;
                    isInsertNewSerial = true;
                    String effDate = this.composeEffDate(itemPO);
                    if (StringUtils.isEmpty((CharSequence)effDate)) continue;
                    CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
                    esgParam.setSerialId(itemPO.getId());
                    List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
                    if (CollectionUtils.isEmpty(esgList)) continue;
                    Integer oldGenerateSerial = esgList.get(0).getGenerateValue();
                    CfcEncodedSerialGeneratePO newGeneratePo = new CfcEncodedSerialGeneratePO();
                    newGeneratePo.setId(Sequence.getInstance().nextId());
                    newGeneratePo.setSerialId(insertPO.getId());
                    newGeneratePo.setGeneratePrefix(insertPO.getEncodedSerialPrefix());
                    newGeneratePo.setGenerateValue(1);
                    if (!"1".equals(reqBO.getRestartFlag()) && itemPO.getEncodedSerialPrefix().equals(insertPO.getEncodedSerialPrefix()) && itemPO.getEncodedSerialDigit().equals(insertPO.getEncodedSerialDigit())) {
                        newGeneratePo.setGenerateValue(oldGenerateSerial);
                        if (!"none".equals(effDate) && !effDate.equals(itemPO.getEffDate())) {
                            newGeneratePo.setGenerateValue(1);
                        }
                    }
                    this.cfcEncodedSerialGenerateMapper.insert(newGeneratePo);
                }
            }
            if (isInsertNewSerial.booleanValue()) {
                int operateFlag = this.cfcEncodedSerialMapper.insert(insertPO);
                cfcEncodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), cfcEncodedSerialPOS);
            }
        }
    }

    private String composeEffDate(CfcEncodedSerialPO cfcEncodedSerialPO) {
        if ("none".equals(cfcEncodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }
}

