package com.tydic.dyc.base.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 标题：PasswordUtils
 * 说明：密码处理
 * 时间：2022/6/11 11:50
 *
 * @author wangmeng
 */
@Component
public class PasswordUtils {
    /**
     * 加密方式 目前支持  加密后 MD5 ,SHA-256   解密后比较 SM2,SM4ECB,SM4CBC
     * */
    @Value("${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    public Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 密码验证
     * */
    public boolean verifyPassword(String passwordIn, String passwordDb, String salt){
        if(encryptType.equals("SM2")||encryptType.equals("SM4ECB")||encryptType.equals("SM4CBC")) {
            String decryptFirst= encryptUtils.decryptByType(passwordDb,encryptType);
            log.info("第一次解密：" + decryptFirst);
            decryptFirst.substring(0,decryptFirst.length()-salt.length());
            log.info("去掉盐值：" + decryptFirst.substring(0,decryptFirst.length()-salt.length()));
            String decryptSecond= encryptUtils.decryptByType(decryptFirst.substring(0,decryptFirst.length()-salt.length()),"SM2");
            log.info("第二次解密：decryptSecond = {},password = {}" , decryptSecond,passwordIn);
            if (passwordDb != null && decryptSecond.equals(passwordIn)) {
                log.info("匹配成功" , decryptSecond,passwordIn);
                return true;
            }else{
                return false;
            }
        }else{
            // 第一次加密
            String inputPwd = encryptUtils.encryptByType(passwordIn, encryptType);
            log.info("第一次加密：" + inputPwd);
            // 获取加密盐
            log.debug("获取加密盐：" + salt);
            log.debug("inputPwd + salt：" + inputPwd + salt);
            String digPwd = inputPwd + salt;
            log.debug("digPwd:" + digPwd);
            // 第二次加密
            String encrypt = encryptUtils.encryptByType(digPwd, encryptType);
            log.info("第二次加密：" + encrypt);
            if (passwordDb != null && encrypt.equals(passwordDb)) {
                return true;
            }else {
                return false;
            }
        }
    }
    public String buildPassword(String passwordIn, String salt){
       // 第一次加密
        String inputPwd = encryptUtils.encryptByType(passwordIn, encryptType);
        log.info("第一次加密：" + inputPwd);
        // 获取加密盐
        log.debug("获取加密盐：" + salt);
        log.debug("inputPwd + salt：" + inputPwd + salt);
        String digPwd = inputPwd + salt;
        log.debug("digPwd:" + digPwd);
        // 第二次加密
        String encrypt = encryptUtils.encryptByType(digPwd, encryptType);
        log.info("第二次加密：" + encrypt);
        return encrypt;
    }
}
