package com.tydic.dyc.base.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.sm.SM2Utils;
import com.ohaotian.plugin.common.sm.SM4Utils;
import com.ohaotian.plugin.common.sm.Util;
import com.ohaotian.plugin.common.util.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * @author wangmeng
 * @Title: 加密方式
 * @Package
 * @Description:
 * @date 2020/3/3115:44
 */
@Component
public  class EncryptUtils {

    // 国密规范正式私钥
    @Value("${sm2.privateKey:00DAD10531C81F17BAAA10200EBCC484C403F866345C6CE7BB575A2F4BE1232585}")
    private String prik ;
    // 国密规范正式公钥
    @Value("${sm2.publicKey:04440318A7A3A4CC89CEE7DABBA724A5226B76C9CD512AA1937AC866757117E299EEDC631F27E92A254359B154BA24183061FAC40ACA56B3B1BBB07DC288C6409E}")
    private String pubk ;
    //#SM4秘钥
    @Value("${sm4.secretKey:JeF8U9wHFOMfs2Y8}")
    private String sm4SecretKey;
    @Value("${sm4.hexString:false}")
    private Boolean sm4hexString;
    //#SM4 CBC模式 需要
    @Value("${sm4.iv:UISwD9fW6cFh9SNS}")
    private String sm4Iv;

    private Logger log = LoggerFactory.getLogger(this.getClass());

    public String encryptByType(String strSrc, String encName) {
        String encStr="";
        if(encName.equals("SM2")){
            log.info("strSrc = {}",strSrc);
            byte[] sourceData = strSrc.getBytes();
            try {
                encStr = SM2Utils.encrypt(Util.hexToByte(pubk), sourceData);
                log.info("encName = {},publicKey = {},encStr = {}",encName,pubk,encStr);
            } catch (Exception e) {
                log.error("encName = {},publicKey = {} 加密失败：{}",encName,pubk,e);
                throw new ZTBusinessException("SM2加密失败");
            }
        }else if(encName.equals("SM4ECB")){
            SM4Utils sm4 = new SM4Utils();
            sm4.secretKey = sm4SecretKey;
            sm4.hexString = sm4hexString;
            encStr = sm4.encryptData_ECB(strSrc);

        }else if(encName.equals("SM4CBC")){
            SM4Utils sm4 = new SM4Utils();
            sm4.secretKey = sm4SecretKey;
            sm4.hexString = sm4hexString;
            sm4.iv =sm4Iv;
            encStr = sm4.encryptData_CBC(strSrc);
        }else{
            encStr= DigestUtils.Encrypt(strSrc, encName);
        }
        return encStr;
    }
    public String decryptByType(String strSrc, String encName) {
        String decStr="";
        if(encName.equals("SM2")){
            log.info("strSrc = {}",strSrc);
            try {
                decStr = new String(SM2Utils.decrypt(Util.hexToByte(prik), Util.hexToByte(strSrc)));
                log.info("encName = {},privateKey = {},encStr = {}",encName,prik,decStr);
            } catch (Exception e) {
                log.error("encName = {},privateKey = {} 解密失败：{}",encName,prik,e);
                throw new ZTBusinessException("SM2解密失败");
            }
        }else if(encName.equals("SM4ECB")){
            SM4Utils sm4 = new SM4Utils();
            sm4.secretKey = sm4SecretKey;
            sm4.hexString = sm4hexString;
            decStr =  sm4.decryptData_ECB(strSrc);;

        }else if(encName.equals("SM4CBC")){
            SM4Utils sm4 = new SM4Utils();
            sm4.secretKey = sm4SecretKey;
            sm4.hexString = sm4hexString;
            sm4.iv =sm4Iv;
            decStr = sm4.decryptData_CBC(strSrc);
        }else{
            decStr= "";
        }
        return decStr;
    }
}
