package com.tydic.dyc.base.utils;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.DycBaseCentreRspBO;
import com.tydic.dyc.base.bo.DycBaseUserInfoBO;
import com.tydic.dyc.base.constants.BasicRspConstant;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

/**
 * 类名：SmcRu
 * 说明：出参对象工具类
 * 作者：lishiqing
 * 时间： 2025/1/21 14:05
 */
public class SmcRu {
    /**
     * 描述: 转换应用层入参对象为中心层入参对象
     *
     * @param reqBo 应用层入参对象实例
     * @param clazz 中心层入参对象Class类型
     * @return T
     * @author tgy
     * @date 2021/3/31 15:21
     */
    public static <T> T js(Object reqBo, Class<T> clazz) {
        return JSON.parseObject(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(List<?> reqBo, Class<T> clazz) {
        if (CollectionUtils.isEmpty(reqBo)) {
            return new ArrayList<>();
        }
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * JSON字符串转对象
     *
     * @param jsonStr
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T jss(String jsonStr, Class<T> clazz) {
        return JSON.parseObject(jsonStr, clazz);
    }
    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(Object reqBo, Class<T> clazz) {
        if (null == reqBo) {
            return new ArrayList<>();
        }
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }



    /**
     * 描述:生成一个继承于UocProBaseRspBo的对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    private static <T extends DycBaseCentreRspBO> T generate(String code, String desc, Class<T> tClass) {
        try {
            T t = tClass.newInstance();
            t.setRespCode(code);
            t.setRespDesc(desc);
            return t;
        } catch (Exception e) {
            throw new IllegalArgumentException("UocProRspBoUtil创建rsp对象异常：" + e.getMessage());
        }
    }

    /**
     * 描述:生成一个继承于UocProBaseRspBo的失败对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    public static <T extends DycBaseCentreRspBO> T failed(String code, String desc, Class<T> tClass) {
        return generate(code, desc, tClass);
    }


    /**
     * 描述:生成默认描述的成功对象
     *
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:40
     */
    public static <T extends DycBaseCentreRspBO> T success(Class<T> tClass) {
        return success(BasicRspConstant.ComRspConstant.RSP_CODE_SUCCESS, tClass);
    }


    /**
     * 描述:生成一个指定成功描述的对象
     *
     * @param desc   成功描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:42
     */
    public static <T extends DycBaseCentreRspBO> T success(String desc, Class<T> tClass) {
        return generate(BasicRspConstant.ComRspConstant.RSP_CODE_SUCCESS, desc, tClass);
    }

    /**
     * object转List
     *
     * @param obj   被转换的对象
     * @param clazz 转换出参类型T
     * @return List
     */
    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        List<T> result = new ArrayList<>();
        if (obj instanceof List<?>) {
            for (Object o : (List<?>) obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }


    /**
     * to Long
     *
     * @param o
     * @return Long
     */
    public static Long parseLong(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return Long.parseLong((String) o);
        }
        if (o instanceof Long) {
            return (Long) o;
        }
        if (o instanceof Integer) {
            return ((Integer) o).longValue();
        }
        return null;
    }


    /**
     * to Integer
     *
     * @param o
     * @return Long
     */
    public static Integer parseInteger(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return Integer.parseInt((String) o);
        }
        if (o instanceof Long) {
            return ((Long) o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer) o;
        }
        return null;
    }


    /**
     * to Str
     *
     * @param o
     * @return String
     */
    public static String parseStr(Object o) {
        if (null == o) {
            return null;
        }
        return o.toString();
    }

    /**
     * 设置创建入参
     */
    public static void setCreate(Object info,Object out) {
       setUserInfo(info,out,"create");
    }

    /**
     * 设置更新入参
     */
    public static void setUpdate(Object info,Object out) {
        setUserInfo(info,out,"update");
    }

    /**
     * 设置更新入参
     */
    public static void setUserInfo(Object info,Object out,String startsWith) {
        if (info instanceof DycBaseUserInfoBO) {
            Stream.of(out.getClass().getDeclaredFields())
                    .filter(field -> field.getName().startsWith(startsWith))
                    .forEach(field -> {
                        try {
                            field.setAccessible(true);
                            if (field.getName().equals(startsWith+"UserId")) {
                                field.set(out,((DycBaseUserInfoBO) info).getUserId());
                            }
                            if (field.getName().equals(startsWith+"UserName")) {
                                field.set(out,((DycBaseUserInfoBO) info).getName());
                            }
                            if (field.getName().equals(startsWith+"OrgId")) {
                                field.set(out,((DycBaseUserInfoBO) info).getOrgId());
                            }
                            if (field.getName().equals(startsWith+"OrgName")) {
                                field.set(out,((DycBaseUserInfoBO) info).getOrgName());
                            }
                            if (field.getName().equals(startsWith+"CompanyId")) {
                                field.set(out,((DycBaseUserInfoBO) info).getCompanyId());
                            }
                            if (field.getName().equals(startsWith+"CompanyName")) {
                                field.set(out,((DycBaseUserInfoBO) info).getCompanyName());
                            }
                            if (field.getName().equals(startsWith+"OrgTreePath")) {
                                field.set(out,((DycBaseUserInfoBO) info).getOrgPath());
                            }
                            if (field.getName().equals(startsWith+"Time")) {
                                field.set(out,new Date());
                            }
                        } catch (IllegalAccessException e) {
                            // 处理异常，例如记录日志或抛出运行时异常
                            throw new RuntimeException(e);
                        }
                    });
        }
    }
}