package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：UocAfOrderServiceInfoBo
 *
 * @author tkl
 * @date 2022/2/13 22:01
 */
@Data
public class UocAfOrderServiceInfoBo implements Serializable {
    private static final long serialVersionUID = -212809246518383750L;

    @DocField(value = "服务单编号")
    private String afServCode;

    @DocField(value = "是否付过款")
    private Boolean isPayFlag = false;

    @DocField(value = "服务单状态  100提交申请  200 审核中 201审核不通过 300收货完成  400退款成功 401退款失败 500 已完成  600 取消")
    private Integer servState;

    @DocField(value = "服务单状态翻译")
    private String servStateStr;

    @DocField(value = "供应商Id")
    private String supplierId;

    @DocField(value = "供应商名称")
    private String supplierName;

    @DocField(value = "服务单类型  退货(10) 换货(20)  维修(30)")
    private Integer servType;

    @DocField(value = "服务单类型翻译")
    private String servTypeStr;

    @DocField(value = "申请人")
    private String submitterOperName;

    @DocField(value = "服务提出联系人")
    private String subContactName;

    @DocField(value = "服务提出联系人电话")
    private String subContactMobile;

    @DocField(value = "申请时间")
    private Date submiteTime;

    @DocField(value = "取件开始时间")
    private Date pickupStartTime;

    @DocField(value = "取件结束时间")
    private Date pickupEndTime;

    @DocField(value = "售后完成时间")
    private Date finishTime;

    @DocField(value = "供应商确认时间")
    private Date confirmTime;

    @DocField(value = "支付方式  1 预付款 2 电汇或承兑汇票")
    private String payType;

    @DocField(value = "支付方式翻译")
    private String payTypeStr;

    @DocField(value = "售后原因")
    private Integer afsReason;

    @DocField(value = "售后原因翻译")
    private String afsReasonStr;

    @DocField(value = "问题描述")
    private String questionDesc;

    @DocField(value = "外部订单id")
    private String outOrderId;

    @DocField(value = "订单类型")
    private Integer orderType;

    @DocField(value = "订单类型翻译")
    private String orderTypeStr;

    @DocField(value = "取货服务类型  1：  上门取件  2：客户发货  3：  客户送货")
    private Integer pickwareType;

    @DocField(value = "取货服务类型翻译")
    private String pickwareTypeStr;

    @DocField(value = "取件地址信息")
    private UocAfOrderReceiverAddressBo orderTakeDeliveryInfo;

    @DocField(value = "收货地址信息")
    private UocAfOrderReceiverAddressBo orderTakeReceiveInfo;

    @DocField(value = "附件信息")
    private List<UocBaseOrderAccessoryTypeDetailBo> accessoryInfo;

    @DocField(value = "任务ID")
    private String taskId;


    @DocField(value = "环节编码")
    private String stepId;
}


