package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocCancelSaleOrderConfirmOrRefuseReqBo
 * 说明:销售单取消申请同意/拒绝
 * 时间:2022/2/25 11:22
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocCancelSaleOrderConfirmOrRefuseReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = 6867135822549024229L;

    @DocField(value = "1 接受 0拒绝", required = true)
    private Integer opFlag;

    @DocField(value = "销售单id", required = true)
    private Long saleOrderId;

    @DocField(value = "订单id", required = true)
    private Long orderId;

    @DocField(value = "变更单ID", required = true)
    private Long chngOrderId;

    @DocField(value = "回复内容")
    private String cancelReplyContent;

    @DocField(value = "附件", required = true)
    private List<UocBaseOrderAccessoryAddBo> accessoryAddBoList;

    @DocField(value = "纵向扩展数据 更新")
    private List<UocBaseExtParallelEditBo> extEditList;

    @DocField(value = "纵向拓展信息 删除")
    private List<UocBaseExtParallelDeleteBo> extDeleteList;
}
