package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocQryShipOrderDetailsRspDetailBo
 * 说明:发货主体详情
 * 时间:2022/3/14 14:51
 * 作者:罗有
 */

@Data
public class UocQryShipOrderDetailsRspDetailBo implements Serializable {
	private static final long serialVersionUID = -1652309153678385798L;


	@DocField(value = "发货单id")
	private Long shipOrderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "销售单编号")
	private String saleOrderNo;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "发货单编码")
	private String shipOrderNo;

	@DocField(value = "外部发货单编码")
	private String shipOrderNoExt;

	@DocField(value = "发货单名称")
	private String shipOrderName;

	@DocField(value = "发货单类型")
	private Integer shipOrderType;

	@DocField(value = "发货单状态")
	private String shipOrderState;

	@DocField(value = "发货单状态翻译")
	private String shipOrderStateStr;

	@DocField(value = "供应商编码")
	private String supNo;

	@DocField(value = "供应商ID")
	private String supId;

	@DocField(value = "供应商名称")
	private String supName;

	@DocField(value = "供应商账户")
	private String supAccount;

	@DocField(value = "采购方公司id")
	private String purCompanyId;

	@DocField(value = "采购公司编码")
	private String purCompanyNo;

	@DocField(value = "采购方公司名称")
	private String purCompanyName;

	@DocField(value = "采购方机构id")
	private String purOrgId;

	@DocField(value = "采购方机构编码")
	private String purOrgNo;

	@DocField(value = "采购方机构名称")
	private String purOrgName;

	@DocField(value = "运营单位机构id")
	private String proId;

	@DocField(value = "运营单位机构编码")
	private String proNo;

	@DocField(value = "运营机构名称")
	private String proName;

	@DocField(value = "物流公司id")
	private String shipCompanyId;

	@DocField(value = "物流公司名称")
	private String shipCompanyName;

	@DocField(value = "物流单号")
	private String shipCompanyNo;

	@DocField(value = "车牌号")
	private String carNo;

	@DocField(value = "运输方式")
	private Integer transportMode;

	@DocField(value = "发货时间")
	private Date shipTime;

	@DocField(value = "发货联系人姓名")
	private String shipName;

	@DocField(value = "发货联系人电话")
	private String shipPhone;

	@DocField(value = "发货工号")
	private String shipOperId;

	@DocField(value = "预计到货时间")
	private Date estimateArrivalTime;

	@DocField(value = "到货时间")
	private Date arriveTime;

	@DocField(value = "验收时间-该发货单全部被验收")
	private Date inspTime;

	@DocField(value = "验收人名称-该发货单全部被验收")
	private String inspOperName;

	@DocField(value = "验收人工号-该发货单全部被验收")
	private String inspOperId;

	@DocField(value = "验收人电话-该发货单全部被验收")
	private String inspOperPhone;

	@DocField(value = "发货备注")
	private String shipRemark;

	@DocField(value = "到货备注")
	private String arriveRemark;

	@DocField(value = "收/拒收 货人")
	private String receiverUser;

	@DocField(value = "收/拒收 货备注")
	private String receiverRemark;

	@DocField(value = "收/拒收 联系人")
	private String receiverContact;

	@DocField(value = "收/拒收 时间")
	private Date receiverTime;

	@DocField(value = "是否可以异常变更：1：不允许；其他情况都可以")
	private Integer isAbnormal;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "发货单扩展")
	private List<UocBaseExtParallelBo> extParallelBoList;

	@DocField(value = "发货单明细")
	private List<UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemBoList;

	@DocField(value = "附件")
	private List<UocBaseOrderAccessoryTypeDetailBo> orderAccessoryBoList;
}
