package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDetailBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:48
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetOrderAllDetailServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = -6763251865187297180L;


    @DocField(value = "采购方编码")
    private String purNo;

    @DocField(value = "采购方名称")
    private String purName;

    @DocField(value = "采购方账户名称")
    private String purAccountName;

    @DocField(value = "采购方账户")
    private String purAccount;

    @DocField(value = "采购方账户持有人编码")
    private String purAccountOwnId;

    @DocField(value = "采购方账户持有人名称")
    private String purAccountOwnName;

    @DocField(value = "采购方联系人电话")
    private String purMobile;

    @DocField(value = "采购方下单人编号")
    private String purPlaceOrderId;

    @DocField(value = "采购方下单人名称")
    private String purPlaceOrderName;

    @DocField(value = "采购方下单人登录名")
    private String purLogName;

    @DocField(value = "采购方公司id")
    private String purCompanyId;

    @DocField(value = "采购方公司名称")
    private String purCompanyName;

    @DocField(value = "下单组织机构编码")
    private String purOrgId;

    @DocField(value = "下单组织机构路径")
    private String purOrgPath;

    @DocField(value = "需方联系人名称")
    private String purRelaName;

    @DocField(value = "需方联系电话")
    private String purRelaMobile;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "父订单id")
    private Long upperOrderId;

    @DocField(value = "订单编码")
    private String orderNo;

    @DocField(value = "外部订单编码")
    private String orderNoExt;

    @DocField(value = "订单名称")
    private String orderName;

    @DocField(value = "订单级别             1 个人订单             2 企业订单")
    private Integer orderLevel;

    @DocField(value = "支付类型")
    private Integer payMod;

    @DocField(value = "支付方式")
    private String payType;

    @DocField(value = "支付方式翻译")
    private String payTypeStr;

    @DocField(value = "支付状态")
    private String payState;

    @DocField(value = "支付状态翻译")
    private String payStateStr;

    @DocField(value = "订单状态")
    private String orderState;

    @DocField(value = "订单状态翻译")
    private String orderStateStr;

    @DocField("采购模式 1计划，2非计划")
    private Integer purchaseMode;

    @DocField("采购模式翻译")
    private String purchaseModeStr;

    @DocField(value = "流转状态")
    private String procState;

    @DocField(value = "订单说明")
    private String orderDesc;

    @DocField(value = "销售金额")
    private BigDecimal totalSaleFee;

    @DocField(value = "采购金额")
    private BigDecimal totalPurchaseFee;

    @DocField(value = "优惠金额")
    private BigDecimal totalActShareFee;

    @DocField(value = "运费")
    private BigDecimal totalTransFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "竣工标志 1 竣工  0 在途")
    private Integer finishFlag;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "撤单时间")
    private Date cancelTime;

    @DocField(value = "撤单工号")
    private String cancelOperId;

    @DocField(value = "撤单人名称")
    private String cancelOperName;

    @DocField(value = "取消原因")
    private String cancelReason;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "竣工时间")
    private Date finishTime;

    @DocField(value = "逾期时间")
    private Date expTime;

    @DocField("地址信息")
    private UocGetOrderAllDetailServiceRspOrderLogisticsBo logisticsBo;

    @DocField("发票信息")
    private UocGetOrderAllDetailServiceRspOrderInvoiceBo invoiceBo;

    @DocField("商品信息")
    private List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos;

    @DocField("附件")
    private List<UocGetOrderAllDetailServiceRspAccessoryBo> accessoryBos;

    @DocField("订单流程实例")
    private List<UocGetOrderAllDetailServiceRspProcInstBo> procInstBos;

    @DocField("订单横向扩展数据")
    private UocBaseExtCrossBo extCrossBo;

    @DocField("订单纵向扩展数据")
    private List<UocBaseExtParallelDetailBo> extParallelBo;

    @DocField("订单三方信息")
    private List<UocGetOrderAllDetailServiceRspSaleStakeBo> saleStakeBos;

}


