package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocShouldPayOrderQryServiceRspBo
 * 说明:
 * 时间:2022/3/24 15:39
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocShouldPayOrderQryServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 3918712469470291178L;
    @DocField(value = "应付ID", required = true)
    private Long shouldPayId;

    @DocField(value = "订单ID", required = true)
    private Long orderId;

    @DocField(value = "应付单类型：1：账期应付、2：预付款应付", required = true)
    private Integer shouldPayType;

    @DocField(value = "对象id", required = true)
    private Long objectId;

    @DocField(value = "对象类型", required = true)
    private Integer objectType;

    @DocField(value = "支付配置ID", required = true)
    private Long payConfId;

    @DocField("结算应付ID")
    private Long fscShouldPayId;

    @DocField("对象编码")
    private String objectNo;

    @DocField(value = "应付金额", required = true)
    private BigDecimal shouldPayFee;

    @DocField("应付日期")
    private Date shouldPayDate;

    @DocField("付款方ID")
    private Long payerId;

    @DocField("付款方名称")
    private String payerName;

    @DocField(value = "收款方ID")
    private Long payeeId;

    @DocField(value = "收款方名称")
    private String payeeName;

    @DocField("合同id")
    private String contractId;

    @DocField("合同编号")
    private String contractNo;

    @DocField("违约金比例")
    private BigDecimal penaltyRatio;

    @DocField("已付金额")
    private BigDecimal paidFee;

    @DocField(value = "是否支付完成：0：未支付；1：支付完成", required = true)
    private Integer isPayCompleted;

    @DocField("创建时间")
    private Date createTime;

    @DocField("应该推送时间")
    private Date shouldPushTime;

    @DocField("实际推送时间")
    private Date actualPushTime;


}


