package com.tydic.dyc.oc.constants;

import com.tydic.dyc.base.constants.BaseRspConstant;

/**
 * 标题:UocRspConstants
 * 说明:订单中心错误编码定义
 * 时间:2022/2/22 14:18
 * 作者:田桂银
 */
public class UocRspConstants extends BaseRspConstant {

    /*
    编码生成规则：订单中心编码开头：10开头的6位编码
	调用成功的编码无需再自行定义，统一使用：RSP_CODE_SUCCESS
	每个接口调用失败的编码需自行定义，规则如下：
	编码key：以RSP_CODE开头，以ERROR结束，中间为自定义部分，
	自定义原则为具有可读性的英文单词（可简写），多个单词以“_”分隔
	编码值：领域服务层1开头，如：1001；领域方法以2开头，如：2001；基建层以3开头，如3001；编码值长度为4位
	注意：订单中心整体编码前面要加10，方便应用层识别和统一管理编码
	*/

    public static final String RSP_CODE_ARG_EMPTY_ERROR = "100001";
	/**
	 * 通用系统异常编码
	 */
	public static final String RSP_CODE_SYSTEM_EXCEPTION = "100100";
    /**
     * 参数非空
     */
    public static final String RSP_CODE_METHOD_ARG_EMPTY_ERROR = "102001";

    /**
     * 调用规则引擎失败
     */
    public static final String RSP_CODE_VIRGO_ERROR = "100002";


    //===========================================================领域层1开头===========================================================
    /**
     * 订单创建领域服务错误
     */
    public static final String RSP_CODE_CREATE_ORDER_ERROR = "101001";

    /**
     * 发货错误
     */
    public static final String RSP_CODE_IMPL_SHIP_ORDER_ERROR = "101002";

    /**
     * 到货确认/拒收错误
     */
    public static final String RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR = "101003";

    /**
     * 到货验收错误
     */
    public static final String RSP_CODE_ARRIVA_ACCEPTANCE_ERROR = "101004";

    /**
     * 销售单任务提交错误
     */
    public static final String RSP_CODE_SALE_TASK_COMMIT_ERROR = "101005";

    /**
     * 数量变更申请错误
     */
    public static final String RSP_CODE_NUM_CHNG_APPLY_ERROR = "101006";

	/**
	 * 字典服务入参错误
	 */
	public static final String RSP_CODE_PEB_DIC_PARAM_ERROR = "101007";

	/**
	 * 字典服务入参错误
	 */
	public static final String RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR = "101008";

	/**
	 * 取消申请
	 */
	public static final String RSP_CODE_CANCEL_APPLY_ERROR = "101009";

	/**
	 * 撤销取消申请
	 */
	public static final String RSP_CODE_PASTE_CANCEL_APPLY_ERROR = "101010";

	/**
	 * 取消申请发起
	 */
	public static final String RSP_CODE_SALE_CANCEL_APPLY_ERROR = "101011";

	/**
	 * 调用第三方接口失败:101012
	 */
	public static final String RSP_ERROR_CODE_CALL_THIRD_SERVICE = "101012";

	/**
	 * 调用接口异常:101013
	 */
	public static final String RSP_CODE_CALL_THIRD_SERVICE = "101013";

	/**
	 * 调用接口响应数据空:101014
	 */
	public static final String RSP_CODE_THREE_DATA_NULL = "101014";

	/**
	 * 销售单支付配置查询为空:101015
	 */
	public static final String RSP_CODE_SALE_ORDER_PAY_CONF_NULL_ERROR = "101015";

	/**
	 * 销售单查询为空:101016
	 */
	public static final String RSP_CODE_SALE_ORDER_NULL_ERROR = "101016";

	/**
	 * 流转终止:101016
	 */
	public static final String RSP_CODE_PROC_INST_TERMINATE_ERROR = "101016";

	/**
	 * 订单评价配置处理:101017
	 */
	public static final String RSP_CODE_ORD_EVA_DEAL_ABILITY_ERROR = "101017";
	/**
	 * 订单时效配置处理:101018
	 */
	public static final String RSP_CODE_ORD_EFFECT_DEAL_ABILITY_ERROR = "101018";

	/**
	 * 打印验收单错误
	 */
	public static final String RSP_CODE_PRINT_ARRIVA_ACCEPTANCE_ERROR = "101018";

	/**
	 * 审批配置
	 */
	public static final String RSP_CODE_AUDIT_CONF_ERROR = "101020";


	/**
	 * 异常单 -》查询销售单信息异常
	 */
	public static final String RSP_CODE_CHNG_QURYSALEORDER_ERROR = "101019";
	//===========================================================领域方法层2开头===========================================================
	/**
	 * 更新销售单状态错误
	 */
	public static final String RSP_CODE_SALE_UPDATE_STATE_ERROR = "102001";
	/**
	 * 更新发货单状态错误
	 */
	public static final String RSP_CODE_SHIP_UPDATE_STATE_ERROR = "102002";
    /**
     * 更新异常单状态错误
     */
    public static final String RSP_CODE_CHNG_UPDATE_STATE_ERROR = "102003";
    /**
     * 字典创建错误
     */
    public static final String RSP_CODE_DICTIONARY_CREATE_ERROR = "102002";
    //===========================================================领域方法层2开头===========================================================
    /**
     * 销售单获取对象
     */
    public static final String RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR = "103001";
    /**
     * 发货单获取编码失败
     */
    public static final String RSP_CODE_SHIP_ORDER_RESP_GET_OBJ_NO_ERROR = "103002";
    /**
     * 验收单获取编码失败
     */
    public static final String RSP_CODE_INSP_ORDER_RESP_GET_OBJ_NO_ERROR = "103003";
    /**
     * 售后单获取外部订单编号失败
     */
    public static final String RSP_CODE_AF_ORDER_RESP_GET_EXT_ORD_ID_ERROR = "103004";


}


