package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocCreateOrderServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = 7344454593346320509L;

    /**
     * 销售总金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购总金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 备注
     */
    private String remark;

    /**
     * 采购方账套id
     */
    private String purAccount;

    /**
     * 采购方账套名称
     */
    private String purAccountName;

    /**
     * 采购方联系人
     */
    private String purContactName;

    /**
     * 采购方联系人电话
     */
    private String purMobile;

    /**
     * 需方联系人名称
     */
    private String purNeedName;

    /**
     * 需方联系电话
     */
    private String purNeedMobile;

    /**
     * 送货时间
     */
    private Date sendTime;

    /**
     * 订单级别 1 个人订单  2 企业订单，默认个人订单
     */
    private Integer orderLevel;

    /**
     * 是否同步创建销售单及其相关信息，默认false
     */
    private Boolean createSaleOrder;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 下单系统
     */
    private String orderSystem;

    /**
     * 订单类型 :1.采购电商
     */
    private Integer orderType;

    /**
     * 订单说明
     */
    private String orderDesc;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

//    租户ID
//    private String tenantId;

    /**
     * 商品信息
     */
    private List<UocCreateOrderServiceReqCommodityBo> orderItems;

    /**
     * 发票信息
     */
    private UocCreateOrderServiceReqInvoiceBo uocOrdInvoice;

    /**
     * 运营方信息
     */
    private UocCreateOrderServiceReqProfessionalBo operating;

//    /**
//     * 支付配置，当需要同步创建销售单时(createSaleOrder为true)，必传（从结算基于采购方和运营方查询）
//     */
//    private List<UocCreateOrderServiceReqPayConfSupBo> payConfigList;
    /**
     * 供应商信息
     */
    private List<UocSupplierInfoBo> supplierBos;

    /**
     * 协议信息
     */
    private List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList;

    /**
     * 收货人地址信息
     */
    private UocCreateOrderServiceReqAddressBo receiverAddress;

    /**
     * 发票邮寄信息
     */
    private UocCreateOrderServiceReqAddressBo invoiceAddress;

    /**
     * 订单附件信息
     */
    private List<UocCreateOrderServiceReqAccessoryBo> accessoryList;

//    /**
//     * 订单纵向扩展数据
//     */
//    private List<UocBaseExtParallelBo> orderParallelExtList;

//    /**
//     * 业务外参数（签约单信息或其他）
//     */
//    private JSONObject jsonObj;

//    /**
//     * 订单创建结果 0创建中，1成功，2失败
//     */
//    private Integer createdResult;

    /**
     * 当前登录用户id
     */
    private Long userId;
    /**
     * 当前登录用户名称
     */
    private String name;
    /**
     * 当前登录用户账号名
     */
    private String userName;
    /**
     * 当前登录用户机构id
     */
    private Long orgId;
    /**
     * 当前登录用户机构名称
     */
    private String orgName;
    /**
     * 当前登录用户公司id
     */
    private Long companyId;
    /**
     * 当前登录用户公司名称
     */
    private String companyName;
    /**
     * 当前登录用户机构树路径
     */
    private String orgPath;
    /**
     * 用户类型：1 外部个人 2 外部企业 3内部个人 4 内部企业
     */
    private String userType;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}


