package com.tydic.dyc.oc.service.shiporder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-发货单到货登记 入参〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@Data
public class UocShipOrderArrivaRegistReqBo extends BaseReqBo {

	private static final long serialVersionUID = -1661157251727484019L;
	/**
	 * 订单id
	 */
	private Long orderId;

	/**
	 * 销售单id
	 */
	private Long saleOrderId;

	/**
	 * 发货单ID
	 */
	private List<Long> shipOrderIdList;

	/**
	 * 任务id列表
	 */
	private List<String> taskIds;

	/**
	 * 到货备注
	 */
	private String arriveRemark;
	/**
	 * 收/拒收 货人
	 */
	private String receiverUser;

	/**
	 * 收/拒收 货备注
	 */
	private String receiverRemark;

	/**
	 * 收/拒收 联系人
	 */
	private String receiverContact;

	/**
	 * 收/拒收 时间
	 */
	private Date receiverTime;

	/**
	 * 附件
	 */
	private List<UocBaseOrderAccessoryAddBo> orderAccessoryList;

	/**
	 * 纵向扩展数据 更新
	 */
	private List<UocBaseExtParallelEditBo> extEditList;

	/**
	 * 纵向拓展信息 删除
	 */
	private List<UocBaseExtParallelDeleteBo> extDeleteList;

	/**
	 * 任务id
	 */
	private String taskId;
	/**
	 * 用户id
	 */
	private Long userId;

	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;
}
