package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：UocShouldPayCreateBo
 * 说明：
 * 时间：2022/4/8 16:01
 * 作者： 周中贤
 */
@Data
public class UocShouldPayCreateBo implements Serializable {
    private static final long serialVersionUID = -430215971664059870L;

    /**
     * 结算 应付ID
     */
    private Long fscShouldPayId;
    /**
     * 付款方式
     */
    private Integer payType;
    /**
     * 应付类型1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付
     */
    private Integer shouldPayType;
    /**
     * 单据ID
     */
    private Long objectId;
    /**
     * 单据编码
     */
    private String objectNo;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 返回单据类型 1：采购订单 2：通用结算单 3：成交服务费结算单 4：平台使用费结算单 5：销售订单 6：验收单 7：发货单
     */
    private Integer objectType;
    /**
     * 应付金额
     */
    private BigDecimal shouldPayAmount;
    /**
     * 应付日期
     */
    private Date shouldPayDate;
    /**
     * 付款方ID
     */
    private Long payerId;

    /**
     * 付款方名称
     */
    private String payerName;

    /**
     * 收款方ID
     */
    private Long payeeId;

    /**
     * 收款方名称
     */
    private String payeeName;
    /**
     * 合同id
     */
    private String contractId;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 违约金比例
     */
    private BigDecimal penaltyRatio;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}
