package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UocGetJDSplitOrderBO extends BaseRspBo {
    private static final long serialVersionUID = 8542035627035443789L;
    
    /*当此单有子单时，为父订单详情。*/
    private UocParentSaleOrderBO pOrder;
    
    /*当此单有子单时，为子订单详情。*/
    private List<UocChildSaleOrderBO> cOrder;
    
    /*订单状态。0为取消订单 1为有效。*/
    private Integer orderState;
    /*京东订单编号。*/
    private Long jdOrderId;
    /*物流状态。0 是新建 1是妥投 2是拒收*/
    private Integer state;
    
    /*预占确认状态。0没确认预占。 1已确认预占*/
    private Integer submitState;
    /*订单类型。1是父订单 2是子订单*/
    private Integer type;
    /*运费：收取运费时返回*/
    private BigDecimal freight;
    /*商品列表*/
    private List<UocJDSkuDetailInfo> sku;
    /*订单总金额（不含运费）*/
    private BigDecimal orderPrice;
    
    /*订单未含税金额*/
    private BigDecimal orderNakedPrice;
    /*订单税额*/
    private BigDecimal orderTaxPrice;
    /*订单类别*/
    private Integer orderType;
    /*订单创建时间。查询参数queryExts中包含createOrderTime。输出格式为“yyyy-MM-dd hh:mm:ss”*/
    private String createOrderTime;
    
    /*订单完成时间。查询参数queryExts中包含finishTime。输出格式为“yyyy-MM-dd hh:mm:ss”未完成时，此参数返回null*/
    private String finishTime;
    /*京东状态。查询参数中包含queryExts=jdOrderState。参考枚举值如下：1.新单2.等待支付3.等待支付确认4.延迟付款确认5.订单暂停6.店长最终审核7.等待打印8.等待出库9.等待打包10.等待发货11.自提途中12.上门提货13.
    自提退货14.确认自提16.等待确认收货17.配送退货18.货到付款确认19.已完成21.收款确认22.锁定29.等待三方出库30.等待三方发货31.等待三方发货完成*/
    private Integer jdOrderState;
    /*支付方式枚举值1：货到付款4：预存款5：公司转账101：京东金采102：商城金采(一般不适用，仅限确认开通商城账期的特殊情况使用，请与业务确认后使用)20为混合支付*/
    private Integer paymentType;
    /*混合支付明细，当paymentType为20混合支付，返回值 [ { "payMoney":20, "paymentType":"17", "flag":"1" }, { "payMoney":80, "paymentType":"4", "flag":"2" }]*/
    private JSONArray payDeatails;
    /*京东配送订单的出库时间/厂家直送订单的确认发货时间"2019-10-12 10:21:44"*/
    private Date outTime;
    /*下单时的开票类型 2增值税专用发票；3 电子票*/
    private String invoiceType;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
    
}
