package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocQryChngOrderDetailsRspInfoItemBo
 * 说明:商品明细
 * 时间:2022/3/14 21:37
 * 作者:罗有
 */

@Data
public class UocQryChngOrderDetailsRspInfoItemBo implements Serializable {
    private static final long serialVersionUID = -8434860065338516602L;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "销售明细ID")
    private Long saleOrderItemId;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "单品名称")
    private String skuName;

    @DocField(value = "商品id")
    private String commodityId;

    @DocField(value = "商品名称")
    private String commodityName;

    @DocField(value = "采购单价")
    private BigDecimal purchasePrice;

    @DocField(value = "调价后采购单价")
    private BigDecimal purchasePriceRear;

    @DocField(value = "销售单价")
    private BigDecimal salePrice;

    @DocField(value = "调价后销售单价")
    private BigDecimal salePriceRear;

    @DocField(value = "调价率")
    private BigDecimal adjustPriceRate;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField(value = "销售金额")
    private BigDecimal saleFee;

    @DocField(value = "采购金额")
    private BigDecimal purchaseFee;

    @DocField(value = "应付金额")
    private BigDecimal payFee;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "税务编码")
    private String taxId;

    @DocField(value = "预计发货时间")
    private Date preSendTime;

    @DocField(value = "预计交货时间")
    private Date preOfferTime;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "结算计量单位")
    private String settleUnit;

    @DocField(value = "售后在途数量")
    private BigDecimal afterServingCount;

    @DocField(value = "原退货数量")
    private BigDecimal preReturnCount;

    @DocField(value = "现退货数量")
    private BigDecimal curReturnCount;

    @DocField(value = "验收数量")
    private BigDecimal inspCount;

    @DocField(value = "调整数量")
    private BigDecimal chngNum;

    @DocField(value = "调整金额")
    private BigDecimal chngFee;

    @DocField(value = "变更状态")
    private String chngState;

    @DocField(value = "变更状态翻译")
    private String chngStateStr;

    @DocField(value = "其他变更")
    private String otherChngValue;

    @DocField(value = "其他变更翻译")
    private String otherChngValueStr;

    @DocField(value = "外部电商主订单id")
    private String lmOrderId;

    @DocField(value = "外部电商子订单id")
    private String lmSubOrderId;

    @DocField(value = "到货周期")
    private String arrivalTime;

    @DocField(value = "加价率")
    private Double markUpRate;

    @DocField(value = "调价后加价率")
    private Double markUpRateRear;

    @DocField(value = "sku物料id")
    private String skuMaterialId;

    @DocField(value = "sku物料编码")
    private String skuMaterialCode;

    @DocField(value = "sku外部单品id")
    private String skuExtSkuId;

    @DocField(value = "sku品牌id")
    private Long skuBrandId;

    @DocField(value = "单品品牌名称")
    private String skuBrandName;

    @DocField(value = "sku明细id")
    private String skuItemId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "型号")
    private String model;

    @DocField(value = "规格")
    private String spec;

    @DocField(value = "材质")
    private String texture;

    @DocField(value = "图号")
    private String figure;

    @DocField(value = "一级类目")
    private Long l1Catalog;

    @DocField(value = "二级类目")
    private Long l2Catalog;

    @DocField(value = "三级类目")
    private Long l3Catalog;

    @DocField(value = "一级类目名称")
    private String l1CatalogName;

    @DocField(value = "二级类目名称")
    private String l2CatalogName;

    @DocField(value = "三级类目名称")
    private String l3CatalogName;

    @DocField(value = "退货时间，空代表不支持")
    private Integer rejectAllowDate;

    @DocField(value = "换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    @DocField(value = "维修时间，空代表不支持")
    private Integer maintainAllowDate;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    @DocField(value = "发货明细id")
    private Long shipItemId;

    @DocField(value = "单品编码")
    private String skuCode;

    @DocField(value = "该商品是否调价")
    private Boolean adjustFlag;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "计量单位")
    private String unitDigit;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}
