package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocShouldPayOrderQryServiceRspBo
 * 说明:
 * 时间:2022/3/24 15:39
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocShouldPayOrderQryServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 3918712469470291178L;
    /*
    * 应付ID
    * */
    private Long shouldPayId;

    /*
    * 订单ID
    * */
    private Long orderId;

    /*
    * 应付单类型：1：账期应付、2：预付款应付
    * */
    private Integer shouldPayType;

    /*
    * 对象id
    * */
    private Long objectId;

    /*
    * 对象类型
    * */
    private Integer objectType;

    /*
    * 支付配置ID
    * */
    private Long payConfId;

    /*
    * 结算应付ID
    * */
    private Long fscShouldPayId;

    /*
    * 对象编码
    * */
    private String objectNo;

    /*
    * 应付金额
    * */
    private BigDecimal shouldPayFee;

    /*
    * 应付日期
    * */
    private Date shouldPayDate;

    /*
    * 付款方ID
    * */
    private Long payerId;

    /*
    * 付款方名称
    * */
    private String payerName;

    /*
    * 收款方ID
    * */
    private Long payeeId;

    /*
    * 收款方名称
    * */
    private String payeeName;

    /*
    * 合同id
    * */
    private String contractId;

    /*
    * 合同编号
    * */
    private String contractNo;

    /*
    * 违约金比例
    * */
    private BigDecimal penaltyRatio;

    /*
    * 已付金额
    * */
    private BigDecimal paidFee;

    /*
    * 是否支付完成：0：未支付；1：支付完成
    * */
    private Integer isPayCompleted;

    /*
    * 创建时间
    * */
    private Date createTime;

    /*
    * 应该推送时间
    * */
    private Date shouldPushTime;

    /*
    * 实际推送时间
    * */
    private Date actualPushTime;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;


}


