package com.tydic.dyc.oc.service.implorder.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 描述: 〈领域服务-执行单明细数量汇总查询 出参〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetImplItemCountRspBo extends BaseRspBo {

    private static final long serialVersionUID = -6232051543262486152L;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 发货数量
     */
    private BigDecimal sendCount;

    /**
     * 到货数量
     */
    private BigDecimal arriveCount;

    /**
     * 拒收数量
     */
    private BigDecimal refuseCount;

    /**
     * 退货数量
     */
    private BigDecimal returnCount;

    /**
     * 验收数量
     */
    private BigDecimal acceptanceCount;

    /**
     * 售后在途数量
     */
    private BigDecimal afterServingCount;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}


